import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  Select
} from "antd";
import {
  findOfflineOrOnlinePolicy,
} from '../../../../../services/api';
const { Option } = Select;
@Form.create()
export default class Messages extends Component {
  constructor(props) {
    super(props);
    this.state = {
      policeys: [],
      orderId: '',
      businessType: 0
    }
  }
  componentWillMount() {
    // 根据路径判断保险类型
    if (window.location.pathname.includes('linbaoinsurancemanagement')) {
      this.setState({ businessType: 1 }); // 临保保险
    } else if (window.location.pathname.includes('insurancemanagement')) {
      this.setState({ businessType: 0 }); // 团体保险
    }
  }
  componentDidMount() {
    this.__getPolicy();
    this.props.onSearch(this.props.form.getFieldsValue(), this.state.orderId);
  }

  componentDidUpdate(prevProps) {
    // 当tlkProjectId变化时，重新获取线上线下保单
    if (prevProps.tlkProjectId !== this.props.tlkProjectId) {
      this.__getPolicy();
    }
  }

  __getPolicy() {
    // 线上线下保单
    findOfflineOrOnlinePolicy({
      businessType: this.state.businessType,
      tlkProjectId: this.props.tlkProjectId || undefined
    }).then(res => {
      const onlineList = res.data;
      onlineList.unshift({
        comInsId: "",
        label: "全部",
        orderId: "",
        buyMode: 0   // 不区分线上线下
      });
      this.setState({
        policeys: onlineList
      });
    });
  }
  _search = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        // 搜索的时候重置为第一页
        values.pageNumber = 1;
        this.props.onSearch(values, this.state.orderId, 'search');
      }
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    const data = this.props.form.getFieldsValue();
    this.props.onSearch(data, this.state.orderId);
}
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item label="选择保单">
          {getFieldDecorator('comInsId', {
            initialValue: ''
          })(
            <Select onChange={(value, e) => {
              const key = e.key;
              this.setState({
                orderId: this.state.policeys[key].orderId
              });
            }} style={{minWidth: 600}} >
              {this.state.policeys.map((item, index) => {
                return (
                  <Option key={index} value={item.comInsId}>{item.label}</Option>
                );
              })}
            </Select>
          )}
        </Form.Item>
        <Form.Item label="关键词">
          {getFieldDecorator('keyword', {
            initialValue: ''
          })(
            <Input placeholder="请输入姓名/身份证号" />
          )}
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>
      </Form>
    );
  }
}