import React, { PureComponent } from 'react';
import style from 'styled-components';
import {
  Modal,
  Button,
  Alert,
  Card,
  List,
  Avatar,
  Icon,
  Form,
  Input,
  Select
} from 'antd';
import {
  systemComVaseInfoGet //获取公司的省份信息
} from '../../../services/api';
import './InsuranceMangerment.less';
const productlistdata = [
  {
    title: '安保无忧全年意外险（60万计划）'
  }
];
const FormItem = Form.Item;
const { Option } = Select;
@Form.create()
// @connect(state => ({
//   profile: state.profile
// }))
export default class InsurancePurchase extends PureComponent {
  // 获取方案书
  constructor(props, context) {
    super(props, context);
    this.state = {
      policyHolder: '百川信（厦门）网络信息服务有限公司', //投保人
      contacts: '', //联系人
      contactsinformation: '', //联系方式
      enterprises: '', //企业人数
      premium: [], //保障金额
      amountmoney: [], //保费
      accessbookvisible: false, //获取方案书
      disabled: true,
      productvisible: false, //选择产品
      insurancetipvisible: false, //通知-购买引导
      guranteevisible: false,
      bookvisible: false, //通知-方案书
      insurancetipsvisible: false, //提示模板
      choosecheckvisible1: false,
      choosecheckvisible2: false,
      choosecheckvisible3: false,
      choosecheckvisible4: false,
      buyinsurance: false, //是否购买保险
      fillinformation: true, //是否填写信息
      // permiunaccord:true,//保障金额是否符合要求
      regProvinceId: '', //企业所在省份
      regProvinceName: '', //所在省份对应的落地项目
      regProvinceAllName: '' //所在省份对应的落地项目(全称)
    };
  }

  /******************************生命周期******************************/
  componentDidMount() {
    //450000-->广西壮族自治区,610000-->陕西省,640000-->宁夏回族自治区
    systemComVaseInfoGet({}).then(
      response => {
        const regProvince = response.data.regProvince;
        const regProvinceName =
          regProvince === 450000
            ? '广西'
            : regProvince === 610000
            ? '陕西省'
            : regProvince === 640000
            ? '宁夏'
            : '';
        const regProvinceAllName =
          regProvince === 450000
            ? '广西壮族自治区'
            : regProvince === 610000
            ? '陕西省'
            : regProvince === 640000
            ? '宁夏回族自治区'
            : '';
        this.setState({
          regProvinceName,
          regProvinceId: regProvince,
          regProvinceAllName
        });
      },
      err => {
        console.log(err);
      }
    );
  }

  // 温馨提示
  showsurancetipsModal = () => {
    this.setState({
      insurancetipsvisible: true
    });
  };
  handlesuranceOk = e => {
    this.setState({
      insurancetipsvisible: false,
      buyinsurance: true,
      fillinformation: true,
      accessbookvisible: true
    });
  };
  handleonline = e => {
    this.setState({
      insurancetipsvisible: false,
      buyinsurance: true,
      fillinformation: true,
      productvisible: false
    });
  };
  handlesurancetipxCancel = e => {
    this.setState({
      insurancetipsvisible: false,
      buyinsurance: true,
      fillinformation: true
      // insurancetipvisible:true,
    });
  };
  handlesurancetipCancel = e => {
    this.setState({
      // insurancetipvisible: false,
      insurancetipsvisible: false,
      buyinsurance: true,
      fillinformation: true
    });
    this.props.history.push(
      // "/InsuranceManagement/InsuranceScheme"
      // 跳转到1-4-4
      '/Company/InsuranceBasic'
    );
  };
  // 温馨提示1
  showguranteeModal = () => {
    this.setState({
      guranteevisible: true
    });
  };
  handleguranteeOk = e => {
    this.setState({
      guranteevisible: false
    });
  };
  handleguranteeCancel = e => {
    this.setState({
      guranteevisible: false
    });
  };
  handleOk = e => {
    this.setState({
      // visible: false,
      insurancetipvisible: false,
      bookvisible: false
    });
  };
  handleCancel = e => {
    this.setState({
      // visible: false,
      insurancetipvisible: false,
      bookvisible: false
    });
  };
  // 选择产品
  showproductModal = () => {
    this.setState({
      productvisible: true
    });
  };
  handleproductOk = e => {
    this.setState({
      productvisible: false
    });
    this.props.history.push('/InsuranceManagement/InsuranceScheme');
  };
  handleproductxCancel = e => {
    this.setState({
      productvisible: false
    });
  };
  handleproductCancel = e => {
    this.setState({
      productvisible: false,
      accessbookvisible: true
    });
  };
  showsurancetipModal = () => {
    this.setState({
      insurancetipvisible: true
    });
  };
  // 通知-方案书
  showbookModal;
  showbookModal = () => {
    this.setState({
      bookvisible: true
    });
  };
  // state = { accessbookvisible:false, }
  // 获取方案书
  showaccessbookModal = () => {
    this.setState({
      accessbookvisible: true
    });
  };
  handlereducepeopleOk = e => {
    this.setState({
      accessbookvisible: false,
      productvisible: true
    });
  };
  handlereducepeopleCancel = e => {
    this.setState({
      accessbookvisible: false
    });
  };
  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        console.log('表单提交中.........', values);
      }
    });
  };
  // 选择产品（1个）
  choosecheck1 = () => {
    if (this.state.choosecheckvisible1 === false) {
      this.setState({
        choosecheckvisible1: true,
        choosecheckvisible2: false,
        choosecheckvisible3: false,
        choosecheckvisible4: false
      });
    } else {
      this.setState({
        choosecheckvisible1: false
      });
    }
  };
  choosecheck2 = () => {
    if (this.state.choosecheckvisible2 === false) {
      this.setState({
        choosecheckvisible1: false,
        choosecheckvisible2: true,
        choosecheckvisible3: false,
        choosecheckvisible4: false
      });
    } else {
      this.setState({
        choosecheckvisible2: false
      });
    }
  };
  choosecheck3 = () => {
    if (this.state.choosecheckvisible3 === false) {
      this.setState({
        choosecheckvisible1: false,
        choosecheckvisible2: false,
        choosecheckvisible3: true,
        choosecheckvisible4: false
      });
    } else {
      this.setState({
        choosecheckvisible3: false
      });
    }
  };
  choosecheck4 = () => {
    if (this.state.choosecheckvisible4 === false) {
      this.setState({
        choosecheckvisible1: false,
        choosecheckvisible2: false,
        choosecheckvisible3: false,
        choosecheckvisible4: true
      });
    } else {
      this.setState({
        choosecheckvisible4: false
      });
    }
  };
  render() {
    const { submitting } = this.props;
    const { getFieldDecorator } = this.props.form;
    const identification =
      this.state.regProvinceId === 610000
        ? '陕公治〔2017〕182 号'
        : this.state.regProvinceId === 450000
        ? '桂公网传〔2017〕110 号'
        : '';
    const reparations =
      this.state.regProvinceId === 450000
        ? '37'
        : this.state.regProvinceId === 610000
        ? '38'
        : this.state.regProvinceId === 640000
        ? '30'
        : '';
    const formItemLayout = {
      labelCol: {
        xs: { span: 7 },
        sm: { span: 7 }
      },
      wrapperCol: {
        xs: { span: 15 },
        sm: { span: 15 },
        md: { span: 15 }
      }
    };
    const submitFormLayout = {
      wrapperCol: {
        xs: { span: 15, offset: 7 },
        sm: { span: 15, offset: 7 }
      }
    };
    const amountmoney = [
      { code: 0, price: '20万' },
      { code: 1, price: '40万' },
      { code: 2, price: '60万' }
    ];
    const premium = [
      { code: 0, price: '600元（不含600元）' },
      { code: 1, price: '400元（不含400元）' },
      { code: 2, price: '200元（不含200元）' }
    ];
    return (
      <Container className="chooseproductlist">
        <div>
          {/* <Button type="primary" onClick={this.showproductModal}>选择产品</Button> */}
          <Modal
            className="chooseproductlist"
            title="选择产品"
            visible={this.state.productvisible}
            onOk={this.handleproductOk}
            onCancel={this.handleproductxCancel}
            footer={[
              <Button key="back" onClick={this.handleproductCancel}>
                上一步
              </Button>,
              <Button
                key="submit"
                type="primary"
                onClick={this.handleproductOk}
              >
                获取
              </Button>
            ]}
          >
            <div className="chooseproduct">
              <Alert message="请选择您感兴趣的产品！" type="info" showIcon />
              <Card onClick={this.choosecheck1}>
                <List
                  itemLayout="horizontal"
                  dataSource={productlistdata}
                  renderItem={item => (
                    <List.Item>
                      <List.Item.Meta
                        avatar={
                          <Avatar src="https://zos.alipayobjects.com/rmsportal/ODTLcjxAfvqbxHnVXCYX.png" />
                        }
                        title={<a href="https://ant.design">{item.title}</a>}
                        description={
                          <div>
                            <div>
                              专为保安公司量身定制，市场少有高额度全保障，365天7X24小时意外身故（伤残）+意外医疗+住院津贴，保安人员的...专为保安公司量身定制，市场少有高额度全保障，365天7X24小时意外身故（伤残）+意外医疗+住院津贴，保安人员的...
                            </div>
                            <div className="premium">
                              保费：<span className="guaranteebig">360</span>
                              <span
                                className="guaranteesm"
                                style={{ marginRight: 20 }}
                              >
                                元/人
                              </span>
                              保障金额：<span className="guaranteebig">60</span>
                              <span className="guaranteebigsm">万</span>
                              {this.state.choosecheckvisible1 === true ? (
                                <Icon
                                  type="check-circle-o"
                                  className="productselect"
                                />
                              ) : (
                                <span />
                              )}
                            </div>
                          </div>
                        }
                      />
                    </List.Item>
                  )}
                />
              </Card>
              <Card onClick={this.choosecheck2}>
                <List
                  itemLayout="horizontal"
                  dataSource={productlistdata}
                  renderItem={item => (
                    <List.Item>
                      <List.Item.Meta
                        avatar={
                          <Avatar src="https://zos.alipayobjects.com/rmsportal/ODTLcjxAfvqbxHnVXCYX.png" />
                        }
                        title={<a href="https://ant.design">{item.title}</a>}
                        description={
                          <div>
                            <div>
                              专为保安公司量身定制，市场少有高额度全保障，365天7X24小时意外身故（伤残）+意外医疗+住院津贴，保安人员的...专为保安公司量身定制，市场少有高额度全保障，365天7X24小时意外身故（伤残）+意外医疗+住院津贴，保安人员的...
                            </div>
                            <div className="premium">
                              保费：<span className="guaranteebig">360</span>
                              <span
                                className="guaranteesm"
                                style={{ marginRight: 20 }}
                              >
                                元/人
                              </span>
                              保障金额：<span className="guaranteebig">60</span>
                              <span className="guaranteebigsm">万</span>
                              {this.state.choosecheckvisible2 === true ? (
                                <Icon
                                  type="check-circle-o"
                                  className="productselect"
                                />
                              ) : (
                                <span />
                              )}
                            </div>
                          </div>
                        }
                      />
                    </List.Item>
                  )}
                />
              </Card>
              <Card onClick={this.choosecheck3}>
                <List
                  itemLayout="horizontal"
                  dataSource={productlistdata}
                  renderItem={item => (
                    <List.Item>
                      <List.Item.Meta
                        avatar={
                          <Avatar src="https://zos.alipayobjects.com/rmsportal/ODTLcjxAfvqbxHnVXCYX.png" />
                        }
                        title={<a href="https://ant.design">{item.title}</a>}
                        description={
                          <div>
                            <div>
                              专为保安公司量身定制，市场少有高额度全保障，365天7X24小时意外身故（伤残）+意外医疗+住院津贴，保安人员的...专为保安公司量身定制，市场少有高额度全保障，365天7X24小时意外身故（伤残）+意外医疗+住院津贴，保安人员的...
                            </div>
                            <div className="premium">
                              保费：<span className="guaranteebig">360</span>
                              <span
                                className="guaranteesm"
                                style={{ marginRight: 20 }}
                              >
                                元/人
                              </span>
                              保障金额：<span className="guaranteebig">60</span>
                              <span className="guaranteebigsm">万</span>
                              {this.state.choosecheckvisible3 === true ? (
                                <Icon
                                  type="check-circle-o"
                                  className="productselect"
                                />
                              ) : (
                                <span />
                              )}
                            </div>
                          </div>
                        }
                      />
                    </List.Item>
                  )}
                />
              </Card>
              <Card onClick={this.choosecheck4}>
                <List
                  itemLayout="horizontal"
                  dataSource={productlistdata}
                  renderItem={item => (
                    <List.Item>
                      <List.Item.Meta
                        avatar={
                          <Avatar src="https://zos.alipayobjects.com/rmsportal/ODTLcjxAfvqbxHnVXCYX.png" />
                        }
                        title={<a href="https://ant.design">{item.title}</a>}
                        description={
                          <div>
                            <div>
                              专为保安公司量身定制，市场少有高额度全保障，365天7X24小时意外身故（伤残）+意外医疗+住院津贴，保安人员的...专为保安公司量身定制，市场少有高额度全保障，365天7X24小时意外身故（伤残）+意外医疗+住院津贴，保安人员的...
                            </div>
                            <div className="premium">
                              保费：<span className="guaranteebig">360</span>
                              <span
                                className="guaranteesm"
                                style={{ marginRight: 20 }}
                              >
                                元/人
                              </span>
                              保障金额：<span className="guaranteebig">60</span>
                              <span className="guaranteebigsm">万</span>
                              {this.state.choosecheckvisible4 === true ? (
                                <Icon
                                  type="check-circle-o"
                                  className="productselect"
                                />
                              ) : (
                                <span />
                              )}
                            </div>
                          </div>
                        }
                      />
                    </List.Item>
                  )}
                />
              </Card>
            </div>
          </Modal>
        </div>
        {/* 提示模板 */}
        <div>
          <Button type="primary" onClick={this.showsurancetipsModal}>
            温馨提示
          </Button>
          {}
          {this.state.buyinsurance == false ||
          this.state.fillinformation == false
            ? this.setState({ insurancetipsvisible: true })
            : this.setState({ insurancetipsvisible: false })}
          <Modal
            className="surancetip"
            title="温馨提示"
            visible={this.state.insurancetipsvisible}
            onOk={this.handlesuranceOk}
            onCancel={this.handlesurancetipxCancel}
            footer={
              this.state.buyinsurance == false
                ? [
                    <Button key="back" onClick={this.handlesurancetipCancel}>
                      已购买保险
                    </Button>,
                    // <Button key="submit" onClick={this.handlesuranceOk}>获取保险方案书</Button>,
                    <Button key="" type="primary" onClick={this.handleonline}>
                      在线购买保险
                    </Button>
                  ]
                : [
                    // <Button key="submit" onClick={this.handlesuranceOk}>申请保险方案书</Button>,
                    <Button key="" type="primary" onClick={this.handleonline}>
                      在线购买保险
                    </Button>
                  ]
            }
          >
            <div>
              <Alert
                message="很遗憾，贵公司未购买保险产品。请依照政策要求购买符合条件的保险产品。"
                type="warning"
                showIcon
              />
            </div>
            <p>
              根据《关于启用{this.state.regProvinceId === 610000 ? '' : '新版'}
              {this.state.regProvinceName}
              {this.state.regProvinceId === 610000 ? '新版' : ''}
              保安服务监管信息系统有关工作的通知》{identification}
              及《保安服务管理条例》第四章第二十条规定，推进落实保安从业单位根据保安服务岗位的风险程度为保安员投保意外伤害保险，保险保障额度应当不低于
              {this.state.regProvinceAllName}人身损害赔偿标准（约{reparations}
              万），并通过本系统及时将投保情况实时向公安机关报备。
            </p>
            <img src="" />
          </Modal>
        </div>
        <div>
          {/* <Button type="primary" onClick={this.showguranteeModal}>温馨提示1</Button> */}
          <Modal
            className="gurantee"
            title="温馨提示"
            visible={this.state.guranteevisible}
            onOk={this.handleguranteeOk}
            onCancel={this.handleguranteeCancel}
            footer={[
              <Button
                key="submit"
                type="primary"
                onClick={this.handleguranteeOk}
              >
                马上查看
              </Button>,
              <Button key="back" onClick={this.handleguranteeCancel}>
                以后再说
              </Button>
            ]}
          >
            <div>
              <Icon type="check-circle-o" className="productselect" />
              <p>
                恭喜贵司，已符合陕西西安地区保安从业单位应为保安员投保的相关政策要求，您还可继续投保为员工提高保障额度。
              </p>
            </div>
          </Modal>
        </div>
        <div>
          {/* <Button type="primary" onClick={this.showsurancetipModal}>通知-购买引导</Button> */}
          <Modal
            className="productguidance"
            title={
              <div>
                <div className="guidanceauthor">
                  <span>来自：</span>
                  <span className="guidancepingtai">百保盾SaaS平台</span>
                </div>
                <span>系统安全提示！</span>
                <div className="guidancetime">
                  <span>12月30日</span>&nbsp;
                  <span>09:00</span>
                </div>
              </div>
            }
            visible={this.state.insurancetipvisible}
            onOk={this.handleOk}
            onCancel={this.handleCancel}
            footer={[
              <Button key="submit" type="primary" onClick={this.handleOk}>
                转发
              </Button>
            ]}
          >
            <div>
              <Alert
                message="系统检测到贵司保险相关信息空白。"
                type="warning"
                showIcon
              />
            </div>
            <img src="" />
            <p>
              根据《关于启用{this.state.regProvinceId === 610000 ? '' : '新版'}
              {this.state.regProvinceName}
              {this.state.regProvinceId === 610000 ? '新版' : ''}
              保安服务监管信息系统有关工作的通知》{identification}
              及《保安服务管理条例》第四章第二十条规定，推进落实保安从业单位根据保安服务岗位的风险程度为保安员投保意外伤害保险，保险保障额度应当不低于
              {this.state.regProvinceAllName}人身损害赔偿标准（约{reparations}
              万），并通过本系统及时将投保情况实时向公安机关报备。
            </p>
            <div className="guidancejump">
              <span />
              <a>在线购买保险</a>
            </div>
            <div className="guidancejump">
              <span />
              <a>申请保险方案书</a>
            </div>
            <div className="guidancejump">
              <span />
              <a>已购买保险信息完善</a>
            </div>
          </Modal>
        </div>
        <div>
          <Button type="primary" onClick={this.showbookModal}>
            通知-方案书
          </Button>
          <Modal
            className="productguidance"
            title={
              <div>
                <div className="guidanceauthor">
                  <span>来自：</span>
                  <span className="guidancepingtai">百保盾SaaS平台</span>
                </div>
                <span>安保无忧全年意外险（30万计划）方案书</span>
                <div className="guidancetime">
                  <span>12月30日</span>&nbsp;
                  <span>09:00</span>
                </div>
              </div>
            }
            visible={this.state.bookvisible}
            onOk={this.handleOk}
            onCancel={this.handleCancel}
            footer={[
              <Button key="submit" type="primary" onClick={this.handleOk}>
                转发
              </Button>
            ]}
          >
            <p style={{ marginTop: 16 }}>
              尊敬的XXXX保安公司：
              <br />
              感谢您对安保无忧全年意外险（30万计划）的亲睐！
              <br />
              为您定制的保险方案书已经生成，可点击以下连接查看。
            </p>
            <div className="guidancejump" style={{ width: 300 }}>
              <span />
              <a>《安保无忧全年意外险（30万计划）方案书》</a>
            </div>
            <div className="guidancejump">
              <span />
              <a>在线购买保险</a>
            </div>
          </Modal>
        </div>
        {/* 获取方案书 */}
        <div>
          {/* <Button type="primary" onClick={this.showaccessbookModal}>获取方案书</Button> */}
          <Modal
            className="accessbook"
            title="获取方案书"
            visible={this.state.accessbookvisible}
            onOk={this.handlereducepeopleOk}
            onCancel={this.handlereducepeopleCancel}
            footer={null}
          >
            <div style={{ paddingBottom: 16 }}>
              <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
                <FormItem {...formItemLayout} label="投保人">
                  {getFieldDecorator('policyHolder', {
                    // {}
                    initialValue: this.state.policyHolder,
                    rules: [{ message: '请填写' }]
                  })(<Input disabled={this.state.disabled} />)}
                </FormItem>
                <FormItem {...formItemLayout} label="联系人">
                  {getFieldDecorator('contacts', {
                    initialValue: this.state.contacts,
                    rules: [
                      { required: true, message: '限制长度20位数字', max: 20 }
                    ]
                  })(<Input placeholder="请填写" />)}
                </FormItem>
                <FormItem {...formItemLayout} label="联系方式">
                  {getFieldDecorator('contactsinformation', {
                    initialValue: this.state.contactsinformation,
                    rules: [
                      { required: true, message: '限制长度11位数字', max: 11 }
                    ]
                  })(<Input placeholder="请填写" />)}
                </FormItem>
                <FormItem {...formItemLayout} label="企业人数">
                  {getFieldDecorator('enterprises', {
                    initialValue: this.state.enterprises,
                    rules: [
                      { message: '限制长度7位数字', type: 'string', max: 7 }
                    ]
                  })(<Input placeholder="请输入" />)}
                </FormItem>
                <FormItem {...formItemLayout} label="保障金额不低于">
                  {getFieldDecorator('amountmoney', {
                    initialValue: this.state.amountmoney,
                    rules: [{ required: true, message: '请选择' }]
                  })(
                    <Select placeholder="请选择">
                      {amountmoney.map((val, index) => {
                        return (
                          <Option key={index} value={val.code}>
                            {val.price}
                          </Option>
                        );
                      })}
                    </Select>
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="保费不超过">
                  {getFieldDecorator('premium', {
                    initialValue: this.state.premium,
                    rules: [{ required: true, message: '请选择' }]
                  })(
                    <Select placeholder="请选择">
                      {premium.map((val, index) => {
                        return (
                          <Option key={index} value={val.code}>
                            {val.price}
                          </Option>
                        );
                      })}
                    </Select>
                  )}
                </FormItem>
                <FormItem {...submitFormLayout} style={{ marginBottom: 0 }}>
                  <Button
                    loading={submitting}
                    onClick={this.handlereducepeopleCancel}
                  >
                    晚点再看
                  </Button>
                  <Button
                    type="primary"
                    style={{ marginLeft: 8 }}
                    htmlType="submit"
                    onClick={this.handlereducepeopleOk}
                  >
                    下一步
                  </Button>
                </FormItem>
              </Form>
            </div>
          </Modal>
        </div>
      </Container>
    );
  }
}
const Container = style.div`
  padding:24px;
`;
