import React, { Component } from "react";

import Wallet from './Wallet';
import Budget from './Budget';
import Reconciliation from './Reconciliation';
import ElectronicReceipt from './ElectronicReceipt';
import { 
  getComWalletAccount
} from '../../../../services/api';

import { gup } from '../../../../utils/utils';

import { Tabs } from "antd";

const { TabPane } = Tabs;

export default class StepFive extends Component {
  constructor(props, context) {
    super(props, context);
    this.state={
      accountInfo: null,
      tab: gup('tab')
    };
  }
  componentDidMount() {
    getComWalletAccount().then(res => {
      this.setState({
        accountInfo: res.data
      });
    });
  }
  render() {
    if(this.state.accountInfo) {
      const { walletAccountNo } = this.state.accountInfo;
      return (
        <Tabs defaultActiveKey={this.state.tab || '1'}>
          <TabPane tab="企业钱包" key="1">
            <Wallet accountInfo={this.state.accountInfo}></Wallet>
          </TabPane>
          <TabPane forceRender={true} tab="收支明细查询" key="2">
            <Budget walletAccountNo={walletAccountNo}></Budget>
          </TabPane>
          <TabPane tab="对账数据查询" key="3">
            <Reconciliation walletAccountNo={this.state.accountInfo.walletAccountNo} />
          </TabPane>
          {
            this.state.tab == 4 && 
            <TabPane tab="电子回单下载" key="4">
              <ElectronicReceipt />
            </TabPane>
          }
        </Tabs>
      );
    }
    return '';
  }
}
