/**
 * 定义公司信息信息窗体
 * @param type:用于一张图
 */
import RreactDom from 'react-dom';
import eventCenter from "@common/events"; // 引入 EventEmitter
import { recordAdd, recordHistory, recordBack, recordRemove, recordTo } from '@common/recordHistory';

export default function (data, type = '', marker) {
  const { mapStyle, backStepInfo, securityResourceData } = this.props
  const { name,companyName,componeyLogo,mobilePhone } = data;
  var content = [];
  const imgHeader = [];
  if (componeyLogo) {
    imgHeader.push("<img src=" + componeyLogo + "/>");
  } else {
    imgHeader.push(
      "<span class='img-span'>" +
      companyName.substring(companyName.length - 2, companyName.length) +
      "</span>"
    );
  }
  content.push(
    "<div style='display:flex'><div class='comoneye-logo'>" +
    imgHeader +
    "</div><div class='content-text'><div class='text'>公司名称：" +
    "<span>"+companyName +"</span>"+
    "</div><div class='content-text'><div class='text'>法人/负责人：" +
    "<span>"+(name ? name : '') +"</span>"+
    "</div><div class='content-text'><div class='text'>联系电话：" +
    "<span>"+(mobilePhone ? mobilePhone : '') +"</span>"+
    "</div></div>"
  );
  content.join("<br/>");
  var infoDiv = document.createElement("div");
  infoDiv.className = mapStyle;
  var info = document.createElement("div");
  info.className = "content-window-card-componey";
  infoDiv.appendChild(info);
  //可以通过下面的方式修改自定义窗体的宽高
  //  info.style.width = "400px";
  // 定义内容
  var middle = document.createElement("div");
  middle.className = "info-middle";
  middle.innerHTML = content;
  info.appendChild(middle);
  //定义关闭按钮
  // var detail = document.createElement("div");
  // detail.className = "close-div";
  // var a = document.createElement("a");
  // a.innerHTML = "x";
  // a.onclick = () => {
  //   // this.state.map.clearInfoWindow();
  //   //因为police的图层的打点跟列表的选中，没有做更多处理，直接传选中点的信息在这更改，避免需要在生命周期中监听修改的麻烦
  //   if (type == 'police') {
  //     this.clear('setPoliceSelectIndex')
  //     marker.setContent(
  //       '<div class="amap_lib_placeSearch_poi poibox-icon">' +
  //       marker.w.indexText +
  //       "</div>"
  //     );
  //   } else {
  //     this.clear('setPersonSelectIndex')
  //   }
  // };
  // detail.appendChild(a);
  // info.appendChild(detail);
  //定义2个信息弹框按钮
  var top = document.createElement("div");
  top.className = "info-button";
  var button21 = document.createElement("span");
  button21.className = "button";
  button21.innerHTML = "驻勤点信息";
  button21.onclick = () => {
    recordAdd({
      from: 'CreateComponeyInfoWindow',
      to: 'ComponeyInfo',
      fromData: data,
      toID: 'attendancePoints'
    });
    this.props.dispatch({
      type: 'command/clearInfoWindow',
      payload: false
    })
    eventCenter.emit('initRightDataModule');
    let datas = JSON.parse(JSON.stringify(data));
    datas.clickType = 'attendancePoints';
    this.props.dispatch({
      type: 'command/setSelectComponeyInfo',
      payload: datas
    })
    this.props.dispatch({
      type: "command/setMapLayerSwitchState",
      payload: {
        type: 'searchViews',
        value: false
      },
    });
  };
  var button22 = document.createElement("span");
  button22.className = "button";
  button22.innerHTML = "人员信息";
  button22.onclick = () => {
    recordAdd({
      from: 'CreateComponeyInfoWindow',
      to: 'AttendInfo',
      fromData: data,
      toID: 'personnel'
    });
    this.props.dispatch({
      type: 'command/clearInfoWindow',
      payload: false
    })
    eventCenter.emit('initRightDataModule');
    let datas = JSON.parse(JSON.stringify(data));
    console.log('人员信息', datas);
    datas.clickType = 'personnel';
    this.props.dispatch({
      type: 'command/setSelectComponeyInfo',
      payload: datas
    })
    this.props.dispatch({
      type: "command/setMapLayerSwitchState",
      payload: {
        type: 'searchViews',
        value: false
      },
    });
  };
  // 定义返回按钮
  if (recordHistory.length > 0) {
    var backBtn = document.createElement("span");
    backBtn.className = "back-btn"
    backBtn.innerHTML = "返回";
    backBtn.onclick = () => {
      eventCenter.emit('addPictueMarks', {
        data: {
          data: [],
        },
        type: 'securityResource'
      });
      this.props.dispatch({
        type: 'command/setSelectComponyList',
        payload:  []
      })
      this.props.dispatch({
        type: 'command/setSelectComponeyInfo',
        payload: {}
      })
      this.props.dispatch({
        type: 'command/setSelectAttendInfo',
        payload: {}
      })
      recordBack({
        from: 'ComponeyInfo',
        callback: (result)=>{
          switch (result.from) {
            case "CreateTrajectoryInfoWindow":
              recordBack({
                from: result.from,
                callback: (result)=>{
                  const data = JSON.parse(JSON.stringify(result));
                  recordRemove({
                    from: result.from,
                    toID: result.toID
                  })
                  recordTo(data, that);
                }
              });
              break;
            case "CreateAttendPointInfoWindow":
              const data = JSON.parse(JSON.stringify(result));
              recordRemove({
                from: result.from,
                toID: result.toID
              })
              recordTo(data, that);
              break;
            case "CreateComponeyInfoWindow":
              recordBack({
                from: result.from,
                callback: (result)=>{
                  const data = JSON.parse(JSON.stringify(result));
                  recordRemove({
                    from: result.from,
                    toID: result.toID
                  })
                  recordTo(data, that);
                }
              });
              break;
          }
        }
      });
    }
    info.appendChild(backBtn);
  }
  top.appendChild(button21);
  top.appendChild(button22);
  info.appendChild(top);
  // 定义底部内容
  var bottom = document.createElement("div");
  bottom.className = "info-bottom";
  bottom.style.position = "relative";
  bottom.style.top = "19px";
  bottom.style.margin = "0 auto";
  //  var sharp = document.createElement("img");
  //  sharp.src = "https://webapi.amap.com/images/sharp.png";
  var sharp = document.createElement("div");
  sharp.className = "sharp";
  bottom.appendChild(sharp);
  info.appendChild(bottom);
  return infoDiv;
}
