// 南宁的轨迹绘画
import { transformTimestamp } from '../../../../utils/utils'
import RreactDom from 'react-dom';
import React, { Component } from "react";
import {Spin} from 'antd';
import gcoord from 'gcoord';//使用gcoord转换坐标--WGS84坐标转化为高德GCJ02坐标
export default function (pointData) {
  removePathSimplifierIns()//先清除重置地图上的轨迹路线
  console.log(pointData)
  const _this = this
  let resultArray = []
  showLoading()////绘制loading加载状态
  new Promise((resolve, reject) => {
    pointData.forEach((item, index) => {
      let longitude = item.longitude / (3600 * 100)
      let latitude = item.latitude / (3600 * 100)
      const gps = [longitude, latitude]
      var result = gcoord.transform(
        gps,    // 经纬度坐标
        gcoord.WGS84,// 当前坐标系--WGS84(国际通用)
        gcoord.GCJ02 // 目标坐标系--高德地图GCJ02
      );
      console.log('result转换坐标', result);  //返回 [116.41661560068297, 39.92196580126834]
      var time = transformTimestamp(item.time)//js将2021-08-21T10:00:18.000+00:00转换成年月日时分秒
      var obj = { time, lnglat: result }
      resultArray.push(obj)
      resolve(resultArray)
    })
  }).then(resultArray => {
    console.log('resultArray', resultArray)
    AMapUI.load(['ui/misc/PathSimplifier'], function (PathSimplifier) {
      if (!PathSimplifier.supportCanvas) {
        alert('当前环境不支持 Canvas！');
        return;
      }
      // 删除loading组件
      const divs = document.getElementsByClassName('nanNing_loading');
      if (divs) {
        Reflect.apply(Array.prototype.forEach, divs, [item => {
          RreactDom.unmountComponentAtNode(item);
          document.body.removeChild(item);
        }]);
      }
      var defaultRenderOptions = {
        renderAllPointsIfNumberBelow: 100,
        pathTolerance: 2,
        keyPointTolerance: 0,
        pathLineStyle: {
          lineWidth: 3,
          strokeStyle: '#0E70FF',
          borderWidth: 1,
          borderStyle: '#eeeeee',
          dirArrowStyle: false
        },
      };
      var pathSimplifierIns = new PathSimplifier({
        zIndex: 100,
        //autoSetFitView:false,
        map: _this.state.map, //所属的地图实例
        getPath: function (pathData, pathIndex) {
          console.log('pathData.path', pathData.path)
          var lnglatList = [];
          pathData.path.forEach((its, index) => {
            lnglatList.push(its.lnglat)
          })
          return lnglatList;
        },
        getHoverTitle: function (pathData, pathIndex, pointIndex) {
          if (pointIndex >= 0) {
            return pathData.path[pointIndex].time
          }
        },
        renderOptions: defaultRenderOptions
      });
      window.pathSimplifierIns = pathSimplifierIns;
      //设置数据
      pathSimplifierIns.setData([{
        name: '路线轨迹',
        path: resultArray
      }]);
      //对第一条线路（即索引 0）创建一个巡航器
      var navg1 = pathSimplifierIns.createPathNavigator(0, {
        loop: false, //循环播放
        speed: 10000 //巡航速度，单位千米/小时
      });
      navg1.start();

    })
  })
}

//清除地图上的轨迹路线
export function removePathSimplifierIns() {
  if (window.pathSimplifierIns) {
    window.pathSimplifierIns.setData([]);
  }
}

//绘制loading加载状态
function showLoading(props) {
  const div = document.createElement('div');
  div.setAttribute('class', 'nanNing_loading');
  div.style.textAlign = 'center'
  div.style.top = '50%'
  div.style.transform = 'translateY(-50%)'
  div.style.position = 'relative'
  document.body.appendChild(div);
  RreactDom.render(<NanNingLoading  {...props} />, div);
}

class NanNingLoading extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {

    }
  }
  render() {
    return (
      <div> <Spin tip='正在绘制轨迹...' /></div>
    )
  }
}