/**
 * 切换地图按钮
 */
import React, { Component } from 'react';
import { Row, Col, Popover, Tooltip } from "antd";
import { connect } from "dva";
@connect((state) => ({
  mapStyle: state.command.mapStyle,
}))
export default class SwitchStyle extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      satellite: true
    };
  }
  componentDidMount(){
    // if(this.props.layerSatatus !=="aPicture"){
    //   this.props.setSatellite(false)
    // }
  }
  hide = () => {
    this.setState({
      visible: false,
    });
  };
  handleVisibleChange = visible => {
    this.setState({ visible });
  };
  switch(param) {
    const { onSwitch } = this.props;
    this.hide()
    onSwitch && onSwitch(param);
    this.props.dispatch({
      type: 'command/setMapStyle',
      payload: param
    })
    if (param == 'satellite') {
      this.setState({
        satellite: true
      })
    } else {
      this.setState({
        satellite: false
      })
    }
  }
  render() {
    const { mapStyle, layerStatus } = this.props;
    const { satellite } = this.state;
    const content = (
      <div>
        {/* TAG: 根据需求437，去除功能 */}
        {/* <div className={mapStyle == 'dark' && !satellite ? 'map-switch selectedMap' : 'map-switch'} onClick={() => {
          this.switch('dark')
        }}>深色地图</div> */}
        <div className={mapStyle == 'normal' && !satellite ? 'map-switch selectedMap' : 'map-switch'} onClick={this.switch.bind(this, 'normal')}>浅色地图</div>
        {
          layerStatus == "aPicture" &&
          <div className={satellite ? 'map-switch selectedMap' : 'map-switch'} onClick={this.switch.bind(this, 'satellite')} >卫星地图</div>
        }
      </div>
    );
    return (
      <div className="switch map">
        <Tooltip title="地图切换">
          <div className="layer-btn">
            <Popover
              placement="bottom"
              content={content}
              title=""
              trigger="click"
              visible={this.state.visible}
              onVisibleChange={this.handleVisibleChange}
            >
              <img
                className="layer-img"
                src={
                  this.state.visible
                    ? require("../../../assets/images/prevention/style-click.png") :
                    mapStyle == 'dark' ? require("../../../assets/images/prevention/style-white.png")
                      : require("../../../assets/images/prevention/style.png")
                }
              ></img>
            </Popover>
          </div>
        </Tooltip>
      </div>
    );
  }
}
