/**
 * 切换搜索框
 */
 import React, { Component } from 'react';
 import { Row, Col, Popover } from "antd";
 import { connect } from "dva";
 @connect((state) => ({
   mapStyle: state.command.mapStyle,
   switchOpenStatus: state.command.switchOpenStatus,
 }))
 export default class SwitchSearch extends Component {
   constructor(props) {
     super(props);
     this.state = {
      
     }; 
   }
   changeSearch(){
     this.props.dispatch({
       type: "command/setSwitchOpenStatus",
       payload: {
         type: 'search',
         value: !this.props.switchOpenStatus.search
       },
     });
   }
   render() {
     const {mapStyle} = this.props
     return (
       <div className={mapStyle}>
         <div className="switch map">
           <Row className="vet-row">
             <Col
               className="vet-col"
               span={6}
               style={{ cursor: 'pointer' }}
               onClick={this.changeSearch.bind(this)}
             >
               <img
                   style={{
                     width: '16px',
                     height: '16px',
                   }}
                   src={
                     // this.state.visible
                     this.props.switchOpenStatus.search
                       ? require("../../../assets/images/prevention/search-active.png") :
                       mapStyle == 'dark' ? require("../../../assets/images/prevention/search-white.png")
                         : require("../../../assets/images/prevention/search-dark.png")
                   }
                 ></img>
             </Col>
           </Row>
         </div>
       </div>
     );
   }
 }
 