/**
 * 所有，下左右按钮的切换
 */
import React, { Component } from "react";
import { Row, Col } from "antd";
import "./index.less";
import { connect } from "dva";

const _CHANGE_STATUS = ['all', 'left', 'down', 'right'];
@connect((state) => ({
  switchOpenStatus: state.command.switchOpenStatus,
  mapStyle: state.command.mapStyle
}))
export default class SwitchOpen extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentDidMount() { }
  componentWillReceiveProps(nextPorps) {

  }

  changeSwitchStatus(param) {
    this.props.dispatch({
      type: "command/setSwitchOpenStatus",
      payload: {
        type: param,
        value: !this.props.switchOpenStatus[param]
      },
    });
  }
  // 渲染不同状态下的图标显示
  _renderPicture(param, pictureName) {
    const { mapStyle } = this.props
    switch (param) {
      case true:
        return require("../../../assets/images/prevention/" + pictureName + "-click.png")
      case false:
        if (mapStyle == 'dark') {
          return require("../../../assets/images/prevention/" + pictureName + "-white.png")
        } else {
          return require("../../../assets/images/prevention/" + pictureName + ".png")
        }
    }
  }
  render() {
    const { all, down, left, right } = this.props.switchOpenStatus
    return (
        <div className="switch vectorgraph">
          {_CHANGE_STATUS.map((value)=>{
            let status = value == 'all' ? all :
              value == 'left' ? left :
              value == 'down' ? down :
              value == 'right' ? right : '';
            return <div className="layer-btn" onClick={this.changeSwitchStatus.bind(this, value)}>
              <img
                className="layer-img"
                src={
                  this._renderPicture(status, value)
                }
              />
            </div>
          })}
        </div>
    );
  }
}
