/**
 * 切换地图3D按钮
 */
import React, { Component } from 'react';
import { connect } from "dva";
import { Row, Col, Popover, Tooltip } from "antd";
import CityCascader from '@gis/components/CityCascader';
@connect((state) => ({
  mapStyle: state.command.mapStyle,
  switchOpenStatus: state.command.switchOpenStatus,
  gITFPoint: state.command.gITFPoint,
  object3Dlayer: state.command.object3Dlayer
}))
export default class Switch3D extends Component {
  constructor(props) {
    super(props);
    this.state = {
      areaSelect: false
    };
  }
  change3D(){
    let is3D = !this.props.switchOpenStatus.is3D;
    if(is3D){
      this.props.localMap.setPitch(50)
    }else{
      this.props.localMap.setPitch(0)
      if(this.props.object3Dlayer){
        let gITFPoint = this.props.gITFPoint.map(item=>{
          item.isShow = false;
          if(item.cityMeshes){
            this.props.object3Dlayer.remove(item.cityMeshes)
          }
          return item
        })
        this.props.dispatch({
          type: "command/changeGITFPoint",
          payload: gITFPoint,
        });
      }
    }
    this.props.dispatch({
      type: "command/setSwitchOpenStatus",
      payload: {
        type: 'is3D',
        value: is3D
      },
    });
  }

  //根据cityname、adcode、citycode设置地图位置
  onChangeCity(value){
    const { _thisGIS } = this.props;
    const { name, code } = value;
    if (name.length == 0 && code.length == 0) {
      return _thisGIS.state.map.setZoom(6);
    }
    const cityCode = code[code.length -1];
    const cityName = name[name.length -1]['label'];
    if (cityName == '市辖区') {
      _thisGIS.state.map.setCity(name[0]['label']);
    } else {
      _thisGIS.state.map.setCity(cityName);
    }
    this.setState({
      areaSelect: false
    })
  }
  _handleVisibleChange = visible => {
    this.setState({ areaSelect: visible });
  };
  render() {
    const {mapStyle} = this.props
    const content = (
      <div className="area-city">
        <CityCascader onChange={this.onChangeCity.bind(this)} />
      </div>
    );
    return (
      <div className="switch map">
        <Tooltip title="区域选择">
          <div className="layer-btn">
            <Popover
                placement="bottom"
                content={content}
                title=""
                trigger="click"
                visible={this.state.areaSelect}
                onVisibleChange={this._handleVisibleChange}
              >
                <img
                  className="layer-img"
                  src={
                    this.state.areaSelect
                      ? require("@assets/images/prevention/area-click.png") : require("@assets/images/prevention/area.png")
                  }
                />
            </Popover>
          </div>
        </Tooltip>
      </div>
    );
  }
}
