/**
 * 切换地图3D按钮
 */
import React, { Component } from 'react';
import { connect } from "dva";
import { Row, Col, Popover, Tooltip } from "antd";
@connect((state) => ({
  mapStyle: state.command.mapStyle,
  switchOpenStatus: state.command.switchOpenStatus,
  gITFPoint: state.command.gITFPoint,
  object3Dlayer: state.command.object3Dlayer
}))
export default class Switch3D extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }
  change3D(){
    let is3D = !this.props.switchOpenStatus.is3D;
    if(is3D){
      this.props.localMap.setPitch(50)
    }else{
      this.props.localMap.setPitch(0)
      if(this.props.object3Dlayer){
        let gITFPoint = this.props.gITFPoint.map(item=>{
          item.isShow = false;
          if(item.cityMeshes){
            this.props.object3Dlayer.remove(item.cityMeshes)
          }
          return item
        })
        this.props.dispatch({
          type: "command/changeGITFPoint",
          payload: gITFPoint,
        });
      }
    }
    this.props.dispatch({
      type: "command/setSwitchOpenStatus",
      payload: {
        type: 'is3D',
        value: is3D
      },
    });
    if(this.props.gITFPoint&&this.props.gITFPoint.length){
      let lng=this.props.gITFPoint[0].lng;//经度
      let lat=this.props.gITFPoint[0].lat//纬度
      setTimeout(() => { //3d模型自动定位到第一个模型的经纬度     
        this.props.localMap.setCenter([lng,lat])  //设置中心位置
        this.props.localMap.setZoom(16)    //设置缩放比例，越大看到具体
      }, 100);
    }
    
  }
  render() {
    const {mapStyle} = this.props
    return (
      <div className="switch map">
        <Tooltip title="3D模型">
          <div className="layer-btn" onClick={this.change3D.bind(this)}>
            <img
              className="layer-img"
              src={
                // this.state.visible
                this.props.switchOpenStatus.is3D
                  ? require("@assets/images/prevention/3d-click.png") :
                  mapStyle == 'dark' ? require("@assets/images/prevention/3d-white.png")
                    : require("@assets/images/prevention/3d.png")
              }
            />
          </div>
        </Tooltip>
      </div>
    );
  }
}
