/**
 *
 */
import React, { Component } from "react";
import { Row, Col, Input, Form, Switch, Checkbox, Icon, message } from "antd";
import {
  formItemLayout,
  minFormItemLayout,
} from "../../../constants/formItemLayout";
import Record from "../Record/index";
const { TextArea } = Input;
@Form.create()
export default class ModalView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedPoints: props.selectedPoints,
      dispatchType: props.dispatchType,
      schedulingName: '',
      schedulingContent: '',
      openRecord: false,//是否开启录制按钮
    };
  }
  componentDidMount() { }
  componentWillReceiveProps(nextPorps) {
    this.setState({
      selectedPoints: nextPorps.selectedPoints,
      dispatchType: nextPorps.dispatchType,
      selectRecordId: '',//选中的人员id
    })
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <div>
        <div className="photo">
          {this.state.selectedPoints.map((item, index) => {
            return (
              <div className="gutter-row" key={index}>
                <div className="gutter-box">
                  {item.photoUrl ? (
                    <img className="avator" src={item.photoUrl}></img>
                  ) : (
                      <span className="avator span-header">
                        {item.name
                          ? item.name.substring(
                            item.name.length - 2,
                            item.name.length
                          )
                          : ""}
                      </span>
                    )}
                  <div className="name">{item.name}</div>
                </div>
              </div>
            );
          })}
        </div>
        {
          this.state.dispatchType !== "video" && <div style={{color:'#ecad20'}}>注意：请确保所有人员都已经完成基础信息初始化，否则该人员无法成功加入群组</div>
        }
        <div className="dispatch-content">
          <h2>
            {this.state.dispatchType === "text"
              ? "文字调度"
              : this.state.dispatchType === "voice"
                ? "语音调度"
                : this.state.dispatchType === "video"
                  ? "视频调度"
                  : ""}
          </h2>
          <Form.Item
            {...formItemLayout}
            label="调度事由"
            style={{ marginTop: 24 }}
          >
            {getFieldDecorator("schedulingName", {
              rules: [
                {
                  required: true,
                  message: "请输入调度任务名称",
                },
              ],
            })(
              <Input
                onChange={(e) => {
                  this.props.schedulingName(e.target.value)
                  this.setState({
                    schedulingName: e.target.value,
                  });
                }}
              ></Input>
            )}
          </Form.Item>
          {/* 如果是文字调度，需要填调度任务内容 */}
          {this.state.dispatchType === "text" ? (
            <Form.Item
              {...formItemLayout}
              label="调度任务内容"
              style={{ marginTop: 24 }}
            >
              {getFieldDecorator("schedulingContent", {
                rules: [
                  {
                    required: true,
                    message: "请输入调度任务内容",
                  },
                ],
              })(
                <TextArea
                  rows={4}
                  onChange={(e) => {
                    this.setState({
                      schedulingContent: e.target.value,
                    });
                    this.props.schedulingContent(e.target.value);
                  }}
                />
              )}
            </Form.Item>
          ) : //如果是语音调度，需要有语音弹框
            this.state.dispatchType === "voice" ? (
              <div className="video">
                {this.state.showRecord ? (
                  <Record
                    where="index"
                    sendSound={(url, time) => {
                      //点击了发送
                      if (this.state.schedulingName.trim().length === 0) {
                        message.warning("请输入调度任务名称");
                      } else {
                        //创建音频的群组
                        //   this.voiceGroup(url, time);
                        this.props.voiceGroup(url, time);
                      }
                    }}
                    startRecord={this.state.showRecord}
                  />
                ) : (
                    <div>
                      <span
                        className="video-button"
                        onClick={() => {
                          this.props.showRecord(true);
                          this.setState({
                            showRecord: true,
                          });
                        }}
                      >
                        <Icon
                          type="audio"
                          style={{ color: "#ffffff", fontSize: "45px" }}
                        />
                      </span>
                      <div className="warning">请点击按钮开始录音</div>
                    </div>
                  )}
              </div>
            ) : (
                <div>
                  {/* //视频调度 */}
                  {/* <Form.Item
                    {...minFormItemLayout}
                    label="是否开启屏幕录制"
                    style={{ marginTop: 24 }}
                  >
                    {getFieldDecorator("record", {
                      rules: [
                        {
                          required: true,
                          message: "请选择是否开启屏幕录制",
                        },
                      ],
                    })(
                      <Switch
                        checkedChildren="开"
                        unCheckedChildren="关"
                        onChange={(value) => {
                          console.log(value);
                          this.setState({
                            openRecord: value
                          })
                        }}
                      />
                    )}
                  </Form.Item> */}
                  {
                    this.state.openRecord && <Checkbox.Group style={{ width: '100%' }} onChange={(e) => {
                      this.props.onCheckPerRecord(e)
                      if (e.length > 16) {
                        message.error("录制人数限制16个以内,请重新选择")
                      }
                    }}>
                      <div className="photo mini">
                        {this.state.selectedPoints.map((item, index) => {
                          return (
                            <div className="gutter-row" key={index}>
                              <div className="gutter-box">
                                <Checkbox value={item.mobilePhone}>
                                  {item.photoUrl ? (
                                    <img className="avator" src={item.photoUrl}></img>
                                  ) : (
                                      <span className="avator span-header">
                                        {item.name
                                          ? item.name.substring(
                                            item.name.length - 2,
                                            item.name.length
                                          )
                                          : ""}
                                      </span>
                                    )}
                                  <div className="name">{item.name}</div>
                                </Checkbox>
                              </div>
                            </div>
                          );
                        })}</div>
                    </Checkbox.Group>
                  }
                </div>
              )}
        </div>
      </div>
    );
  }
}
