/**
 * 搜索、资源图层按钮
 */
import React, { Component } from "react";
import { Row, Col, Tooltip } from "antd";
import "./index.less";
import { connect } from "dva";
import { recordClean } from '@common/recordHistory';
import eventCenter from "@common/events"; // 引入 EventEmitter

@connect((state) => ({
  switchOpenStatus: state.command.switchOpenStatus,
  mapLayerSwitchState: state.command.mapLayerSwitchState,
  mapStyle: state.command.mapStyle
}))
export default class LayerExtensionBtn extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentDidMount() { }
  componentWillReceiveProps(nextPorps) {

  }

  changeSwitchStatus(param) {
    recordClean();
    // 清除地图所有标记
    eventCenter.emit('clearMapTag');
    eventCenter.emit('clearMapTag', 'searchAddress');
    // 初始化右侧数据模块
    eventCenter.emit('initRightDataModule');
    eventCenter.emit('clearMapModal', 'ComponeyInfo');
    eventCenter.emit('clearSearchCircle');
    eventCenter.emit('clearMapModal', 'AttendInfo');
    eventCenter.emit('APictureChecked', {
      type: 'securityCompanyChecked',
      checked: false
    });
    eventCenter.emit('APictureChecked', {
      type: 'securityResourceChecked',
      checked: false
    });
    this.props.dispatch({
      type: "command/initMapLayerSwitchState",
    });
    if (param == 'searchViews') {
      this.props.dispatch({
        type: "command/setMapLayerSwitchState",
        payload: {
          type: 'searchViews',
          value: true
        },
      });
      this.props.dispatch({
        type: "command/setSwitchOpenStatus",
        payload: {
          type: 'right',
          value: false
        },
      });
    } else if(param == 'eventViews'){
      this.props.dispatch({
        type: "command/setMapLayerSwitchState",
        payload: {
          type: 'eventViews',
          value: true
        },
      });
      this.props.dispatch({
        type: "command/setSwitchOpenStatus",
        payload: {
          type: 'right',
          value: false
        },
      });
    } else {
      this.props.dispatch({
        type: "command/setMapLayerSwitchState",
        payload: {
          type: 'resourceViews',
          value: true
        },
      });
      this.props.dispatch({
        type: "command/setSwitchOpenStatus",
        payload: {
          type: 'right',
          value: true
        },
      });
    }
  }
  // 渲染不同状态下的图标显示
  _renderPicture(param, pictureName) {
    console.log('_renderPicture-param', param, pictureName);
    const { mapStyle } = this.props
    switch (param) {
      case true:
        return require("@assets/images/prevention/" + pictureName + "-active.png")
      case false:
        if (mapStyle == 'dark') {
          return require("@assets/images/prevention/" + pictureName + "-white.png")
        } else {
          return require("@assets/images/prevention/" + pictureName + ".png")
        }
    }
  }
  render() {
    const { searchViews, resourceViews, eventViews } = this.props.mapLayerSwitchState
    const { mapStyle } = this.props
    return (
      <div className="layer-extension-btn">
        <Tooltip title="搜索图层">
        <div className="layer-btn" onClick={this.changeSwitchStatus.bind(this, 'searchViews')}>
          <img
            className="layer-img"
            src={
              this._renderPicture(searchViews, 'search')
            }
          />
        </div>
        </Tooltip>
        <Tooltip title="事件图层">
        <div className="layer-btn" onClick={this.changeSwitchStatus.bind(this, 'eventViews')}>
          <img
            className="layer-img"
            src={
              this._renderPicture(eventViews, 'event')
            }
          />
        </div>
        </Tooltip>
        <Tooltip title="资源图层">
        <div className="layer-btn" onClick={this.changeSwitchStatus.bind(this, 'resourceViews')}>
          <img
            className="layer-img"
            src={
              this._renderPicture(resourceViews, 'resource')
            }
          />
        </div>
        </Tooltip>
      </div>
    );
  }
}
