/**
 * 视频通话页面
 */
import React, { Component } from "react";
import { connect } from "dva";
import "./index.less";
import RecordVideo from './RecordVideo';
import { initRecordRTC, stopRecord, startRecord, hasError, downloadRecord } from '../Video/recordRTC';
import { Modal, Checkbox, Space } from 'antd';
import recordingImg from "@assets/images/prevention/aPicture/recording.png";
const { confirm, warning, success, error } = Modal;

const _TOOLS = [{
  type: 'mute',
  icon: require("@assets/images/prevention/videobox-volume.png"),
  checkIcon: require("@assets/images/prevention/videobox-volume-active.png"),
  name: '静音'
},{
  type: 'video',
  icon: require("@assets/images/prevention/videobox-video.png"),
  checkIcon: require("@assets/images/prevention/videobox-video-active.png"),
  name: '视频'
},{
  type: 'add',
  icon: require("@assets/images/prevention/videobox-add.png"),
  checkIcon: require("@assets/images/prevention/videobox-add-active.png"),
  name: '添加'
},{
  type: 'record',
  icon: require("@assets/images/prevention/videobox-luzhi.png"),
  checkIcon: recordingImg,
  name: '录制'
},{
  type: 'close',
  icon: require("@assets/images/prevention/videobox-close.png"),
  checkIcon: require("@assets/images/prevention/videobox-close-active.png"),
  name: '结束'
}];

const _GENRE_TOOLS = [{
  type: 'mute',
  icon: require("@assets/images/prevention/videobox-volume.png"),
  checkIcon: require("@assets/images/prevention/videobox-volume-active.png"),
  name: '静音'
},{
  type: 'record',
  icon: require("@assets/images/prevention/videobox-luzhi.png"),
  checkIcon: recordingImg,
  name: '录制'
},{
  type: 'close',
  icon: require("@assets/images/prevention/videobox-close.png"),
  checkIcon: require("@assets/images/prevention/videobox-close-active.png"),
  name: '结束'
}];

@connect((state) => ({
  ownCid: state.im.v5Data.ownCid,
  videoType: state.command.videoType, //0: 九宫格 1: 右侧列表   2: 顶部列表   3: 十六宫格  4: 二十五宫格
  recordStatus: state.command.recordStatus, // 0：未录制 1：录制中
  videoGenre: state.command.videoGenre, // 功能类型 0: 视频调度(一对多) 1: 视频上拉(一对一)
}))
export default class BoxTool extends Component {
  constructor(props) {
    super(props);
    this.state = {
      isShowChange: false, // 切换布局弹框是否显示
    };
  }
  componentDidMount() {
  }
  onClickTool=(type)=>{
    const { canMic, common, switchVideoTool, canCamera, addMember, dissolutionRoomModal  } = this.props;
    switch (type) {
      case "mute":{
        if(canMic){
          switchVideoTool(type)
          if (common.isMicOn) {
            common.isMicOn = false;
            common.muteAudio();
          } else {
            common.isMicOn = true;
            common.unmuteAudio();
          }
        }
        break;
      }
      case "video":{
        if(canCamera){
          switchVideoTool(type);
          if (common.isCamOn) {
            common.isCamOn = false;
            common.muteVideo();
          } else {
            common.isCamOn = true;
            common.unmuteVideo();
          }
        }
        break;
      }
      case "share":{
        common.screenShareClick();
        break;
      }
      case "add":{
        addMember();
        break;
      }
      case "record":{
        this.onRecordVideo('start')
        break;
      }
      case "close":{
        dissolutionRoomModal();
      }
    }
  }

  onRecordVideo=(status)=>{
    // 0：未录制 1：录制中
    const that = this;
    if (status == 'start') {
      warning({
        title: '录制功能为浏览器录制，录制过程中，请勿关闭当前录制的浏览器页面及注意当前网络！',
        okText: '我知道了',
        onOk() {
          Modal.destroyAll()
          startRecord((success)=>{
            that.props.dispatch({
              type:'command/fetchRecordStatus',
              payload: 1
            })
          }, (err)=>{
            error({
              title: '浏览器无法获取录制权限，启动失败',
              okText: '好的',
            })
          });
        },
      });
    } else if(status == 'end') {
      confirm({
        title: '是否确认结束视频调度录屏？',
        okText: '确定',
        cancelText: '取消',
        onOk() {
          Modal.destroyAll()
          stopRecord();
          that.props.dispatch({
            type:'command/fetchRecordStatus',
            payload: 0
          })
          const hasE = hasError();
          if (hasE) {
            error({
              title: '录制文件生成失败',
              okText: '好的',
            })
          } else {
            success({
              content: '录制结束，录制文件已下载完成！',
              okText: '我知道了',
              onOk(){
                Modal.destroyAll()
                downloadRecord();
              }
            });
          }
        },
        onCancel() {
          console.log('Cancel');
        },
      });
    }
    this.props.onRecordVideo && this.props.onRecordVideo()
  }

  onChangeVideoType(type){
    console.log('onChangeVideoType', type);
    this.props.dispatch({
      type:'command/fetchVideoType',
      payload: type
    })
  }

  onShowChange(){
    this.setState({
      isShowChange: this.state.isShowChange ? false : true
    })
  }
  render() {
    const { currentTime, isShowChange } = this.state;
    const { toolStatus, recordStatus, addMember, boxToolStyle, dissolutionRoomModal, videoType, videoGenre } = this.props;
    const hasVideoScheduling = videoGenre == 0 ? true : false;
    const tools = hasVideoScheduling ? _TOOLS : _GENRE_TOOLS;
    return (
      <div className={boxToolStyle}>
        {
          tools.map((tool, index)=>{
            if (recordStatus != 0 && tool.type == 'record') {
              return <div className="tool-item" onClick={this.onRecordVideo.bind(this, 'end')}>
                <img src={recordingImg} alt="" />
                <div  className="name">结束录制</div>
              </div>
            }
            return <div className="tool-item" onClick={this.onClickTool.bind(this, tool.type)}>
              <img src={ toolStatus[tool.type] ? tool.checkIcon: tool.icon } alt="" />
              <div className="name">{tool.name}</div>
            </div>
          })
        }
      {/* <div className="tool-item" onClick={this.onClickTool.bind(this, 'share')}>
        <img src={
          toolStatus.share ?
          require("@assets/images/prevention/videobox-luzhi-active.png") :
          require("@assets/images/prevention/videobox-luzhi.png")
        } alt="" />
        <div  className="name">分享</div>
      </div> */}
      {
        hasVideoScheduling ? <div className="tool-item change-abs" onClick={this.onShowChange.bind(this)}>
          <img src={
            toolStatus.close ?
              require("@assets/images/prevention/switch.png") :
              require("@assets/images/prevention/switch.png")
          } alt="" />
          <div  className="name">切换布局</div>
          {
            isShowChange ? <div className="change-content">
              <div className="change-item"  onChange={this.onChangeVideoType.bind(this, '0')} >
                <img className="change-img" src={require("@assets/images/prevention/scratchable-latex.png")} />
                <Checkbox checked={videoType == "0" ? true : false}key="0" >
                  九宫格
                </Checkbox>
              </div>
              <div className="change-item"  onChange={this.onChangeVideoType.bind(this, '3')} >
                <img className="change-img" src={require("@assets/images/prevention/scratchable-latex.png")} />
                <Checkbox checked={videoType == "3" ? true : false}key="3" >
                  十六宫格
                </Checkbox>
              </div>
              <div className="change-item"  onChange={this.onChangeVideoType.bind(this, '4')} >
                <img className="change-img" src={require("@assets/images/prevention/scratchable-latex.png")} />
                <Checkbox checked={videoType == "4" ? true : false}key="4" >
                  二十五宫格
                </Checkbox>
              </div>
              <div className="change-item"  onChange={this.onChangeVideoType.bind(this, '1')} >
                <img className="change-img" src={require("@assets/images/prevention/right-side-list.png")} />
                <Checkbox checked={videoType == "1" ? true : false} key="1" >
                  右侧列表
                </Checkbox>
              </div>
              <div className="change-item" onChange={this.onChangeVideoType.bind(this, '2')}  >
                <img className="change-img" src={require("@assets/images/prevention/top-side-list.png")} />
                <Checkbox checked={videoType == "2" ? true : false} key="2">
                  顶部列表
                </Checkbox>
              </div>
            </div> : null
          }
        </div> : null
      }
      <RecordVideo />
    </div>
    );
  }
}
