/**
 * 录制中倒计时
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Icon } from "antd";
import "./video.less";
import RreactDom from 'react-dom';
import recordingImg from "@assets/images/prevention/aPicture/recording.png";
import moment from 'moment';
import 'moment/locale/zh-cn';
moment.locale('zh-cn');
// import { initRecordRTC, stopRecord, startRecord, playRecord, downloadRecord } from '../Video/recordRTC';

@connect((state) => ({
  ownCid: state.im.v5Data.ownCid,
  recordStatus: state.command.recordStatus // 0：未录制 1：录制中
}))
export default class  RecordTimer extends Component {
  constructor(props) {
    super(props);
    this.state = {
      isShowChange: false, // 切换布局弹框是否显示
      recordStatus: 0, // 0：未录制 1：录制中
      recordTime: 0, // 单位: 秒
    };
    this.recordTimer = null
  }

  componentWillReceiveProps(nextProps) {
    if ( JSON.stringify(nextProps.recordStatus) !== JSON.stringify(this.state.recordStatus) ) {
      if (nextProps.recordStatus == 1) {
        this.setState({
          recordStatus: nextProps.recordStatus
        })
        const that = this;
        this.recordTimer = setInterval(() => {
          that.setState({
            recordTime: that.state.recordTime + 1
          })
        }, 1000);
      } else {
        this.setState({
          recordStatus: nextProps.recordStatus,
          recordTime: 0
        })
        clearInterval(this.recordTimer);
        this.recordTimer = null;
      }
    }
  }

  componentDidMount() {
  }
  render() {
    const { recordStatus, recordTime } = this.state;
    if (recordStatus == 0) {
      return null;
    }
    const today = moment().format("YYYY年MM月DD日");
    const duration = moment.duration(recordTime * 1000);
    const hours = duration.hours() < 10 ? "0" + duration.hours() : duration.hours();
    const minutes = duration.minutes() < 10 ? "0" + duration.minutes() : duration.minutes();
    const seconds = duration.seconds() < 10 ? "0" + duration.seconds() : duration.seconds();

    return (
      <div className="record-timer-content">
        <img src={recordingImg} />
        <div>录制中</div>
        <div>{hours + ":" + minutes + ":" + seconds}</div>
        <div>{today}</div>
      </div>
    );
  }
}
 