/**
 * 录制中倒计时
 */
import React, { Component } from "react";
import { connect } from "dva";
import "./video.less";
import MouseMovement from "../../../components/MouseMovement"
import { isEmpty } from '@utils/utils';
// import { initRecordRTC, stopRecord, startRecord, playRecord, downloadRecord } from '../Video/recordRTC';
const _SIZE = ['minimize', 'float', 'magnify'];

@connect((state) => ({
  ownCid: state.im.v5Data.ownCid,
  videoMember: state.command.videoMember
}))
export default class  RecordMini extends Component {
  constructor(props) {
    super(props);
    this.state = {
      videoSize: 2, // 0：只显示标题； 1：只显示当前发言人视频；2：最大化
      videoMember: [],
      miniLocal: {
        isDown: false,
        offsetLeft: 0,
        offsetTop: 0,
      },
    };
    this.timeInterval = null
  }

  componentWillReceiveProps(nextProps) {
    if(nextProps.videoSize != this.state.videoSize){
      this.setState({
        videoSize: nextProps.videoSize
      })
    }
    if(JSON.stringify(nextProps.videoMember) != JSON.stringify(this.state.videoMember)){
      this.setState({
        videoMember: nextProps.videoMember
      })
    }
  }
  shouldComponentUpdate(nextProps, nextState) {
    if(JSON.stringify(nextProps.videoMember) != JSON.stringify(this.state.videoMember) || nextProps.videoSize != this.state.videoSize){
      return true;
    }
    return false;
  }

  componentDidMount() {
  }
  onChange=(index)=>{
    const { onChange } = this.props;
    onChange && onChange(index)
  }
  render() {
    // const { videoSize, videoMember } = this.props;
    const { miniLocal, videoMember, videoSize } = this.state;
    const checkedVideos  = videoMember.filter(function(item, index){
      return item.checked
    });
    const checkedVideo = checkedVideos.length > 0 ? checkedVideos[0] : {}
    const checkedStream = window.recordStream.trtcStream && window.recordStream.trtcStream.filter(function(item, index){
      return item.getId() == checkedVideo.videoId;
    });
    const statusText = checkedVideo.status == "no" ? "正在调度" : "摄像头未打开"
    const videoID = !isEmpty(checkedVideo.id) ? checkedVideo.id : 'main'
    const userName = !isEmpty(checkedVideo.id) ? checkedVideo.userName : '我';
    const Steam = videoID == 'main' ? window.recordStream.localStream : checkedStream[0];
    console.log('Steam', Steam);
    const hasVideo = Steam && Steam.hasVideo();
    const that = this;

    console.log('checkedVideo', checkedVideo.id);
    if(videoSize == 1 ){
      setTimeout(() => {
        that.timeInterval = setInterval(() => {
          const frame = Steam && Steam.getVideoFrame();
          if (frame) {
            document.querySelector('img#mini-img').src = frame;
          }
          console.log('getVideoFrame');
        }, 2000);
      }, 700);
    } else {
      if (this.timeInterval) clearInterval(this.timeInterval);
    }

    return (
      <MouseMovement
        isDown={ miniLocal.isDown }
        offsetLeft={ miniLocal.offsetLeft }
        offsetTop={ miniLocal.offsetTop }
      >{({ x, y, cursor = 'move' }) => (
        <div id="record-mini-content" className="record-mini-content" style={{
          top: y == 0 ? '40%' : y,
          left: x == 0 ? 'auto' : x,
          right: x == 0 ? 0 : 'auto'
        }} onMouseDown={e => {
          this.setState({
            miniLocal: {
              isDown: true,
              offsetLeft: document.getElementsByClassName('record-mini-content')[0].offsetLeft,
              offsetTop: document.getElementsByClassName('record-mini-content')[0].offsetTop
            }
          })
        }} onMouseUp={e => {
          this.setState({
            miniLocal: {
              ...miniLocal,
              isDown: false,
            }
          })
        }}>
          <div className="mini-icon">
            {
              _SIZE.map((e, i)=>{
                if (i == videoSize){
                  return <img src={require(`@assets/images/prevention/aPicture/${e}-check.png`)} />
                }
                return <img src={require(`@assets/images/prevention/aPicture/${e}.png`)} onClick={this.onChange.bind(this, i)} />
              })
            }
          </div>
          <div className='mini-title' style={{ display: videoSize != 2 ? 'flex' : 'none' }}>视频调度</div>
          <div className='mini-video' id={"mini_"+videoID} style={{ display: videoSize == 1 ? 'block' : 'none' }}>
              <div
                id={"mini_mask_"+videoID}
                className="mask col-div"
                style={{ display: !hasVideo ? 'flex' : 'none' }}
              >
                {/* <!-- “如果摄像头未开启”遮罩 --> */}
                <img
                  style={{ width: "63px", height: "69px", zIndex: 10 }}
                  src={require("@assets/images/prevention/camera-max.png")}
                  alt=""
                />
                <div style={{ height: "10px" }}></div>
                <div style={{ zIndex: 10 }}>{ statusText }</div>
              </div>
              <img id="mini-img" style={{ display: hasVideo ? 'block' : 'none', width: '100%', height: '100px' }} />
              <div className="video-name">
                {
                  hasVideo ?
                  <div>
                    <img src={require("@assets/images/prevention/camera-on.png")} />
                  </div> :
                  <div>
                  <img src={require("@assets/images/prevention/camera-off.png")} />
                </div>
                }
                {userName}
              </div>
            </div>
        </div>
      )}</MouseMovement>
    );
  }
}
