/**
 * 嵌套v5页面的框架
 */
import React, { PureComponent } from "react";
import {
  Layout,
  Menu,
} from 'antd';
import { getHostByPath } from '../../../utils/config';
const { Header, Sider, Content } = Layout;
import styles from './index.less';
import store from 'store';
export default class V5page extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      currentUrl: (props.children&&props.children.length > 0) ? props.children[0].item_url : props.menuUrl
    };
  }

  componentDidMount() {
    document.querySelector(".ant-layout-sider").style.display = "none";
    document.querySelector(".ant-layout-content").style.margin = "0px";
    //隐藏顶部菜单栏
    document.querySelector(".ant-layout-header").style.display = "none";
  }
  componentWillReceiveProps(nextProps) {
    this.setState({
      currentUrl: (nextProps.children&&nextProps.children.length > 0) ? nextProps.children[0].item_url : nextProps.menuUrl
    })
  }
  render() {
    const { currentUrl } = this.state
    const { children } = this.props
    return (
      <div key={children}>
        <Layout>
          {
            children&&children.length > 0 && <Sider className={styles.sider}>
              <Menu
                defaultSelectedKeys={[children[0].id]}
                className="sidemenu"
                mode="inline"
              >
                {
                  children && children.map(item => {
                    return <Menu.Item key={item.id}>
                      <a onClick={() => {
                        this.setState({
                          currentUrl: item.item_url
                        })
                      }}>{item.item_menuname}</a>
                    </Menu.Item>
                  })
                }
              </Menu>
            </Sider>
          }
          {
            currentUrl?<Content className={styles.content}>
            <iframe
              src={getHostByPath('v5base') + currentUrl + '&accessToken=' + store.get('saas')['v5_access_token']}
              style={{ width: "100%", height: 'calc(100vh - 54px)', border: 'none' }}>
            </iframe>
          </Content>:<Content className={styles.content}>暂无内容...</Content>
          }
        </Layout>
      </div>
    );
  }
}

