/**
 * IM可视化视图
 */
import React, { Component } from 'react';
import { Pagination, Drawer, Tooltip, Icon } from 'antd';
import './message.less';
import { decodeText } from '../../../../utils/im/decodeText';
export default class TextElement extends Component {
  constructor(props) {
    super(props);
    this.state = {
      isMine: props.isMine,
      payload: props.payload
    };
  }

  componentDidMount() {}
  componentWillReceiveProps(nextProps) {
    this.setState({
      isMine: nextProps.isMine,
      payload: nextProps.payload
    });
  }

  render() {
    const contentList = decodeText(this.state.payload);
    return (
      <div
        className="text-element-wrapper"
        className={this.state.isMine ? 'element-send' : 'element-received'}
      >
        <div className="text-element">
          {contentList.map((item, index) => {
            if (item.name === 'text') {
              return <span key={index}>{item.text}</span>;
            } else {
              return (
                <img
                  src={item.src}
                  style={{ width: '20px', height: '20px' }}
                  key={index}
                />
              );
            }
          })}
        </div>
      </div>
    );
  }
}
