/**
 * IM可视化视图
 */
import React, { Component } from 'react';
import { connect } from 'dva';
import { Pagination, Drawer, Tooltip, Icon } from 'antd';
import './message.less';
import TIM from 'tim-js-sdk';
// @connect(state => ({
  //   currentMessageList: state.im.currentMessageList
// }))
export default class GroupSystemNoticeElement extends Component {
  constructor(props) {
    super(props);
    this.state = {
      payload: props.payload,
      text: ''
    };
  }

  componentDidMount() {
    const text = this.translateGroupSystemNotice(this.state.payload);
    this.setState({ text });
  }
  componentWillReceiveProps(nextProps) {
  }
  translateGroupSystemNotice(payload) {
    const groupName =
      payload.groupProfile.groupName || payload.groupProfile.groupID;
    switch (payload.operationType) {
      case 1:
        return `${payload.operatorID} 申请加入群组：`;
      case 2:
        return `成功加入群组：`;
      case 3:
        return `申请加入群组：被拒绝`;
      case 4:
        return `被管理员${payload.operatorID}踢出群组：`;
      case 5:
        return `群： 已被${payload.operatorID}解散`;
      case 6:
        return `${payload.operatorID}创建群：`;
      case 7:
        return `${payload.operatorID}邀请你加群：`;
      case 8:
        return `你退出群组：`;
      case 9:
        return `你被${payload.operatorID}设置为群：的管理员`;
      case 10:
        return `你被${payload.operatorID}撤销群：的管理员身份`;
      case 255:
        return '自定义群系统通知';
    }
  }
  render() {
    return (
      <div>
        <div className="group-system-element-wrapper">
          {this.state.text}
        </div>
      </div>
    );
  }
}
