/**
 * IM可视化视图
 */
import React, { Component } from 'react';
import { Pagination, Drawer, Tooltip, Icon } from 'antd';
import './message.less';
import { decodeText } from '../../../../utils/im/decodeText';
export default class FileElement extends Component {
  constructor(props) {
    super(props);
    this.state = {
      //   isMine: props.isMine,
      payload: props.payload
    };
  }

  componentDidMount() {}
  componentWillReceiveProps(nextProps) {
    this.setState({
      //   isMine: nextProps.isMine,
      payload: nextProps.payload
    });
  }
  downloadFile() {
    // 浏览器支持fetch则用blob下载，避免浏览器点击a标签，跳转到新页面预览的行为
    if (window.fetch) {
      fetch(this.state.payload.fileUrl)
        .then(res => res.blob())
        .then(blob => {
          let a = document.createElement('a');
          let url = window.URL.createObjectURL(blob);
          a.href = url;
          a.download = this.state.payload.fileName;
          a.click();
        });
    } else {
      let a = document.createElement('a');
      a.href = this.state.payload.fileUrl;
      a.target = '_blank';
      a.download = this.state.payload.filename;
      a.click();
    }
  }
  size() {
    const size = this.state.payload.fileSize;
    if (size > 1024) {
      if (size / 1024 > 1024) {
        return `${this.toFixed(size / 1024 / 1024)} Mb`;
      }
      return `${this.toFixed(size / 1024)} Kb`;
    }
    return `${this.toFixed(size)}B`;
  }
  toFixed(number, precision = 2) {
    return number.toFixed(precision);
  }
  render() {
    return (
      <div className="file-element-wrapper">
        <div className="header">
        <Icon type="file" className="file-icon" />
          {/* <i className="el-icon-document "></i> */}
          <div className="file-element">
            <span className="file-name">{this.state.payload.fileName}</span>
            <span className="file-size">{this.size()}</span>
          </div>
        </div>
        <div className="footer">
          <span
            onClick={() => {
              this.downloadFile();
            }}
            className="download-link"
          >
            下载
          </span>
        </div>
        {/* <el-progress
          v-if="showProgressBar"
          :percentage="percentage"
          :color="percentage => (percentage === 100 ? '#67c23a' : '#409eff')"
        /> */}
      </div>
    );
  }
}
