/**
 * 地图主页面入口
 */
 import React, { PureComponent } from "react";
 import style from "styled-components";
 import CreateInfoWindow from "@mapModule/messageWindow/CreateInfoWindow";
 import CreateEventInfoWindow from "@mapModule/messageWindow/CreateEventInfoWindow";
 import CreateAttenInfoWindow from "@mapModule/messageWindow/CreateAttenInfoWindow";
 import CreatePicturePerception from "@mapModule/messageWindow/CreatePicturePerception";
 import CreateTrajectoryInfoWindow from "@mapModule/messageWindow/CreateTrajectoryInfoWindow";
 import { connect } from "dva";
 import "../command.less";
 import TIM from "tim-js-sdk";
 import tim from "../../../utils/im/imInitialize";
 import {
   sendVideoRoomMsg,
   searchDeptUser,
 } from "../../../services/api";
 import {
   message,
   Button,
   Modal,
   Form,
   Row,
   Col,
   Slider
 } from "antd";
 import Video from "../Video/index";
 import BeijingVideo from "@mapModule/BeijingVideo";
 import SearchListTab from "./SearchListTab";
 import PersonSearch from "./Person/PersonSearch";
 import APicture from './APicture';
 import Police from './Police/index.jsx';
 import EarthMap from './Earth/index.jsx'
 import NanNing from "./NanNing";
 import loadMap from "@mapModule/loadMap";
 import InitMap from "@mapModule/InitMap";
 import ModalView from "@mapModule/ModalView";
 import AllMapLayer from '@mapModule/AllMapLayer';
 // import DeviceDetector from 'rtc-device-detector-react';
 // import 'rtc-device-detector-react/dist/index.css';
 import {
   markEventList,
   openEventInfo,
   closeEventMarkers,
   markPersonList,
   openPersonInfo,
   closePersonMarkers,
   markerAttendanceList,
   openAttendanceInfo,
   closeAttendanceMarker,
   markPicture,
   markNowErrorEvent
 } from "@mapModule/markMarkers";
 import { APictureAddPictueMarks, APictureReducePictueMarks } from '../GIS/APicture/func';
 import { gup } from '../../../utils/utils';
 import localMapRightClickContent from '@mapModule/RightClickEvent/localMapRightClickContent';
 import { rotation } from "@mapModule/earthEvent";
 import $loading from '../../../utils/loading';
 import { _DEFAULT_MAP_ZOOM, _DEFAULT_MAP_CENTER_POINT, _BEIJING_MAP_POINT } from '@constants/maps';
 import eventCenter from "@common/events"; // 引入 EventEmitter'
 import classNames from 'classnames';
 import { isEmpty } from '@utils/utils';
 import { showAttendPointInfo } from '@gis/biz';
 import TopButton from './TopButton';
 import Record from "../Record";
 // import { imKey } from "@utils/config";
 // import Presetting from "../Video/presetting";
 const store = require('store');
 
 @connect((state) => ({
   //im
   loginAccount: state.login.loginAccount,
   imSig: state.global.imSig,
   imIsLogin: state.global.imIsLogin,
   comName: state.global.companyInfo.comName,
   nextReqMessageID: state.im.nextReqMessageID,
   conversationList: state.im.conversationList,
   currentMessageList: state.im.currentMessageList,
   cid: state.im.cid,
   //地图数据
   eventList: state.command.eventList,
   attendanceList: state.command.attendanceList,
   personList: state.command.personList,
   clearInfoWindow: state.command.clearInfoWindow,
   tabIndex1: state.command.tabIndex.tabIndex1,
   mapStyle: state.command.mapStyle,
   //一张图数据
   securityResourceData: state.command.securityResourceData,
   pictureMarkersList: state.command.pictureMarkersList,
   //警保联动
   policePersonData: state.command.policeData.personData,
   layoutAuthority: state.command.layoutAuthority,
   // 记录上一步操作信息
   backStepInfo: state.command.backStepInfo,
   switchOpenStatus: state.command.switchOpenStatus,
   selectComponeyInfo: state.command.selectComponeyInfo,
   searchAround: state.command.searchAround,
   searchAroundList: state.command.searchAroundList,
   videoGenre: state.command.videoGenre, // 功能类型 0: 视频调度(一对多) 1: 视频上拉(一对一)
 }))
 @Form.create()
 export default class GIS extends PureComponent {
   constructor(props) {
     super(props);
     this.state = {
       mobilePhone: gup('mobilePhone', window.location.href),
       name: decodeURI(gup('username', window.location.href)),
       // mouseTool: null,  避免不必要的 setState 更新
       //地图部门功能全局化
       map: null,
       // 事件列表
       eventList: [],
       //事件图层
       eventMarkers: [],
       //驻勤点图层
       attendanceMarkers: [], //驻勤点的数据
       //人员图层
       personMarkers: [], //人员打点
       personList: [], //人员数据
 
       infoWindow: null, //全局定义信息窗体（在初始化地图的时候，也初始化信息窗体）
       // imStatus: false, //是否展示im的可视化页面
       videoStatus: false, //视频通话页面是否显示
       deviceDetect: false, // Web 端设备及网络检测公共组件是否显示
       deviceDetectInfo: {}, // Web 端设备及网络检测 JSON 配置
       selectedPoints: [], //通过矢量图选中的多个数据点
       overlays: [], //矢量图绘制的点（主要用在清空矢量图）
       selectedPointsStatus: false, //显示选中多人数据的弹窗
       selectedData: {
         phone: "",
       }, //选中的点的数据
       //调度的内容
       dispatchType: "", //调度类型（text文字,voice语音,video视频）
       createTaskStatus: false, //创建任务弹窗状态
       schedulingContent: "", //调度任务内容
       schedulingName: "", //调度任务名称
       recordMobile: "", //调度需要录制视频的人员
       needCreateConversation: false, //是否需要创建单人会话
       layerSatatus: "", //海量点图层(attendance是驻勤点图层，aPicture是防空指挥一张图图层,person是人员图层,police是警保联动图层)
       normalMap: null, //正常的图层（变成是驻勤点图层）
       locaMap: null, //防空指挥一张图图层
       earthMap: null, //地球图层
       showEarchMap: true,
       showEarchMapSearch: false,
       // paintValue: "cancel", //选中的是用哪个图形画图
       conversationID: "", //当前在地图中选中的哪个人或群组的id
       beijingVideo: false, //北京视频的展示状态
       //录音
       showRecord: false, //是否显示录音的页面
       onlyPersonVoiceStatus: false, //个人调度的录音状态
 
       allAttendanceList: [], //所有驻勤点信息
       allPersonList: [], //所有人员信息
       zoom: 18, //点击某个点，然后放大图层
       currentTabKey1: "2", //当前选中的tab页面
       afterAttenSelectedId: null,//过去驻勤点选中的值,默认没有
       searchAround: {//周边搜索的显隐
         type: '',
         show: false,
         lnglat: {}
       },
       satelliteLayer: null,
       satellite: true, //卫星图层
       rotation: null,  //自转定时器
       gITFPoint: [
         {
           name: "rjyA",
           lng: 118.051053,
           lat: 24.607252,
           gIFTurl: "https://bcxin-vedio-prod.obs.myhuaweicloud.com/glTF/0914san-fbx2/0914san-fbx.gltf",
           isShow: false,
         },
         {
           name: "rjyB",
           lng: 118.048937,
           lat: 24.611863,
           gIFTurl: "https://bcxin-vedio-prod.obs.myhuaweicloud.com/glTF/B-1/B-1.gltf",
           isShow: false,
         },
       ],
       layerExtensionType: 'search' // 图层扩展类型。search: 搜索图层; resource: 资源图层。默认为搜索图层
     };
     this.mouseTool = null // 创建矢量图画图工具
   }
 
   /******************************生命周期******************************/
   componentDidMount() {
     loadMap.call(this); //加载地图组件--进入加载地球loading
   }
   // 检查事件在地图上的标记
   _checkMarkerEvent=(nextProps)=>{
     const { eventList, map, eventMarkers } = this.state;
     const { selectedId, list } = nextProps.eventList;
     console.log('_checkMarkerEvent', JSON.stringify(list), JSON.stringify(eventList));
     if ( JSON.stringify(list) !== JSON.stringify(eventList) ) {
       console.log('GIS-setState');
       // 先渲染事件列表信息，再渲染事件在地图上的打点信息
       this.setState({
         eventList: list,
       });
       this.markEventList(list);
     }
     //点击点改变点的状态（当有个别打点信息需要改变时
     if (eventMarkers.length > 0 && selectedId) {
       eventMarkers.map((marker) => {
         if (marker.w.key === selectedId) {
           list.forEach((item) => {
             if (item.id == marker.w.key) {
               this.openEventInfo(item, map, marker);
             }
           });
         }
       });
     }
   }
   // 检查人员在地图上的标记
   _checkMarkerPerson=(nextProps)=>{
     const { selectedId, list } = nextProps.personList;
     const { securityResource, attendancePolice } = nextProps.pictureMarkersList
     const { allPersonList, personMarkers } = this.state;
     console.log('_checkMarkerPerson', JSON.stringify(list), JSON.stringify(allPersonList));
     if ( JSON.stringify(list) !== JSON.stringify(allPersonList)) {
       console.log('GIS-setState');
       // 先渲染事件列表信息，再渲染事件在地图上的打点信息
       this.setState({
         allPersonList: list,
       });
       this.markPersonList(list);
     }
     //点击点改变点的状态（当有个别打点信息需要改变时
     // if (personMarkers.length > 0 && selectedId) {
     //   personMarkers.map((marker) => {
     //     if (marker.w.key === selectedId) {
     //       list.forEach((item) => {
     //         if (item.perId == marker.w.key) {
     //           // this.openPersonInfo(item, marker);
     //           this.openPersonInfo(item, marker, 'police');
     //         }
     //       });
     //     }
     //   });
     // }
     debugger
     if (securityResource.length > 0 && securityResource[0].data.length > 0 ) {
       const securityInfo = securityResource[0].info;
       securityResource[0].data.map((marker, index) =>{
         console.log('securityResource', marker);
         var icon = new AMap.Icon({
           size: new AMap.Size(32, 42),
           image: securityInfo[index]["mapIcon"],
           imageSize: new AMap.Size(32, 42)
         });
         marker.setIcon(icon); // 设置默认图标
       });
 
       if (!isEmpty(selectedId)) {
         securityResource[0].data.map((marker, index) =>{
           console.log('securityResource', marker);
           // 命中
           if (marker.w.key === selectedId) {
             var clickIcon = new AMap.Icon({
               size: new AMap.Size(32, 42),
               image: securityInfo[index]["clickMapIcon"],
               imageSize: new AMap.Size(32, 42)
             });
             marker.setIcon(clickIcon); // 设置选中图标
             // this.openPersonInfo(securityInfo[index], marker, 'police');
             eventCenter.emit('openTrajectoryInfoWindow', {
               item: securityInfo[index],
               type: 'securityResource',
               marker: marker
             })
           }
         })
       }
     }
   }
   // 检查人员在地图上的标记（周边搜索）
   _checkMarkerSearchPerson=(nextProps)=>{
    debugger
     const { selectedId, list } = nextProps.searchAroundList;
     const { securitySearch } = nextProps.searchAround
     console.log('securitySearch', securitySearch);
     if (securitySearch.length > 0 && securitySearch[0].data.length > 0 ) {
       const securityInfo = securitySearch[0].info;
       securitySearch[0].data.map((marker, index) =>{
         console.log('securitySearch', marker);
         var icon = new AMap.Icon({
           size: new AMap.Size(32, 42),
           image: securityInfo[index]["mapIcon"],
           imageSize: new AMap.Size(32, 42)
         });
         marker.setIcon(icon); // 设置默认图标
       });
 
       if (!isEmpty(selectedId)) {
         securitySearch[0].data.map((marker, index) =>{
           console.log('securitySearch', marker);
           // 命中
           if (marker.w.key === selectedId) {
             var clickIcon = new AMap.Icon({
               size: new AMap.Size(32, 42),
               image: securityInfo[index]["clickMapIcon"],
               imageSize: new AMap.Size(32, 42)
             });
             marker.setIcon(clickIcon); // 设置选中图标
             // this.openPersonInfo(securityInfo[index], marker, 'police');
             eventCenter.emit('openTrajectoryInfoWindow', {
               item: securityInfo[index],
               type: 'securityResource',
               marker: marker
             })
           }
         })
       }
     }
   }
   // 检查驻勤点在地图上的标记
   _checkMarkerAttendance=(nextProps)=>{
     //所有驻勤点有值，并且更换的时候，打点，
     // this.state.layerSatatus == "aPicture"
     const { selectedId, list } = nextProps.attendanceList;
     const { allAttendanceList, attendanceMarkers, afterAttenSelectedId, map, layerSatatus } = this.state;
     console.log('_checkMarkerAttendance', JSON.stringify(list), JSON.stringify(allAttendanceList));
     if ( JSON.stringify(list) !== JSON.stringify(allAttendanceList)) {
       console.log('GIS-setState');
       // 先渲染事件列表信息，再渲染事件在地图上的打点信息
       this.setState({
         allAttendanceList: list,
       });
       this.markerAttendanceList(list);
     }
     //点击点改变点的状态（当有个别打点信息需要改变时
     if (attendanceMarkers.length > 0 && selectedId != null) {
       this.openAttendanceInfo({
         item: list[selectedId],
         map,
         marker: attendanceMarkers[selectedId],
         currentIndex: selectedId,
         afterIndex: afterAttenSelectedId,
         layerStatus: layerSatatus
       })
       // this.openAttendanceInfo(list[selectedId], map, attendanceMarkers[selectedId], selectedId, afterAttenSelectedId);
       console.log('GIS-setState');
       this.setState({
         afterAttenSelectedId: selectedId
       })
     }
   }
   componentWillReceiveProps(nextProps) {
     //要先让地图加载完在判断
     if (this.state.map) {
       // 检查事件在地图上的标记
       this._checkMarkerEvent(nextProps);
       // 检查人员在地图上的标记
       this._checkMarkerPerson(nextProps);
       // 检查人员在地图上的标记（周边搜索）
       this._checkMarkerSearchPerson(nextProps);
       // 检查驻勤点在地图上的标记
       this._checkMarkerAttendance(nextProps);
       //清除地图上的信息窗体
       if (nextProps.clearInfoWindow) { 
        setTimeout(() => {
          this.state.map.clearInfoWindow();//清除信息窗体，异步调用
         }, 100);        
         this.props.dispatch({
           type: "command/clearInfoWindow",
           payload: false,
         });
         closeEventMarkers.call(this);
         closePersonMarkers.call(this);
         closeAttendanceMarker.call(this);
         console.log('GIS-setState');
         this.setState({
           afterAttenSelectedId: null
         })
       }
       //Tab改变
       if (this.state.currentTabKey1 != nextProps.tabIndex1) {
         const tabKey = [
           {
             key: "1",
             marker: "event",
           },
           {
             key: "2",
             marker: "person",
           },
           {
             key: "3",
             marker: "attendance",
           },
         ];
         console.log('GIS-setState');
         this.setState({
           currentTabKey1: nextProps.tabIndex1,
         });
         let current = null;
         let past = null;
         tabKey.map((item) => {
           if (item.key == nextProps.tabIndex1) {
             current = item.marker;
           }
           if (item.key == this.state.currentTabKey1) {
             past = item.marker;
           }
         });
         this.clearMarkerAdd(current, past);
       }
     }
   }
   componentWillUnmount() {
     // if (document.querySelector(".ant-layout-sider")) {
     //   // 显示左侧菜单栏
     //   document.querySelector(".ant-layout-sider").style.display = "block";
     //   document.querySelector(".ant-layout-content").style.margin = "16px";
     //   // document.querySelector(".oneKeySearchHidden").style.display = "block";
     // }
     window.AMap = null;
     window.recordStream = {};
     window.recordVideo = null;
   }
   initialMap = (layoutName, mapName) => {
     let satelliteLayer = new window.AMap.TileLayer.Satellite() // 卫星图层类
     const mapList = InitMap.call(this, satelliteLayer);
     const normalMap = mapList.normalMap;
     const locaMap = mapList.locaMap;
     const infoWindow = mapList.infoWindow;
     const personMap = mapList.personMap;
     const policeMap = mapList.policeMap;
     const nanNingMap = mapList.nanNingMap;
     const earthMap = mapList.earthMap
     // console.log('GIS-setState');
     // 初始化地图层
     this.setState({
       normalMap,
       locaMap,  //增值版
       personMap,
       policeMap,
       nanNingMap,
       earthMap,
       map: mapList[mapName],
       infoWindow,
       layerSatatus: layoutName,
       // satelliteLayer: new window.AMap.TileLayer.Satellite({map:locaMap}),
       satelliteLayer: satelliteLayer,
     }, () => {
       const { mapStyle } = this.props
       if (mapStyle !== 'normal') {
         var styleName = "amap://styles/" + mapStyle;
         this.state.map.setMapStyle(styleName);
       }
       // 防控指挥一张图 默认为卫星地图
       this.setSatellite(true);
 
       //防控指挥一张图跟警保联动图层需要做鼠标右击的事件
       locaMap.on('rightclick', (e) => {
         new AMap.ContextMenu({ isCustom: true, content: localMapRightClickContent.call(this, e.lnglat, 'aPicture') }).open(locaMap, e.lnglat);
       })
       policeMap.on('rightclick', (e) => {
         new AMap.ContextMenu({ isCustom: true, content: localMapRightClickContent.call(this, e.lnglat, 'police') }).open(policeMap, e.lnglat);
       })
 
       const that = this;
       // event 监听器: eventCenter.addListener("事件名称", 参数列表);
       // 这样做的好处是，爷传孙，不需要父级组件做承载
       // 添加地图标记点
       eventCenter.addListener('addPictueMarks', (result)=>{
         APictureAddPictueMarks.call(that, result.data, result.type, result.where)
       });
       eventCenter.addListener('reducePictueMarks', (result)=>{
         APictureReducePictueMarks.call(that, result.data, result.type, result.where)
       })
       // 地球模式下，跳转到 xx 中心点
       eventCenter.addListener('gotoPosition', (point)=>{
         that.state.map.setZoomAndCenter(_DEFAULT_MAP_ZOOM, [point.lng, point.lat])
       });
       // 打开保安人员自定义窗体
       eventCenter.addListener('openTrajectoryInfoWindow', (result)=>{
         let infoWindow = new AMap.InfoWindow({
           isCustom: true, //使用自定义窗体
           content: CreateTrajectoryInfoWindow.call(that, result.item, result.type, result.marker),
           offset: new AMap.Pixel(16, -45),
         });
         infoWindow.open(that.state.map, result.marker.getPosition());
       });
       eventCenter.addListener('clickTextScheduling', (result)=>{
         // 调度处理
         const { type, item, isNeedRecord, name } = result
         const schedulingName = isEmpty(name) ? "个人调度" : name;
         switch (type) {
           case "text":
             that.character(item);
             break;
           case "voice":
             that.voice(item);
             break;
           case "videoDetect":
           case "video":
             const dataType = Object.prototype.toString.call(item);
             if (dataType == "[object Array]") {
               that.video({
                 info: item,
                 schedulingName,
                 isNeedRecord
               });
             } else if (dataType == "[object Object]") {
               that.video({
                 info: [item],
                 schedulingName,
                 isNeedRecord
               });
             } else {
               console.log("数据出错");
             }
             break;
           // case "video":
             // const _roomId = new Date().getTime()+"_detector";
             // const _userId = 999999
             // const _name = 'detector'
             // Presetting(false, _roomId, _userId+"_uplink", '', _name, (upRes) => {
             //   Presetting(false, _roomId, _userId+"_downlink", '', _name, (downRes) => {
             //     console.log('Presetting', upRes);
             //     const _network_detect_info = {
             //       sdkAppId: imKey.SDKAppID,
             //       roomId: _roomId,
             //       uplinkUserInfo: {
             //         uplinkUserId: _userId+"_uplink",
             //         uplinkUserSig: upRes.data,
             //       },
             //       downlinkUserInfo: {
             //         downlinkUserId: _userId+"_downlink",
             //         downlinkUserSig: downRes.data,
             //       },
             //     }
                 // result.type = 'videoDetect';
                 // that.setState({
                 //   deviceDetect: true,
                 //   // deviceDetectInfo: _network_detect_info
                 //   deviceDetectInfo: result
                 // })
             //   });
             // });
             // break;
         }
       })
       // 地图标记点 check 统一处理
       eventCenter.addListener('checkedMapTag', (result)=>{
         console.log('checkedMapTag', result);
         switch (result.type){
           case "securityResource": {
             if (result.checked) {
               const key = !isEmpty(result.item.perId) ? result.item.perId : result.item.ID;
               that.props.dispatch({
                 type: "command/setPersonSelectIndex",
                 payload: key,
               });
             } else {
               that.props.dispatch({
                 type: "command/setPersonSelectIndex",
                 payload: null,
               });
             }
             break;
           }
           case "securityResourceSearch": {
             if (result.checked) {
               const key = !isEmpty(result.item.perId) ? result.item.perId : result.item.ID;
               that.props.dispatch({
                 type: "command/setSearchMarkSelectIndex",
                 payload: key,
               });
             } else {
               that.props.dispatch({
                 type: "command/setSearchMarkSelectIndex",
                 payload: null,
               });
             }
             break;
           }
         }
       })
       // 头部图标开关
       eventCenter.addListener('isOpenTopSwitch', (result)=>{
         console.log("isOpenTopSwitch", result);
         that.props.dispatch({
           type: "command/setSwitchOpenStatus",
           payload: result,
         });
       })
       // 头部图标开关
       eventCenter.addListener('isOpenMapSwitch', (result)=>{
         console.log("isOpenMapSwitch", result);
         that.props.dispatch({
           type: "command/initMapLayerSwitchState",
         });
         that.props.dispatch({
           type: "command/setMapLayerSwitchState",
           payload: result,
         });
       })
       // 清除地图上的所有弹框
       eventCenter.addListener('clearMapModal', (type)=>{
         switch(type){
           case 'ComponeyInfo':{
             // 初始化公司人员信息弹框
             that.props.dispatch({
               type: 'command/setSelectComponeyInfo',
               payload: {}
             })
             break;
           }
           case 'AttendInfo':{
             // 初始化驻勤点人员信息弹框
             that.props.dispatch({
               type: 'command/setSelectAttendInfo',
               payload: {}
             })
             break;
           }
         }
 
         that.props.dispatch({
           type: "command/setPersonSelectIndex",
           payload: null,
         });
       });
       eventCenter.addListener('openPersonInfo', (result)=>{
         that.openPersonInfo(result.item, result.marker, result.type);
       });
       // 清除地图上的所有标记点
       eventCenter.addListener('clearMapTag', (type)=>{
         if (isEmpty(type)) {
           const { securityResource, securityCompany, attendancePoint, attendancePolice, searchAddress, eventMarker } = that.props.pictureMarkersList
           const { securitySearch, awarenessSearch } = that.props.searchAround
           console.log('开始清除所有标记', that.props.pictureMarkersList, that.props.searchAround);
           // 清除人员标记
           if (securityResource.length > 0) {
             APictureReducePictueMarks.call(that, {
               data: securityResource[0].data,
             }, 'securityResource')
           }
           // 清除公司标记
           if (securityCompany.length > 0) {
             APictureReducePictueMarks.call(that, {
               data: securityCompany[0].data,
             }, 'securityCompany')
           }
           // 清除驻勤点标记
           if (attendancePoint.length > 0) {
             APictureReducePictueMarks.call(that, {
               data: attendancePoint[0].data,
             }, 'attendancePoint')
           }
           // 清除驻勤点人员标记
           if (attendancePolice.length > 0) {
             APictureReducePictueMarks.call(that, {
               data: attendancePolice[0].data,
             }, 'attendancePolice')
           }
           // 清除搜索地址标记
           if (searchAddress.length > 0) {
             APictureReducePictueMarks.call(that, {
               data: searchAddress[0].data,
             }, 'searchAddress')
           }
           // 清除事件标记
           if (eventMarker.length > 0) {
             APictureReducePictueMarks.call(that, {
               data: eventMarker[0].data,
             }, 'eventMarker')
           }
           // 清除人员标记
           this.props.dispatch({
             type: "command/fetchPersonList",
             payload: {
               list: [],
             },
           });
           // 清除周边搜索标记
           if (securitySearch.length > 0) {
             APictureReducePictueMarks.call(that, {
               data: securitySearch,
             }, 'securityResource',  {
               where: 'searchAround',
               type: 'securitySearch'
             })
           }
           if (awarenessSearch.length > 0) {
             APictureReducePictueMarks.call(that, {
               data: awarenessSearch,
             }, 'perception',  {
               where: 'searchAround',
               type: 'awarenessSearch'
             })
           }
         } else {
           const markerType = type;
           const markerList = that.props.pictureMarkersList[markerType];
           console.log('开始清除单个标记', markerList, markerType);
           if (markerList && markerList.length > 0) {
             APictureReducePictueMarks.call(that, {
               data: markerList[0].data,
             }, markerType)
           } else {
             const searchMarkerList = that.props.searchAround[markerType];
             console.log('开始清除单个标记', searchMarkerList, markerType);
             if (markerType == 'securitySearch') {
               if ( searchMarkerList && searchMarkerList.length > 0) {
                 APictureReducePictueMarks.call(that, {
                   data: searchMarkerList[0].data,
                 }, 'securityResource',  {
                   where: 'searchAround',
                   type: markerType
                 })
               }
             } else if (markerType == 'awarenessSearch'){
               if ( searchMarkerList && searchMarkerList.length > 0) {
                 APictureReducePictueMarks.call(that, {
                   data: searchMarkerList[0].data,
                 }, 'perception',  {
                   where: 'searchAround',
                   type: markerType
                 })
               }
             }
           }
         }
       })
       // 初始化右侧数据展示图
       eventCenter.addListener('initRightDataModule', (result)=>{
         this.props.dispatch({
           type: 'command/setSelectComponyList',
           payload:  []
         })
       });
       // TAG:  根据需求 394，取消搜索功能
       // earthMap.addEventListener("zoomend", (e) => {
       //   var ZoomNum = earthMap.getZoom();
       //   // clearInterval(this.state.rotation)
       //   if (ZoomNum >= 8) {
       //     let point = earthMap.getCenter()
       //     this.state.map.on('complete', () => {
       //       this.state.map.setZoomAndCenter(12, [point.lng, point.lat])
       //     })
       //     this.setState({
       //       showEarchMap: false,
       //     })
       //     this.props.dispatch({
       //       type: 'command/setMapStyle',
       //       payload: 'dark'
       //     })
       //   } else {
       //     // setTimeout(() => {
       //     //   this.setState({
       //     //     rotation: rotation(earthMap,ZoomNum)
       //     //   })
       //     // }, 1000)
       //   }
       // });
 
       // earthMap.addEventListener('dblclick', () => {
       //   clearInterval(this.state.rotation);
       //   setTimeout(() => {
       //     this.setState({
       //       rotation: rotation(earthMap)
       //     })
       //   }, 1000)
       // })
       locaMap.plugin(["AMap.GltfLoader"], function () { });
     });
     //创建矢量图画图工具
     this.createMouseTool(this.state.map);
     //检查im有没有失效
     if (!!!this.props.imIsLogin) {
       if (this.state.mobilePhone) {
         this.props.dispatch({
           type: `global/imLogin`,
           payload: {
             username: this.state.mobilePhone,
             name: this.state.name
           },
         });
       }
     }
 
     const that = this;
     if (navigator.geolocation){
       $loading.open("正在获取当前定位。。。");
       let point = store.get('userPosition')
       if (!isEmpty(point)) {
         // 初步渲染好地图之后，使用定时器进行改变地图中心点
         setTimeout(function(){
           that.mapSetTimeout(earthMap, point);
         }, 2000)
       } else {
         // @see https://lbs.amap.com/api/javascript-api/reference/location#m_AMap.Geolocation
         AMap.plugin('AMap.Geolocation', function() {
           var geolocation = new AMap.Geolocation({
             // 是否使用高精度定位，默认：true
             // enableHighAccuracy: true,
             // 设置定位超时时间，默认：无穷大
             timeout: 10000,
             // 定位按钮的停靠位置的偏移量，默认：Pixel(10, 20)
             buttonOffset: new AMap.Pixel(10, 20),
             //  定位成功后调整地图视野范围使定位位置及精度范围视野内可见，默认：false
             zoomToAccuracy: true,
             //  定位按钮的排放位置,  RB表示右下
             buttonPosition: 'RB'
           })
           // 获取用户当前的精确位置信息
           geolocation.getCurrentPosition()
           AMap.event.addListener(geolocation, 'complete', onComplete)
           AMap.event.addListener(geolocation, 'error', onError)
 
           function onComplete (data) {
             // data是具体的定位信息
             const point = data.position;
             store.set('userPosition', point);
             // 初步渲染好地图之后，使用定时器进行改变地图中心点
             setTimeout(function(){
               that.mapSetTimeout(earthMap, point);
             }, 2000)
           }
 
           function onError (data) {
             console.error('AMap.Geolocation', data);
             // 定位出错 IP精确定位失败，精确IP定位服务目前无法完全覆盖所有用户IP，失败率在5%左右；
             const point = {
               lng: _BEIJING_MAP_POINT.LATITUDE,
               lat: _BEIJING_MAP_POINT.LONGITUDE
             };
             store.set('userPosition', point);
             // 初步渲染好地图之后，使用定时器进行改变地图中心点
             setTimeout(function(){
               that.mapSetTimeout(earthMap, point);
             }, 2000)
           }
         })
       }
     }else{
       // 当前浏览器不支持定位服务
       console.log('当前浏览器不支持定位服务');
     }
   };
   // 初步渲染好地图之后，使用定时器进行改变地图中心点
   mapSetTimeout(earthMap, point){
     const that = this;
     earthMap.centerAndZoom(new BMapGL.Point(_DEFAULT_MAP_CENTER_POINT.LATITUDE, _DEFAULT_MAP_CENTER_POINT.LONGITUDE), 4); // 该中心点是位于中国
     $loading.close();
     earthMap.centerAndZoom(new BMapGL.Point(point.lng, point.lat), 6); // 该中心点是位于用户当前位置
     // 延时切换到高德地图
     setTimeout(function () {
       that.state.map.on('complete', () => {
         that.state.map.setZoomAndCenter(_DEFAULT_MAP_ZOOM, [point.lng, point.lat])
       })
       // console.log('GIS-setState');
       that.setState({
         showEarchMap: false,
       })
       // that.props.dispatch({
       //   type: 'command/setMapStyle',
       //   payload: 'dark'
       // })
     },4000)
   }
   //创建矢量图画图工具
   createMouseTool(currentMap) {
     const { AMap } = window;
     const that = this;
     AMap.plugin(["AMap.MouseTool", "AMap.PlaceSearch", 'AMap.MapType',], () => {
       that.mouseTool = new AMap.MouseTool(currentMap);
       // console.log('GIS-setState');
       // this.setState({
       //   mouseTool,
       // });
       //添加事件
       AMap.event.addListener(that.mouseTool, "draw", (e) => {
         // console.log('GIS-setState');
         this.setState({
           overlays: e.obj,
         });
         let polygonPoints = e.obj.getPath();
         // 整理多边形点的数据 变成[[],[]]的格式
         polygonPoints.map((point) => {
           return [point.lng, point.lat];
         });
         let selectedPoints = null;
         switch (this.state.layerSatatus) {
           case 'attendance':
             //正常图层的时候
             selectedPoints = this.props.personList.list.filter((pos) => {
               //取的数据是该驻勤点下的人员数据
               if (pos.lnglat) {
                 // 地图点的坐标转换成[]
                 const posArray = [pos.lnglat[0], pos.lnglat[1]];
                 return AMap.GeometryUtil.isPointInRing(posArray, polygonPoints);
               }
             });
             break;
           case 'aPicture':
             //一张图图层
             if (this.props.pictureMarkersList.securityResource.length > 0) {
               selectedPoints = this.props.securityResourceData.filter((pos) => {
                 if (pos.longitude && pos.latitude) {
                   const posArray = [pos.longitude, pos.latitude];
                   return AMap.GeometryUtil.isPointInRing(posArray, polygonPoints);
                 }
               })
             } else {
               selectedPoints = []
             }
             break;
           case 'person':
             selectedPoints = this.state.personList.filter((pos) => {
               if (pos.lnglat) {
                 // 地图点的坐标转换成[]
                 const posArray = [pos.lnglat[0], pos.lnglat[1]];
                 return AMap.GeometryUtil.isPointInRing(posArray, polygonPoints);
               }
             });
             break;
           //警保联动图层
           case 'police':
             // selectedPoints = []
             var allMarks = []//因为数据是对象数组，需要组合成数组
             if (this.props.policePersonData) {
               for (let key in this.props.policePersonData) {
                 if (this.props.policePersonData[key] !== null) {
                   allMarks = allMarks.concat(this.props.policePersonData[key])
                 }
               }
             }
             selectedPoints = allMarks.filter((pos) => {
               if (pos.longitude && pos.latitude) {
                 // 地图点的坐标转换成[]
                 const posArray = [pos.longitude, pos.latitude];
                 return AMap.GeometryUtil.isPointInRing(posArray, polygonPoints);
               }
             });
             break;
         }
 
         if (selectedPoints.length === 0) {
           Modal.error({
             title: "没有选中项",
             onOk: () => {
               this.state.map.remove([e.obj]);
             },
           });
         } else {
           // console.log('GIS-setState');
           this.setState({
             selectedPoints,
             selectedPointsStatus: true,
           });
         }
       });
       // new AMap.PlaceSearch({});
       let placeSearch = new AMap.PlaceSearch({
         pageSize: 6, // 单页显示结果条数
         pageIndex: 1, // 页码
         city: "010", // 兴趣点城市
         citylimit: true, //是否强制限制在设置的城市内搜索
         map: this.state.map, // 展现结果的地图实例
         panel: "panel", // 结果列表将在此容器中进行展示。
         autoFitView: true, // 是否自动调整地图视野使绘制的 Marker点都处于视口的可见范围
       });
       // console.log('GIS-setState');
       // this.setState({ placeSearch });
       // 关键字查询
       //  placeSearch.search('厦门市软件园三期');
     });
     // var gps =[120.216123284763,30.21168569675452]
     // AMap.convertFrom(gps, 'gps', function (status, result) {
     //   if (result.info === 'ok') {
     //     var lnglats = result.locations; // Array.<LngLat>
     //   }
     // });
   }
   //事件列表打点
   markEventList(eventList, where = "") {
     const eventMarkers = markEventList.call(this, eventList, where);
     this.setState({ eventMarkers });
   }
   //事件的打点更换
   openEventInfo(item, map, marker) {
     const markers = openEventInfo.call(this, item, map, marker);
     this.setState({
       eventMarkers: markers,
     });
   }
   //人员图层对搜索出的人员打点
   markPersonList(personList, where = "") {
     const personMarkers = markPersonList.call(this, personList, where);
     this.setState({ personMarkers });
   }
   //人员的打点更换
   openPersonInfo(item, marker, type) {
     const markers = openPersonInfo.call(this, item, marker, type);
     // this.setState({
     //   personMarkers: markers,
     // });
   }
   // 地球搜索打点
   markEarthSearch(point) {
 
     var marker = new AMap.Marker({
       position: new AMap.LngLat(point.lng, point.lat),
     });
     this.state.map.add(marker);
     this.state.map.setCenter([point.lng, point.lat]);
     this.props.dispatch({
       type: "command/setEarthPoint",
       payload: {
         earthPoint: point,
       },
     });
   }
   //搜索出的驻勤点打点
   markerAttendanceList(attendanceList, typeName = "") {
     const attendanceMarkers = markerAttendanceList.call(
       this,
       attendanceList,
       typeName
     );
     this.setState({ attendanceMarkers });
   }
   //驻勤点的打点更换
   openAttendanceInfo({item, map, marker, currentIndex, afterIndex, layerStatus}) {
     const markers = openAttendanceInfo.call(this, {item, map, marker, currentIndex, afterIndex, layerStatus});
     //这里会导致类查询，先点开一个类型，点击该类型的一个驻勤点，在打开其他类型。所有的驻勤点值还是只有第一个打开的类型的驻勤点数量
     // this.setState({
     //   attendanceMarkers: markers,
     // });
   }
   createEventInfoWindow(data) {
     return CreateEventInfoWindow.call(this, data);
   }
   //定义单个的人员信息窗体
   createInfoWindow(data) {
     return CreateInfoWindow.call(this, data);
   }
   //驻勤点的信息窗体
   createAttendanceInfoWindow(data) {
     return CreateAttenInfoWindow.call(this, data);
   }
   //一张图的信息窗体（放在这是为了this的指向）
   createPicturePerception(data, name, type) {
     return CreatePicturePerception.call(this, data, name, type);
   }
   //清空点击数据
   clear(clearType) {
     //清空人员的点击数据
     this.props.dispatch({
       type: "command/" + clearType,
       payload: null,
     });
     this.props.dispatch({
       type: "command/clearInfoWindow",
       payload: true,
     });
   }
   //清空不是本tab下的驻勤点，并且打上自己原本有的驻勤点
   clearMarkerAdd(current, past) {
     if (this.state[past + "Markers"]) {
       //清空不属于自己tab下的驻勤点
       this.state.map.remove(this.state[past + "Markers"]);
     }
     if (this.state[current + "Markers"]) {
       this.state.map.add(this.state[current + "Markers"]);
       this.state.map.setFitView(this.state[current + "Markers"]); //自适应显示所有的标注点
     }
   }
   // 调度弹框底部配置
   //视频调度（单人与多人）
   async video({info = [], schedulingName = "个人调度", isNeedRecord = []}) {
     this.setState({ isNeedRecord, schedulingName })
     //输入人员信息，调度名称
     const Members = [];
     let videoMember = [];//用于记录是否已经进入房间使用
     info.map((item) => {
       Members.push(item.mobilePhone);
       videoMember.push({
         mobilePhone: item.mobilePhone,
         status: 'no',
         id: item.mobilePhone + 'no'
       })
     });
 
     console.log('video', 'fetchVideoMemberList');
     this.props.dispatch({
       type: 'command/fetchVideoMemberList',
       payload: {
         memberList: videoMember
       }
     })
     const Room_No = Math.round(new Date() / 1000);
     console.log('GIS-setState');
     this.setState({
       Room_No,
       MemberList: Members.join(","),
     });
     //视频人的信息
     //测试数据
     let memberCidList = []//视频人员cid
     let uidList = []//视频人员uid
     let cidInfoOwn = []//发起人cid
     let phoneOwn = this.state.mobilePhone//发起人cid
     let needRecordCidList = []//需要录屏的人员cid
     //邀请视频的所有人的信息（不包括发起人）
     console.log('video-info', info);
     for (let item of info) {
       if (item.mobilePhone) {
         const data = await searchDeptUser({
           keyWord: item.mobilePhone
         })
         // console.log('searchDeptUser', data);
         // data.data.data[0].cid = "957e72bc66e9405afc6a9b172b9cb639"
         if (data && data.data) {
           uidList.push(`${item.mobilePhone};${item.id};${item.domainid}`)
           // uidList.push(item.mobilePhone)
           memberCidList.push(data.data[0].item_cid)
           // memberCidList.push("2fbc66314f8740eb733d4ceaa8ba4085")
           if (isNeedRecord.length > 0) {
             for (let recordPhone of isNeedRecord) {
               if (recordPhone == item.mobilePhone) {
                 needRecordCidList.push(data.data[0].item_cid)
                 break;
               }
             }
           }
         } else {
           return message.info('视频人员未完成基础信息初始化，无法进行视频调度。')
         }
       } else {
         return message.info('视频人员未完成基础信息初始化，无法进行视频调度。')
       }
     }
     //发起人的信息
     if (uidList.length > 0) {
       let dataOwn = await searchDeptUser({
         keyWord: phoneOwn
       })
       // console.log('searchDeptUser', dataOwn);
       if (dataOwn && dataOwn.data) {
         // let userInfoOwnData = await getUserAllInfo(dataOwn.data.data[0].id);
         // if(userInfoOwnData.errcode === 0 && userInfoOwnData.data && userInfoOwnData.data.field24){
         cidInfoOwn = dataOwn.data[0].item_cid
         // }
         this.props.dispatch({
           type: "im/fetchV5Data",
           payload: {
             cid: cidInfoOwn,
             name: dataOwn.data[0].item_securityname
           }
         });
       } else {
         return message.info('视频人员未完成基础信息初始化，无法进行视频调度！')
       }
     } else {
       return message.info('视频人员未完成基础信息初始化，无法进行视频调度！')
     }
     const v5_comId = gup('v5_comId', window.location.href);
     if (!!memberCidList.join(",")) {
       // videoGenre: state.command.videoGenre, // 功能类型 0: 视频调度(一对多) 1: 视频上拉(一对一)
       const Yardman_Type = this.props.videoGenre == 0 ? 1 : 2
       sendVideoRoomMsg({
         RoomNo: Room_No, //房间号
         // MemberList: Members.join(","), //视频人员,cid，多个逗号隔开
         MemberList: memberCidList.join(","), //视频人员,cid，多个逗号隔开
         Yardman_Name: phoneOwn, //本人的公司名
         Yardman_Task_Name: schedulingName, //调度任务名称
         Yardman_Task_Explain: "任务说明", //调度任务说明(视频的时候不用填)
         Transcriber: isNeedRecord ? needRecordCidList : '',//需要录制的人员的cid，多个逗号隔开
         // transcribeMobiles: isNeedRecord ? isNeedRecord.join(",") : "", //需要录制的人员手机号
         Originator: cidInfoOwn + ';' + phoneOwn,//发起人 cid;useid
         // 'b54e5c73119c9991f567a743e1c5df20;15600070001'
         UseList: uidList.join(","),//视频人员uid（手机号;userId;组织id），跟MemberList一一对应
         ComId: v5_comId,//v5的企业ID
         Yardman_Type
       }).then((res) => {
         if (res.retType === "0") {
           this.state.map.clearInfoWindow();
           this.setState({
             createTaskStatus: false, //关掉任务创建页面
             videoStatus: true, //把视频页面打开
             // isNeedRecord,
           });
         }
       }).catch(err => {
         console.error();(err)
       });
     } else {
       message.warning("视频人员未完成基础信息初始化，无法进行视频调度")
     }
 
   }
   //文字调度事件（单人）
   character(info) {
     //添加会话（单人对单人）
     tim.getConversationProfile(`C2C${info.mobilePhone}`).then(
       ({ data }) => {
         // 3.1 更新当前会话
         this.props.dispatch({
           type: `im/updateCurrentConversation`,
           payload: data.conversation,
         });
         this.setState({
           conversationID: `C2C${info.mobilePhone}`,
           // imStatus: true,
           selectedData: info, //这个会把搜索列表的红标记去掉
           needCreateConversation: true,
         });
         eventCenter.emit('changeImStatus', true);
         // 3.2 获取消息列表
         this.getMessageList(data.conversation.conversationID);
         return Promise.resolve();
       },
       (err) => {
         // message.error(err.toString());
       }
     );
     this.state.map.clearInfoWindow();
   }
   //文字调度（多人，先创建群组）
   createGroup() {
     const Members = [];
     const memberList = [];
     Members.push(this.props.adminPhone + "admin");
     this.state.selectedPoints.map((item) => {
       Members.push(item.mobilePhone);
       memberList.push({
         userID: item.mobilePhone + "",
       });
     });
     let options = {
       name: this.state.schedulingName,
       type: TIM.TYPES.GRP_PRIVATE,
       memberList,
     };
     tim
       .createGroup(options)
       .then((info) => {
         //创建成功之后，往里面发送一条消息
         this.sendTextMessage(info.data.group.groupID);
         this.setState({ selectedPointsStatus: false }); //关闭调度的窗口
       })
       .catch((err) => {
         console.error(err);
       });
   }
   //语音调度（单人）单人的就是打开会话，然后调用录音
   voice(data) {
     this.setState({
       onlyPersonVoiceStatus: true,
       selectedData: data,
     });
     this.state.map.clearInfoWindow();
   }
   //语音调度（多人）,//先创建一个群，录完音，在这个会话中发送该录音
   voiceGroup(url, time) {
     const memberList = [];
     this.state.selectedPoints.map((item) => {
       memberList.push({
         userID: item.mobilePhone + "",
       });
     });
     let options = {
       name: this.state.schedulingName,
       type: TIM.TYPES.GRP_PRIVATE,
       memberList,
     };
     tim
       .createGroup(options)
       .then((info) => {
         //创建成功之后，往里面发送一条消息
         this.sendCustomMessage(
           info.data.group.groupID,
           url,
           time,
           TIM.TYPES.CONV_GROUP
         );
         this.state.map.remove([this.state.overlays]);
         this.state.map.clearInfoWindow();
         this.setState({ showRecord: false, selectedPointsStatus: false });
       })
       .catch((err) => {
         console.error(err);
       });
   }
   //发送文字消息
   sendTextMessage(groupID) {
     const messageData = tim.createTextMessage({
       to: groupID,
       conversationType: TIM.TYPES.CONV_GROUP, //群组调度
       payload: { text: this.state.schedulingContent },
     });
     tim
       .sendMessage(messageData)
       .then((res) => {
         //获取当前的会话
         this.getCurrentConvarsation(groupID);
       })
       .catch((err) => {
         message.error("发送失败");
       });
   }
   //发送自定义消息
   sendCustomMessage(groupID, url, time, type) {
     const content = {
       url,
       time,
     };
     const messageSound = tim.createCustomMessage({
       to: groupID,
       conversationType: type,
       payload: {
         data: "Sound", // 用于标识该消息是音频类型消息
         description: "[语音]", // 获取音频路径
         extension: JSON.stringify(content),
       },
     });
     tim
       .sendMessage(messageSound)
       .then((res) => {
         if (type === TIM.TYPES.CONV_GROUP) {
           //获取群组当前的会话
           this.getCurrentConvarsation(groupID);
         } else {
           //获取个人当前的会话
           this.getMessageList(res.data.message.conversationID);
         }
       })
       .catch((err) => {
         message.error("发送失败");
       });
   }
   //发送音频mp3
   createAudioMessage(groupID, url, time, type,state) {
    console.log('state语音blob流',state.blob)
    let audioFile = new File([state.blob], 'hello.wav', { type: 'wav' });
    audioFile.duration = time;
    console.log('audioFile',audioFile)
    // const content = {
    //   url,
    //   time,
    // };
    const messageSound = tim.createAudioMessage({
      to: groupID,
      conversationType: type,
      payload: {
        file: audioFile,//blob转file文件
        // data: "Sound", // 用于标识该消息是音频类型消息
        // description: "[语音]", // 获取音频路径
        // extension: JSON.stringify(content),
      },
    });
    messageSound.payload.second=time //语音时长
    console.log('messageSound',messageSound)
    tim
      .sendMessage(messageSound)
      .then((res) => {
        if (type === TIM.TYPES.CONV_GROUP) {
          //获取群组当前的会话
          this.getCurrentConvarsation(groupID);
        } else {
          console.log('777')
          console.log(res.data.message.conversationID)
          //获取个人当前的会话
          this.getMessageList(res.data.message.conversationID);
        }
      })
      .catch((err) => {
        message.error("发送失败");
      });
  }
   //获取当前的会话
   getCurrentConvarsation(groupID) {
     tim.getConversationProfile(`GROUP${groupID}`).then(({ data }) => {
       // 3.1 更新当前会话
       this.props.dispatch({
         type: `im/updateCurrentConversation`,
         payload: data.conversation,
       });
       this.setState({
         createTaskStatus: false,
         // imStatus: true,
         conversationID: "GROUP" + groupID,
       }); //打开im的会话框
       eventCenter.emit('changeImStatus', true);
       // 3.2 获取消息列表
       this.getMessageList(data.conversation.conversationID);
       return Promise.resolve();
     });
   }
   //获取当前会话的消息列表
   getMessageList(conversationID) {
     const { nextReqMessageID, currentMessageList } = this.props;
     tim
       .getMessageList({ conversationID, nextReqMessageID, count: 15 })
       .then((imReponse) => {
         // 更新messageID，续拉时要用到
         this.props.dispatch({
           type: "im/updateCurrentConversationCont",
           payload: {
             nextReqMessageID: imReponse.data.nextReqMessageID,
             isCompleted: imReponse.data.isCompleted,
             currentMessageList: [
               ...imReponse.data.messageList,
               ...currentMessageList,
             ], // 更新当前消息列表，从头部插入
           },
         });
       });
   }
   //卫星地图切换
   setSatellite(satellite) {
     if (satellite) {
       this.state.locaMap.add(this.state.satelliteLayer)
       this.state.map.setMapStyle('normal')
     }
     // this.setState({ satellite })
   }
   setModalBtn = () => {
     const { layoutAuthority } = this.props;
     const { layerSatatus } = this.state;
     let btns = []
     if (layerSatatus == "attendance") {
       if (layoutAuthority.basisLayer) {
         btns = [
           <span style={{ float: "left" }} key="number">
             共选中{this.state.selectedPoints.length}人
           </span>,
           <Button
             key="text"
             type="primary"
             onClick={() => {
               const that = this;
               //超过50人
               if (
                 this.state.selectedPoints.length > 50 &&
                 this.state.selectedPoints.length < 100
               ) {
                 Modal.confirm({
                   title: "提示",
                   content:
                     "您调度人员已经超过50人，建议减少人数已达到调度效果。",
                   okText: "继续调度",
                   onOk() {
                     that.setState({
                       selectedPointsStatus: false,
                       createTaskStatus: true,
                     });
                   },
                   cancelText: "重新选择",
                   onCancel() {
                     that.setState({ selectedPointsStatus: false });
                     that.state.map.remove([that.state.overlays]);
                   },
                 });
               } else if (this.state.selectedPoints.length > 100) {
                 Modal.error({
                   title: "提示",
                   content:
                     "您调度人员已经超过100人，请减少人数已达到调度效果。",
                   okText: "重新选择",
                   onOk() {
                     that.setState({ selectedPointsStatus: false });
                     that.state.map.remove([that.state.overlays]);
                   },
                 });
               } else {
                 this.setState({
                   selectedPointsStatus: false,
                   createTaskStatus: true,
                   dispatchType: "text",
                 });
               }
             }}
           >
             文字调度
           </Button>,
           <Button
             key="voice"
             type="primary"
             onClick={() => {
               this.setState({
                 dispatchType: "voice",
                 selectedPointsStatus: false,
                 createTaskStatus: true,
               });
             }}
           >
             语音调度
           </Button>,
         ];
       } else {
         btns = []
       }
     } else if (layerSatatus == "aPicture") {
       btns = [
         <span style={{ float: "left" }} key="number">
           共选中{this.state.selectedPoints.length}人
         </span>,
         <Button
           key="text"
           type="primary"
           onClick={() => {
             const that = this;
             //超过50人
             if (
               this.state.selectedPoints.length > 50 &&
               this.state.selectedPoints.length < 100
             ) {
               Modal.confirm({
                 title: "提示",
                 content:
                   "您调度人员已经超过50人，建议减少人数已达到调度效果。",
                 okText: "继续调度",
                 onOk() {
                   that.setState({
                     selectedPointsStatus: false,
                     createTaskStatus: true,
                   });
                 },
                 cancelText: "重新选择",
                 onCancel() {
                   that.setState({ selectedPointsStatus: false });
                   that.state.map.remove([that.state.overlays]);
                 },
               });
             } else if (this.state.selectedPoints.length > 100) {
               Modal.error({
                 title: "提示",
                 content:
                   "您调度人员已经超过100人，请减少人数已达到调度效果。",
                 okText: "重新选择",
                 onOk() {
                   that.setState({ selectedPointsStatus: false });
                   that.state.map.remove([that.state.overlays]);
                 },
               });
             } else {
               this.setState({
                 selectedPointsStatus: false,
                 createTaskStatus: true,
                 dispatchType: "text",
               });
             }
           }}
         >
           文字调度
         </Button>,
         <Button
           key="voice"
           type="primary"
           onClick={() => {
             this.setState({
               dispatchType: "voice",
               selectedPointsStatus: false,
               createTaskStatus: true,
             });
           }}
         >
           语音调度
         </Button>,
         <Button
           style={{ display: this.props.layoutAuthority.basisLayer }}
           key="video"
           type="primary"
           onClick={() => {
             this.setState({
               dispatchType: "video",
               selectedPointsStatus: false,
               createTaskStatus: true,
             });
             // if(this.state.selectedPoints.length>8){
             //   message.info('目前最多自能调度8人');
             // }else{
             //   this.setState({
             //     dispatchType: "video",
             //     selectedPointsStatus: false,
             //     createTaskStatus: true,
             //   });
             // }
           }}
         >
           视频调度
         </Button>,
       ]
     }
     return btns;
   }
   /******************************相关事件******************************/
   render() {
     const { mapStyle } = this.props;
     const clsNameRadio =  classNames("radio_container", mapStyle);
     console.log('GIS-state',this.state);
     return (
       <Container className="lalal" key="GIS" style={{
         backgroundColor: this.state.showEarchMap ? '#000' : '#fff'
       }}>
         {/* 所有地图图层 */}
         <EarthMap showEarchMap={this.state.showEarchMap} markEarthSearch={this.markEarthSearch.bind(this)}
           earthMap={this.state.earthMap} clearRotation={() => { clearInterval(this.state.rotation) }}
         />
         <AllMapLayer layerSatatus={this.state.layerSatatus} showEarchMap={this.state.showEarchMap} />
         <div>
           {/* 基础信息的搜索框 */}
           {this.state.map && this.state.layerSatatus == "attendance" && (
             <SearchListTab
               //调度处理
               changeImStatus={(value) => {
                 eventCenter.emit('changeImStatus', value);
               }}
               //群组里的视频调度，获取多人的调度逻辑
               groupVideo={(list) => {
                 // console.log('GIS-setState');
                 this.setState({
                   createTaskStatus: true,
                   selectedPoints: list,
                   dispatchType: "video",
                 });
               }}
             />
           )}
           {/* 人员的搜索框 */}
           <PersonSearch
             layerSatatus={this.state.layerSatatus}
             markesBeiJing={() => {
               //驻点北京
               var marker = new AMap.Marker({
                 position: new AMap.LngLat(116.344081, 39.940512), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
               });
               // console.log('GIS-setState');
               this.setState({
                 beijingMarkers: marker,
               });
               this.state.map.add(marker);
               this.state.map.setFitView(marker);
             }}
             markesGaoQi={() => {
               //驻点高崎
               var marker = new AMap.Marker({
                 position: new AMap.LngLat(118.12902, 24.533153), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
               });
               // console.log('GIS-setState');
               this.setState({
                 gaoqiMarkers: marker,
               });
               this.state.map.add(marker);
               this.state.map.setCenter([118.12902, 24.533153]);
             }}
             beijingVideo={(value) => {
               // console.log('GIS-setState');
               this.setState({
                 beijingVideo: value,
               });
             }}
           />
           {/* 一张图数据层 */}
           {this.state.map && this.state.layerSatatus == "aPicture" && !this.state.showEarchMap && (
             <APicture
               _thisGIS={this}
               //数据展示的增加打点@param where:数据展示（‘’）/周边搜索（searchView）
               // addPictueMarks={(addData, type, where = '') => {
               //   APictureAddPictueMarks.call(this, addData, type, where)
               // }}
               //数据展示的减少打点
               // reducePictueMarks={(reduceData, type, where = '') => {
               //   APictureReducePictueMarks.call(this, reduceData, type)
               // }}
               //实时异常增加打点
               addNowErrorEvent={(data) => {
                 markNowErrorEvent.call(this, data)
               }}
               searchAround={this.state.searchAround}
               changeShowSearchView={(value) => { this.setState({ searchAround: { ...this.state.searchAround, show: value } }) }}
               setSatellite={this.setSatellite.bind(this)}
               locaMap={this.state.locaMap}
               satelliteLayer={this.state.satelliteLayer}
             />
           )}
           {/* 警保联动数据层 */}
           {this.state.map && this.state.layerSatatus == "police" && (
             <Police
               _thisGIS={this}//将GIS的this事件传下去，在自己的页面去处理地图事件
               layerSatatus={this.state.layerSatatus}
               //一张图数据展示的增加打点
               // addPictueMarks={(addData, type, where = '') => {
               //   APictureAddPictueMarks.call(this, addData, type, where)
               // }}
               //一张图数据展示的减少打点
               // reducePictueMarks={(reduceData, type, where = '') => {
               //   APictureReducePictueMarks.call(this, reduceData, type, where)
               // }}
               searchAround={this.state.searchAround}
               changeShowSearchView={(value) => { this.setState({ searchAround: { ...this.state.searchAround, show: value } }) }}
             />
           )}
           {/* 南宁武装押运管控图层 */}
           {
             this.state.map && this.state.layerSatatus == "nanNing" && <NanNing _thisGIS={this} />
           }
           {/* 顶部按钮组件 */}
           { !this.state.showEarchMap && <TopButton
               layerStatus={this.state.layerSatatus}
               gisMAP={this.state.map}
               localMap={this.state.locaMap}
               satelliteLayer={this.state.satelliteLayer}
               setSatellite={this.setSatellite.bind(this)}
               _thisGIS={this}
               conversationID={this.state.conversationID}
             />
           }
           {/* 最顶部的图标切换 */}
 
           {/* 调度人数确认 */}
           <Modal
             className="selected-points-modal"
             // title="调度"
             visible={this.state.selectedPointsStatus}
             onOk={this.handleOk}
             onCancel={() => {
               this.setState({ selectedPointsStatus: false });
               this.state.map.remove([this.state.overlays]);
             }}
             footer={this.setModalBtn()}
           >
             <div>
               <Row gutter={24}>
                 {this.state.selectedPoints.map((item, index) => {
                   return (
                     <Col span={12} key={index}>
                       <div
                         className="content-window-card"
                         style={{ marginBottom: 10 }}
                       >
                         <div className="info-middle">
                           {item.photoUrl ? (
                             <img className="avator" src={item.photoUrl}></img>
                           ) : (
                             <span className="avator span-header">
                               {item.name
                                 ? item.name.substring(
                                   item.name.length - 2,
                                   item.name.length
                                 )
                                 : ""}
                             </span>
                           )}
                           <div className="text">
                             <div className="name">{item.name}</div>
                             <div>手机号：{item.mobilePhone}</div>
                             <div>证件号码：{item.idCardNo}</div>
                           </div>
                         </div>
                       </div>
                     </Col>
                   );
                 })}
               </Row>
             </div>
           </Modal>
           {/* 调度任务创建 */}
           <Modal
             className="create-task-modal"
             visible={this.state.createTaskStatus}
             onOk={this.handleOk}
             onCancel={() => {
               this.setState({ createTaskStatus: false });
               this.state.map.remove([this.state.overlays]);
             }}
             footer={
               //语音调度的时候，不需要取消、开始调度按钮
               this.state.dispatchType === "voice"
                 ? ""
                 : [
                   <Button
                     key="voice"
                     onClick={() => {
                       this.setState({ createTaskStatus: false });
                       this.state.map.remove([this.state.overlays]);
                     }}
                   >
                     取消调度
                   </Button>,
                   <Button
                     key="text"
                     type="primary"
                     onClick={() => {
                       if (this.state.dispatchType === "text") {
                         if (this.state.schedulingName.trim().length === 0) {
                           message.warning("请输入调度任务名称");
                         } else if (
                           this.state.schedulingContent.trim().length === 0
                         ) {
                           message.warning("请输入调度任务内容");
                         } else {
                           this.state.map.remove([this.state.overlays]);
                           //输入的数据都没有错的时候，开始文字调度（创建群组）
                           this.createGroup();
                         }
                       }
                       if (this.state.dispatchType === "voice") {
                         //语音调度
                       }
                       if (this.state.dispatchType === "video") {
                         if (this.state.schedulingName.trim().length === 0) {
                           message.warning("请输入调度任务名称");
                         } else if (this.state.recordMobile.length > 16) {
                           message.error("录制人数限制16个以内,请重新选择")
                         } else {
                           this.state.map.remove([this.state.overlays]);
                           this.state.map.clearInfoWindow();
                           //开始视频调度
                           // this.video(
                           //   this.state.selectedPoints,
                           //   this.state.schedulingName.trim(),
                           //   this.state.recordMobile
                           // ); //选中的人员，调度任务名称
                           eventCenter.emit('clickTextScheduling', {
                             item: this.state.selectedPoints,
                             name: this.state.schedulingName.trim(),
                             isNeedRecord: this.state.recordMobile,
                             type: "video"
                           });
                         }
                       }
                     }}
                   >
                     开始调度
                   </Button>,
                 ]
             }
           >
             <ModalView
               selectedPoints={this.state.selectedPoints}
               dispatchType={this.state.dispatchType}
               showRecord={this.state.showRecord}
               schedulingName={(value) => {
                 this.setState({ schedulingName: value });
               }}
               schedulingContent={(value) => {
                 this.setState({ schedulingContent: value });
               }}
               voiceGroup={(url, time) => {
                 this.voiceGroup(url, time);
               }}
               showRecord={(value) => {
                 this.setState({ showRecord: value });
               }}
               onCheckPerRecord={(recordMobile) => {
                 this.setState({ recordMobile });
               }}
             />
           </Modal>
 
           {/* IM视频页面 */}
           {this.state.videoStatus && (
             <Video
               Room_No={this.state.Room_No}
               mobilePhone={this.state.mobilePhone}
               imSig={this.props.imSig}
               closeVideoState={() => {
                 this.setState({
                   videoStatus: !this.state.videoStatus,
                 });
               }}
               _thisGIS={this}
               schedulingName={this.state.schedulingName}
               isNeedRecord={this.state.isNeedRecord}
             ></Video>
           )}
           {/* Web 端设备及网络检测公共组件 */}
           {/* <DeviceDetector
             visible={this.state.deviceDetect}
             onClose={()=>{
               this.setState({ deviceDetect: false })
               eventCenter.emit('clickTextScheduling', this.state.deviceDetectInfo);
             }}
             hasNetworkDetect={false}
             // networkDetectInfo={this.state.deviceDetectInfo}
           /> */}
           {/* 视频调度九宫格 */}
           {/* <VideoBox></VideoBox> */}
           {/* 单人的语音调度调起的录音页面 */}
           {this.state.onlyPersonVoiceStatus && (
             <div className="only-person-voice">
               <div className="avatar-header">
                 {this.state.selectedData.photoUrl ? (
                   <img src={this.state.selectedData.photoUrl}></img>
                 ) : (
                   <span className="img-span">
                     {this.state.selectedData.name.substring(
                       this.state.selectedData.name.length - 2,
                       this.state.selectedData.name.length
                     )}
                   </span>
                 )}
                 <span className="label-voice">语音调度</span>
                 <div
                   className="close"
                   onClick={() => {
                     this.setState({
                       onlyPersonVoiceStatus: false,
                     });
                   }}
                 >
                   x
                 </div>
               </div>
               <Record
                 where="index"
                 sendSound={(url, time,state) => {
                   //点击了发送
                   //关掉单人的录音页面
                   this.setState({
                     onlyPersonVoiceStatus: false,
                   });
                   //主要是区分了群组页面的语音调度内容
                   const conversonID = this.state.selectedData.mobilePhone
                     ? `C2C${this.state.selectedData.mobilePhone}`
                     : this.state.selectedData.conversonGroupID;
                   const type = this.state.selectedData.mobilePhone
                     ? TIM.TYPES.CONV_C2C
                     : TIM.TYPES.CONV_GROUP;
                   const id = this.state.selectedData.mobilePhone
                     ? this.state.selectedData.mobilePhone + ""
                     : this.state.selectedData.group;
                   tim.getConversationProfile(conversonID).then(({ data }) => {
                     // 3.1 更新当前会话
                     this.props.dispatch({
                       type: `im/updateCurrentConversation`,
                       payload: data.conversation,
                     });
                     this.setState({
                       conversationID: conversonID,
                       // imStatus: true,
                       needCreateConversation: true,
                     });
                     eventCenter.emit('changeImStatus', true);
                     //发送单人的语音
                    //  this.sendCustomMessage(id, url, time, type);
                     this.createAudioMessage(id, url, time, type,state);
                     return Promise.resolve();
                   });
                 }}
               />
             </div>
           )}
           {/* 北京展览馆视频 */}
           {this.state.beijingVideo ? (
             <BeijingVideo
               changeBeijingVideo={(value) =>
                 this.setState({ beijingVideo: value })
               }
             />
           ) : (
             ""
           )}
         </div>
       </Container>
     );
   }
 }
 
 const Container = style.div`
               width:100%;
               height:100%;
             `;
 