/**
 * 通过搜索获得地图列表(保安人员)
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Pagination, message, Icon, Input, Button, Tooltip } from "antd";
// import "../person.less";
import PersonItem from "./PersonItem";
import { getPersonList, getTaskList,getSecuritymanByDomainid } from "@services/api";
import eventCenter from "@common/events"; // 引入 EventEmitter
@connect((state) => ({
  selectedId: state.command.personList.selectedId,
  tabIndex2: state.command.tabIndex.person.tabIndex2,
  selectComponeyInfo: state.command.selectComponeyInfo,
}))
export default class AllPerson extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tabKey: "1",
      currentKey: '1', //主要用于处理tab页面改变，不让重新请求数据
      searchData: {
        pageNumber: 1,
        pageSize: 6,
        search_smName: '',
      },
      personList: [], //人员列表数据
      height: null, //最大高度
      loadingText: "暂无数据",
    };
  }

  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130 - 40;
    this.setState({ height });
    this.getPersonList(1);
  }
  componentWillReceiveProps(nextProps) {

    console.log('componentWillReceiveProps', nextProps.tabIndex2 , this.state.tabKey);
    console.log('componentWillReceiveProps', nextProps.tabIndex2 , this.state.currentKey);
    if (
      nextProps.tabIndex2 == this.state.tabKey && //定位当前tab页是自己
      nextProps.tabIndex2 != this.state.currentKey //用于不让数据一直刷新
    ) {
      console.log("componentWillReceiveProps");
      this.setState({
        currentKey: nextProps.tabIndex2,
      });
      this.getPersonList(this.state.searchData.pageNumber);
    }
    if (nextProps.tabIndex2 != this.state.tabKey) {
      this.setState({
        currentKey: null,
      });
    }
  }
  getPersonList(pageNumber) {
    const { isTask,selectComponeyInfo } = this.props;
    this.props.dispatch({
      type: "command/setPersonSelectIndex",
      payload: null,
    });
    eventCenter.emit('clearMapTag', 'securityResource');
    this.setState(
      {
        searchData: {
          ...this.state.searchData,
          pageNumber,
        },
        loadingText: "正在加载中...",
        personList: []
      },
      () => {
        // getComPerLocationByKeyword({
        //   ...this.state.searchData,
        // }).then((res) => {
        //   if (res.retType === "0") {
        //     this.setState({
        //       personList: res.data.data,
        //       total: res.data.total,
        //       loadingText: res.data.data.length > 0 ? "加载完成" : "暂无数据",
        //     });
        //     this.props.dispatch({
        //       type: "command/fetchPersonList",
        //       payload: {
        //         list: res.data.data,
        //       },
        //     });
        //   }
        // });
        let getFun = getSecuritymanByDomainid;
        let param = 'getSecurity'
        // 获取在勤保安员列表数据
        if (isTask) {
          getFun = getTaskList
          param = 'getTask'
        }
        getFun({
          _currpage:this.state.searchData.pageNumber,
          lines:this.state.searchData.pageSize,
        },{
          search_smName:this.state.searchData.search_smName,
          id:selectComponeyInfo.selectComponeyId
        }).then(res=>{
          let result = res.data.data.map((item) => {
            if(param=='getSecurity'){
              item.perId = item.ID
              item.name = item.item_securityname 
              delete item.item_securityname
              let lnglatData =item.location? JSON.parse(item.location):''
              item.lnglat =lnglatData? [lnglatData.longitude,lnglatData.latitude]:''
              item.location = lnglatData? [lnglatData.longitude,lnglatData.latitude]:''
              item.longitude = lnglatData.longitude;
              item.latitude = lnglatData.latitude;
              delete item.location
              item.idCardNo = item.item_documentid 
              delete item.item_documentid
              item.mobilePhone = item.item_phone
              delete item.item_phone
              return item
            }else{
              item.perId = item.id
              item.ID = item.id;
              delete item.id
              item.name = item.securityName ? item.securityName : item.principalName
              delete item.securityName
              delete item.principalName
              let lnglatData =item.item_lonlatjson? JSON.parse(item.item_lonlatjson):''
              item.lnglat =lnglatData? [lnglatData.longitude,lnglatData.latitude]:''
              item.location = lnglatData? [lnglatData.longitude,lnglatData.latitude]:''
              item.longitude = lnglatData.longitude;
              item.latitude = lnglatData.latitude;
              // item.lnglat = [118.051982,24.607542]
              delete item.item_lonlatjson
              item.idCardNo = item.documentID ? item.documentID : item.principalIdCardNo
              delete item.documentID
              delete item.principalIdCardNo
              item.mobilePhone = item.phone ? item.phone : item.principalPhoneNo
              delete item.principalPhoneNo
              return item

            }
              
          })
          this.props.dispatch({
            type: "command/setPersonSelectIndex",
            payload: null,
          });
          this.props.dispatch({
            type: "command/clearInfoWindow",
            payload: true,
          });
          this.setState({
            personList: result,
            total: res.data.total,
            loadingText: result.length > 0 ? "加载完成" : "暂无数据",
          });
          console.log(result)
          // this.props.dispatch({
          //   type: "command/fetchPersonList",
          //   payload: {
          //     list: result,
          //   },
          // });

          eventCenter.emit('addPictueMarks', {
            data: {
              data: result
            },
            type: "securityResource"
          });
        })
      }
    );
  }
  onPersonClick=(item)=>{
    this.props.onPersonClick && this.props.onPersonClick(item);
  }
  render() {
    return (
      <div className="data-list">
        <div className="input" style={{ display: "flex", justifyContent: "space-between" }}>
          <Input
            placeholder="请输入人员姓名:"
            style={{ maxWidth: 270, minWidth: 210, width: '100%' }}
            onChange={(e) => {
              this.setState({
                searchData: {
                  ...this.state.searchData,
                  search_smName: e.target.value.trim(),
                },
              });
            }}
            onPressEnter={() => {
              //按下回车的事件
              this.getPersonList(1);
            }}
          />
          <Button
            type="primary"
            onClick={() => {
              this.getPersonList(1);
            }}
          >
            <Icon type="search" style={{ fontSize: "16px" }} />
          </Button>
        </div>

        <div className="security search-list_command amap_lib_placeSearch">
          <div
            className="list"
            style={{ maxHeight: this.state.height, overflow: "auto" }}
          >
            <PersonItem
              onClick={this.onPersonClick}
              data={this.state.personList}
              loadingText={this.state.loadingText}
            />
          </div>
          <Pagination
            total={this.state.total}
            size="small"
            onChange={(number) => {
              this.getPersonList(number);
            }}
            defaultPageSize={this.state.searchData.pageSize}
            current={this.state.searchData.pageNumber}
            style={{
              display:
                this.state.total > this.state.searchData.pageSize
                  ? "block"
                  : "none",
              textAlign: 'center'
            }}
          />
        </div>
      </div>
    );
  }
}
