import React, { PureComponent } from "react";
import AllAttendance from "./AllAttendance";
import TypeAttendance from "./TypeAttendance";
import { Tabs } from "antd";
import { connect } from "dva";
const { TabPane } = Tabs;

@connect((state) => ({
  tabIndex: state.command.tabIndex,
}))
export default class Attendance extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      visible: props.visible,
    };
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps.visible !== this.state.visible) {
      this.setState({
        visible: nextProps.visible,
      });
    }
  }
  render() {
    return (
      <div
        className="child-searchList"
        style={{ display: this.state.visible ? "block" : "none" }}
      >
        <Tabs
          defaultActiveKey={this.props.tabIndex.attendance.tabIndex2 || "1"}
          onChange={(index) => {
            this.props.dispatch({
              type: "command/setTabIndex",
              payload: {
                attendance: {
                  tabIndex2: index,
                },
                // tabIndex2: "1",
              },
            });
            this.props.dispatch({
              type: 'command/clearInfoWindow',
              payload: true
            })
          }}
        >
          <TabPane tab="所有驻勤点" key="1">
            <AllAttendance key="1" />
          </TabPane>
          {/* <TabPane tab="按类型查询" key="2" disabled>
            <TypeAttendance key="2" />
          </TabPane>
          <TabPane tab="按地区查询" key="3" disabled>
            待开发中...
          </TabPane> */}
        </Tabs>
      </div>
    );
  }
}
