/**
 * 搜索保安员，保安公司，驻勤点的功能
 */
import React, { Component } from "react";
import { connect } from "dva";
import styles from './index.less';
import { Input, Checkbox, Row, Col, Button, message } from 'antd';
import { getSearchInformation, getPoliceSearchInformation } from '../../../../services/api';
import eventCenter from "@common/events"; // 引入 EventEmitter

@connect((state) => ({
  searchAround: state.command.searchAround,
  mapStyle: state.command.mapStyle,
  pictureMarkersList: state.command.pictureMarkersList,
}))
export default class InfoSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      range: 400,
      checkdata: [],
      securityManData: {
        data: []
      },//搜索出来的保安员数据
      situationData: [],//动态感知的数据
      circle: null
    };
  }
  componentDidMount() {
  }
  searchInfo(e) {
    let { securityResource, securityCompany, attendancePoint } = this.props.pictureMarkersList;
    if (securityResource.length > 0) {
      this.propsOption('reduce', {
        data: securityResource[0].data,
      }, 'securityResource')
    }
    if (securityCompany.length > 0) {
      this.propsOption('reduce', {
        data: securityCompany[0].data,
      }, 'securityCompany')
    }
    if (attendancePoint.length > 0) {
      this.propsOption('reduce', {
        data: attendancePoint[0].data,
      }, 'attendancePoint')
    }
    this.state.checkdata.forEach(item => {
      switch (item) {
        case 'A':
          // 保安公司
          let data = { data: [{ latitude: "24.603706", longitude: "118.054048", name: "负责人", companyName: "防控指挥公司", componeyLogo: "", mobilePhone: "123" }] }
          this.propsOption('add', data, "securityCompany")
          break;
        case 'B':
          // 保安员
          // location = {longitude:"118.051982",latitude:"24.607542"}
          let data2 = [{
            ATTENDANCESITENAME: null,
            DEPTNAME: "保安部",
            ID: "0TjufwmZhCVm4KKqBQB",
            TUserID: "track__2t8RijBWNoIGeIjqotR0TjufwmZhCVm4KKqBQB",
            domainid: "__2t8RijBWNoIGeIjqotR",
            formId: null,
            id: "0TjufwmZhCVm4KKqBQB",
            location: "",
            longitude: "118.051982",
            latitude: "24.607542",
            mobilePhone: "17700011712",
            name: "司秀隽",
            phone: "17700011712",
            pirture: null,
            securityName: "司秀隽",
          }]
          this.propsOption('add', { data: data2 }, 'securityResource')
          break;
        case 'C':
          // 驻勤点
          let param = {
            attendName: "驻勤点名称",
            latitude: "24.606064",
            longitude: "118.046998",
            componey: "所属公司",
            name: "负责人姓名",
            phone: "负责人电话",
            address: "驻勤点省市区",
            addressDetail: "驻勤点详细地点",
            scope: "执勤范围",
            org: "所属监管机构",
            obj: "服务对象名称",
            contract: "合同状态",
          }
          this.propsOption('add', { data: [param] }, "attendancePoint");
          break;
      }
    })
  }
  propsOption(optionType, data, type) {
    switch (optionType) {
      case 'add':
        eventCenter.emit('addPictueMarks', {
          data: data,
          type: type,
        });
        // this.props.addPictueMarks(data, type);
        break;
      case 'reduce':
        // this.props.reducePictueMarks(data, type);
        eventCenter.emit('reducePictueMarks', {
          data,
          type
        })
        break;
    }
  }
  //清掉所有周边搜索打点的值,并且把圆圈去掉
  clearAll() {
    const { searchAround, _thisGIS } = this.props
    const { circle } = this.state
    if (searchAround.securitySearch.length > 0) {
      let data = {
        data: searchAround.securitySearch
      }
      // this.props.reducePictueMarks(data, 'securityResource', {
      //   where: 'searchAround',
      //   type: 'A'
      // });
      eventCenter.emit('reducePictueMarks', {
        data,
        type: 'securityResource',
        where: {
          where: 'searchAround',
          type: 'securitySearch'
        }
      })
    }
    if (searchAround.awarenessSearch.length > 0) {
      let data = {
        data: searchAround.awarenessSearch
      }
      // this.props.reducePictueMarks(data, 'perception', {
      //   where: 'searchAround',
      //   type: 'B'
      // });
      eventCenter.emit('reducePictueMarks', {
        data,
        type: 'perception',
        where: {
          where: 'searchAround',
          type: 'awarenessSearch'
        }
      })
    }
    //先把之前的圆圈去掉
    if (circle) {
      _thisGIS.state.map.remove(circle);
    }
  }
  render() {
    const { range } = this.state
    return (
      <div className={this.props.mapStyle}>
        <div className={styles.info__search}>
          <Input.Search
            className={styles.search_input}
            size="large"
            placeholder="请输入公司名称/驻勤点名称/保安人员名称"
            enterButton="搜索"
            onSearch={e => this.searchInfo(e)}
          />
          <div className={styles.check_box}>
            <Checkbox.Group style={{ width: '100%' }} onChange={(e) => { this.setState({ checkdata: e }) }}>
              <Row>
                <Col span={8}>
                  <Checkbox value="A" style={{ color: this.props.mapStyle == 'dark' ? '#fff' : '#000' }}>保安公司</Checkbox>
                </Col>
                <Col span={8}>
                  <Checkbox value="B" style={{ color: this.props.mapStyle == 'dark' ? '#fff' : '#000' }}>保安员</Checkbox>
                </Col>
                <Col span={8}>
                  <Checkbox value="C" style={{ color: this.props.mapStyle == 'dark' ? '#fff' : '#000' }}>驻勤点</Checkbox>
                </Col>
              </Row>
            </Checkbox.Group>
          </div>
        </div>
      </div>
    );
  }
}
