/**
 * 选择人员弹窗 @CYQ
 * 1、人员是根据部门来动态获取
 * 2、人员有分页功能
 * param:
 * 3、huaweiMeeting字段用来区分是否是华为云会议（华为云会议获取的人员数据是另一个接口）
 */
import React, { Component } from "react";
import { Modal, Icon, message } from "antd";

import GetUser from "./GetUser";
import "./index.less";

class SelectPersonnelPop extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      checkedkeys: this.props.value || [],
      visible: this.props.visible,
      defaultArrayObj: this.props.defaultArrayObj,
      arrayObj: [],
      huaweiMeeting:this.props.huaweiMeeting||false
    };
  }
componentDidMount(){
}
  componentWillReceiveProps(nextprops) {
    this.setState({
      visible: nextprops.visible,
    });
  }

  handleCancel = () => {
    this.setState({
      visible: false,
      checkedkeys: [],
      arrayObj: []
    });
    this.props.handleCancel();
  };

  handleOk = () => {
    if (this.state.checkedkeys.length === 0) {
      return message.error("请至少选择一个人员");
    }
    this.setState({
      visible: false
    });
    this.props.onCheck(
      this.state.checkedkeys,
      this.state.arrayObj
    );
    //之后初始化选择框的数据
    this.setState({
      checkedkeys: [],
      arrayObj: []
    });
  };

  render() {
    let { arrayObj } = this.state;
    const selectedList = () => {
      return arrayObj.map((val, i) => {
        return (
          <div key={val.perId} className="PartmentSelect-list-item">
            <Icon type="user" /> {val.title || val.name}{val.idCardNo?'('+val.idCardNo+')':''}
            <Icon
              style={{ cursor: 'pointer' }}
              onClick={() => {
                let checkedkeys = this.state.checkedkeys.slice();
                if (checkedkeys instanceof Array) {
                  checkedkeys = checkedkeys.filter(value => {
                    if (val.perId === value) {
                      arrayObj.splice(i, 1);
                    }
                    return val.perId !== value;
                  });
                } else {
                  checkedkeys = [];
                  arrayObj = [];
                }
                this.setState({ checkedkeys, arrayObj });
              }}
              type="close-circle-o"
            />
          </div>
        );
      });
    };

    return (
      <div>
        <Modal
          title={this.props.title || "选择人员"}
          wrapClassName="PartmentSelect"
          closable={false}
          visible={this.state.visible}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          width={700}
          destroyOnClose={this.props.destroyOnClose}
        >
          <div className="PartmentSelect-title">
            <h2>选择：</h2>
            <h2>已选：</h2>
          </div>
          <div className="PartmentSelect-box">
            <GetUser
              visible={this.state.visible}
              value={this.state.checkedkeys || []}
              type={this.props.type || "checkbox"}
              data={this.state.userdata}
              defaultArrayObj={this.state.defaultArrayObj}
              onSelect={(checkedkeys, obj) => {
                const s= JSON.parse(JSON.stringify(obj))
                this.setState({ checkedkeys, arrayObj: JSON.parse(JSON.stringify(obj)) });
              }}
              huaweiMeeting={this.state.huaweiMeeting}
            />
            <div className="PartmentSelect-wrap PartmentSelect-wrap-selected" style={{ overflow: 'auto' }}>
              {selectedList()}
            </div>
          </div>
        </Modal>
      </div>
    );
  }
}

export default SelectPersonnelPop;
