package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxPlatformFee;
import com.zbkj.common.model.bcx.BcxPlatformFeeConfig;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.service.dao.bcx.BcxPlatformFeeDao;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 平台服务费 服务实现类
 */
@Service
public class BcxPlatformFeeServiceImpl extends ServiceImpl<BcxPlatformFeeDao, BcxPlatformFee> implements BcxPlatformFeeService {

    @Resource
    private BcxPlatformFeeDao dao;
    @Resource
    private BcxPlatformFeeConfigService bcxPlatformFeeConfigService;
    @Resource
    private OrderService orderService;
    @Resource
    private OrderDetailService orderDetailService;

    @Override
    public BcxPlatformFee queryById(Integer id) {
        BcxPlatformFee source = dao.selectById(id);
        BcxPlatformFee target = transform(source);
        return target;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BcxPlatformFee queryByOrderNo(String orderNo, Integer orderType) {
        LambdaQueryWrapper<BcxPlatformFee> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxPlatformFee::getOrderNo, orderNo);
        lqw.eq(BcxPlatformFee::getOrderType, orderType);
        lqw.orderByDesc(BcxPlatformFee::getId);
        lqw.last("limit 1");
        BcxPlatformFee fee = dao.selectOne(lqw);
        if (fee == null) {
            // 旧订单找不到服务费，生成一笔服务费
            Order order = orderService.getByOrderNo(orderNo);
            OrderDetail orderDetail = orderDetailService.getByOrderNo(orderNo).get(0);
            BcxPlatformFeeConfig platFeeConfig = bcxPlatformFeeConfigService.queryByAnyId(order.getMerId(), orderDetail.getProductId(), 0);
            if (platFeeConfig != null) {
                BigDecimal platformFee = bcxPlatformFeeConfigService.calcSellPlatformFee(platFeeConfig, order.getPayPrice(), orderDetail.getPayNum());
                fee = BcxPlatformFee.builder()
                        .orderType(orderType).orderNo(orderNo).platFee(platformFee)
                        .config(JSONObject.toJSONString(platFeeConfig))
                        .transPriority(platFeeConfig.getSellFeePriority())
                        .build();

            } else {
                throw new CrmebException("平台服务费配置不存在，请联系客服");
                
            }
            save(fee);
        }
        return fee;
    }

    @Override
    public PageInfo<BcxPlatformFee> queryPagedList(BcxPlatformFee request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper<BcxPlatformFee> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxPlatformFee::getId, request.getId());
        lqw.orderByDesc(BcxPlatformFee::getId);
        Page<BcxPlatformFee> page = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        List<BcxPlatformFee> sources = dao.selectList(lqw);
        if (CollUtil.isEmpty(sources)) {
            return CommonPage.copyPageInfo(page, CollUtil.newArrayList());
        }
        List<BcxPlatformFee> result = transform(sources);
        return CommonPage.copyPageInfo(page, result);
    }

    private List<BcxPlatformFee> transform(List<BcxPlatformFee> sources) {
        List<BcxPlatformFee> result = new ArrayList<>();
        for (BcxPlatformFee source : sources) {
            BcxPlatformFee target = transform(source);
            result.add(target);
        }
        return result;
    }

    private BcxPlatformFee transform(BcxPlatformFee source) {
        BcxPlatformFee target = new BcxPlatformFee();
        BeanUtils.copyProperties(source, target);
        // set another perperties
        return target;
    }
}
