package com.zbkj.service.payments.snapshots;

import com.zbkj.service.payments.commands.CreateTransferCommand;
import lombok.Data;

import java.io.Serializable;

@Data
public class PaymentTransferSnapshot implements Serializable {
    private CreateTransferCommand command;
    /**
     * 平台费用
     */
    private String platAmount;
    /**
     * 商家入账方
     */
    private String inAccountUniId;
    private String inWalletAccountNo;

    /**
     * 平台入账方
     */
    private String platAccountUniId;
    private String platWalletAccountNo;

    /**
     * 订单备注信息
     */
    private String comment;

    private String tradeType;

    /**
     * 是否需要锁定金额
     * 从原有代码重构过来: 只有huifuWalletAccountTransfer的时候才需要
     */
    private boolean needLockAmount;
    private String lockAmount;

    public static PaymentTransferSnapshot create(CreateTransferCommand command)
    {
        PaymentTransferSnapshot snapshot = new PaymentTransferSnapshot();
        snapshot.setCommand(command);

        return snapshot;
    }
}
