package com.zbkj.service.payments.commands;

import lombok.Getter;

import java.util.Collection;

@Getter
public class ReplenishOrderPlatformFeeCommand extends CommandAbstract {
    private final Collection<String> replenishTransactionIds;

    public ReplenishOrderPlatformFeeCommand(Collection<String> replenishTransactionIds) {
        this.replenishTransactionIds = replenishTransactionIds;
    }

    public static ReplenishOrderPlatformFeeCommand create(Collection<String> replenishTransactionIds) {
        return new ReplenishOrderPlatformFeeCommand(replenishTransactionIds);
    }
}
