package com.zbkj.service.payments.commands;

import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.user.User;
import lombok.Getter;

@Getter
public class CreatePaymentCommand extends CommandAbstract {
    private final Order order;
    private final User user;

    private final Merchant merchant;


    public CreatePaymentCommand(Order order, User user, Merchant merchant) {
        this.order = order;
        this.user = user;
        this.merchant = merchant;
    }

    public static CreatePaymentCommand create(Order order, User user, Merchant merchant) {
        return new CreatePaymentCommand(order, user, merchant);
    }
}
