package com.zbkj.service.payments;

import com.zbkj.service.payments.commands.CreateTransferCommand;
import com.zbkj.service.payments.commands.DonePaymentCommand;
import com.zbkj.service.payments.results.PaymentCommandResult;
import com.zbkj.service.payments.snapshots.PaymentTradeSnapshot;

import java.util.Collection;

public interface PaymentProvider {
    PaymentCommandResult offlinePayPlatTransfer(CreateTransferCommand command);

    PaymentCommandResult transfer(CreateTransferCommand command);

    String getChannelName();

    void done(DonePaymentCommand command);

    void done(DonePaymentCommand command, Collection<PaymentTradeSnapshot> paymentTradeSnapshots);

    void doForPlatformTransfer(PaymentTradeSnapshot platformSnapshot);
}
