<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
    <title>分配产品列表</title>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">
    <!-- <div class="row">
        <div class="col-sm-12">
           <div class="float-e-margins">
                <div class="ibox-title">
                    <h5>搜索查询</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link">
                            <i class="fa fa-chevron-up"></i>
                            </a>
                            <a class="close-link">
                    <i class="fa fa-times"></i>
                </a>
                    </div>
                </div>
                <div class="ibox-content search-query"> -->
    <!--  <form>
         <div class="col-sm-6">
             <div class="form-group" id="data_5">
                 <label class="control-label">添加时间</label>
                 <div class="input-daterange input-group" id="datepicker">
                     <input type="text" class="form-control" id="begincreate_time" name="begincreate_time" value="" />
                     <span class="input-group-addon">到</span>
                     <input type="text" class="form-control" id="endcreate_time" name="endcreate_time" value="" />
                 </div>
             </div>
         </div>
         <div class="col-sm-6">
             <div class="form-group">
                 <label class="control-label">供应商名称</label>
                 <div class="input-group">
                     <input type="text" class="form-control" name="searchContent">
                     <span class="input-group-btn"><button type="sumbit" class="btn btn-primary" >搜索</button> </span>
                 </div>
             </div>
         </div>
     </form> -->
    <!--                </div>
               </div>
           </div>
      </div> -->
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>分配产品列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                        <a class="close-link"><i class="fa fa-times"></i></a>
                    </div>
                </div>
                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <div id="toolbar" class="btn-group m-t-sm">
                                        <shiro:hasPermission name="syscompany:list:add:supplier">
                                            <button type="button" class="btn btn-default"  title="新增" onclick="var id ='${companyId}';member_show('','${ctx}/ins/product/list/openProductList?companyId=' + id+'&level=${level}&parentId=${parentId}','','','900','')">
                                                <i class="glyphicon glyphicon-plus">新增</i>
                                            </button>
                                        </shiro:hasPermission>
                                    </div>
                                    <table id="table"yong
                                           <%--data-show-refresh="true"--%>
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-search="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="stargazers_count"
                                    <%--data-url="${ctx}/syscompany/list?type=1"--%>
                                           data-query-params="queryParams"
                                           data-query-params-type="limit"
                                           data-sort-order="desc"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="true">ID</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">产品名称</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">产品类型</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">价格</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">总佣金</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">已分配佣金</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">供应商</th>
                                            <th data-halign="center" data-align="center">操作</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <c:forEach items="${list}" var="fee">
                                            <tr>
                                                <td>${fee.feeId}</td>
                                                <td>
                                                    <a href="javascript:void(0)" <%--onclick="var id ='${fee.feeId}'; member_show('查看供应商'+'【${company.companyName}】','${ctx}/syscompany/list/'+id+'/view/1','','','900',null)"--%>>${fee.productName}</a>
                                                </td>
                                                <td>${fns:getDictLabel(fee.productType, 'product_type', '')}</td>
                                                <td>无</td>
                                                <td><fmt:formatNumber value="${fee.totalBrokerage}" pattern="0.00"/>%</td>
                                                <td><fmt:formatNumber value="${fee.brokerage}" pattern="0.00"/>%</td>
                                                <td>${fee.compnayName}</td>
                                                <td class="td-manage">
                                                    <shiro:hasPermission name="syscompany:list:delete:supplier">
                                                        <a class="remove m-l-sm text-danger" href="javascript:void(0)" onclick="member_del(this,'${fee.feeId}')" title="删除">
                                                            <i class="glyphicon glyphicon-remove"></i>
                                                        </a>
                                                    </shiro:hasPermission>
                                                </td>
                                            </tr>
                                        </c:forEach>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        // 日期插件
        $(document).ready(function () {
            $('#data_5 .input-daterange').datepicker({
                keyboardNavigation: false,
                forceParse: false,
                autoclose: true,
                format: 'yyyy/MM/dd',
            });
            //拖动面板
            $(".sortable-list").sortable({
                connectWith: ".connectList"
            }).disableSelection();

            $('#table').bootstrapTable({
                refresh: function () {
                    alert();
                }
            });
        })
        /*供应商删除-删除*/
        function member_del(obj,id){
            layer.confirm('确认要删除吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}/ins/product/list/'+id+'/delete',
                    success:function(result){
                        if(result.success==true){
                            $(obj).parents("tr").remove();
                            layer.msg('已删除!',{icon:1,time:1000});
                        }else{
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
        /*供应商冻结-冻结*/
        function member_stop(obj,id){
            layer.confirm('确认要冻结吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    data:{'accountId':id,'status':0},
                    dataType:'json',
                    type:'post',
                    url:'${ctx}/syscompany/list/audit',
                    success:function(result){
                        if(result.success==true){
                            $(obj).parents("tr").find(".td-manage").prepend('<a class="like text-info" href="javascript:void(0)" onClick="member_start(this,'+id+')" title="启用"><i class="glyphicon glyphicon-play"></i></a>');
                            $(obj).parents("tr").find(".td-status").html('<span class="label label-danger">冻结</span>');
                            $(obj).remove();
                            layer.msg('已冻结!',{icon: 5,time:1000});
                        }else{
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
        /*供应商-启用*/
        function member_start(obj,id){
            layer.confirm('确认要启用吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    data:{'accountId':id,'status':1},
                    dataType:'json',
                    type:'post',
                    url:'${ctx}/syscompany/list/audit',
                    success:function(result){
                        if(result.success==true){
                            $(obj).parents("tr").find(".td-manage").prepend('<a class="like text-info" href="javascript:void(0)" onClick="member_stop(this,'+id+')" title="冻结"><i class="glyphicon glyphicon-pause"></i></a>');
                            $(obj).parents("tr").find(".td-status").html('<span class="label label-primary">正常</span>');
                            $(obj).remove();
                            layer.msg('已启用!',{icon: 6,time:1000});
                        }else{
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
    </script>
</bcxinFooter>
</body>
</html>
