<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title></title>
	<%@include file="/WEB-INF/include/head.jsp"%>
	<style>
		.bid-context table{
			width: 100%;

		}
		.bid-context table thead tr{
			background: #eee;
		}
		.bid-context table tr{
			line-height: 40px;
		}
		.bid-context table tr td{
			text-align: center;
			border: 1px solid #ddd;
		}
	</style>
</head>
<body>
<div class="container bid">
	<div class="content">
		<h3>基础信息</h3>
		<p class="clearfix"><span class="pull-right">订单状态：${fns:getDictLabel (orderVo.policy_status,"order_status","")}</span></p>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">订单号</li>
					<li class="no-bor">${orderVo.trade_serial_number}</li>
					<li class="no-bor">投保单号</li>
					<li class="no-bor">${orderVo.policy_serial_number}</li>
					<li class="no-bor">下单时间</li>
					<li class="no-bor">${orderVo.start_time}</li>
					<li class="no-bor">支付方式</li>
					<li class="no-bor">
						<c:set var="paymentMethods" value="${empty transactionList ? '' : transactionList[0].pay_type}"></c:set>
						${empty paymentMethods ? '-' : fns:getDictLabel (paymentMethods,"pay_type","")}
					</li>
					<li class="no-bor">最后支付时间</li>
					<li class="no-bor">
						<c:set var="endTimes" value="${empty transactionList ? '' : transactionList[transactionList.size()-1].end_time}"></c:set>
						<c:if test="${not empty endTimes }">
							<fmt:formatDate value="${endTimes}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>
						</c:if>
					</li>
					<li class="no-bor">支付流水号</li>
					<li class="no-bor">
						<c:forEach items="${transactionList}" var="list">
							${list.trade_serial_number}<br/>
						</c:forEach>
						<%--${empty transactionList ? '-' : transactionList.size()}
						${orderVo.pay_methods eq '2' ? '/4' : '/1'}
						<c:if test="${not empty transactionList}">
							<a href="javascript:void(0)" onclick="member_show('支付详情','${ctx}/ins/policy/initTransactionDetail/${orderVo.oid}','','','900',null)" title="支付详情">
								支付详情
							</a>
						</c:if>--%>
					</li>
					<li class="no-bor">下单帐号</li>
					<li class="no-bor">${orderVo.login_name}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">产品信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">产品名称</li>
					<li class="no-bor" title="${orderVo.product_name}">${orderVo.product_name}</li>
					<li class="no-bor">保费（元）</li>
					<li class="no-bor">${orderVo.gross_premium}</li>
					<li class="no-bor">保险期限</li>
					<li class="no-bor" id="days"></li>
					<li class="no-bor"></li>
					<li class="no-bor"></li>
					<%--<li class="no-bor">总保额</li>
					<li class="no-bor">${orderVo.insured_amount}</li>--%>
					<li class="no-bor">生效日期</li>
					<li class="wd80 no-bor">
						${orderVo.inception_date}
						至
						${orderVo.planned_end_date}
					</li>
					<li class="no-bor">受益人</li>
					<li class="wd80 no-bor">
						法定继承人
					</li>
				</ul>
				<%--<c:choose>
					<c:when test="${'TYX-RB-3' eq dto.product_code||'TYX-RB-4' eq dto.product_code||'TYX-RB-5' eq dto.product_code||'TYX-RB-6' eq dto.product_code}">
						<table class="table ">
							<tbody>
							<tr>
								<td class="col-sm-4 col-xs-4"></td>
								<td class="col-sm-4 col-xs-4">保障责任</td>
								<td class="col-sm-4 col-xs-4">保障金额</td>
							</tr>
							<tr>
								<td class="col-sm-4 col-xs-4" rowspan="5">固定保障</td>
								<td class="col-sm-4 col-xs-4">意外身故/残疾</td>
								<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 30 : dto.product_code eq 'TYX-RB-4' ? 40 : dto.product_code eq 'TYX-RB-5' ? 50 : dto.product_code eq 'TYX-RB-6' ? 60 : 0 } 万元</td>
							</tr>
							<tr>
								<td class="col-sm-4 col-xs-4">意外医疗</td>
								<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 3 : dto.product_code eq 'TYX-RB-4' ? 4 : dto.product_code eq 'TYX-RB-5' ? 5 : dto.product_code eq 'TYX-RB-6' ? 6 : 0 } 万元</td>
							</tr>
							<tr>
								<td class="col-sm-4 col-xs-4">意外住院津贴</td>
								<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 100 : dto.product_code eq 'TYX-RB-4' ? 100 : dto.product_code eq 'TYX-RB-5' ? 150 : dto.product_code eq 'TYX-RB-6' ? 200 : 0 } 元/天</td>
							</tr>
							<tr>
								<td class="col-sm-4 col-xs-4">猝死（身故）</td>
								<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 10 : dto.product_code eq 'TYX-RB-4' ? 20 : dto.product_code eq 'TYX-RB-5' ? 20 : dto.product_code eq 'TYX-RB-6' ? 20 : 0 } 万元</td>
							</tr>
							<tr>
								<td class="col-sm-4 col-xs-4">救护车费用</td>
								<td class="col-sm-4 col-xs-4">1000 元</td>
							</tr>
							<c:if test="${vo.is_contain_repo eq '1'||vo.is_contain_repo eq '3'}">
								<tr>
									<td class="col-sm-4 col-xs-4" rowspan="1">可选保障一</td>
									<td class="col-sm-4 col-xs-4">疾病身故/全残</td>
									<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 15 : dto.product_code eq 'TYX-RB-4' ? 20 : dto.product_code eq 'TYX-RB-5' ? 25 : dto.product_code eq 'TYX-RB-6' ? 30 : 0 } 万元</td>
								</tr>
							</c:if>
							<c:if test="${vo.is_contain_repo eq '2'||vo.is_contain_repo eq '3'}">
								<tr>
									<td class="col-sm-4 col-xs-4" rowspan="1">可选保障二</td>
									<td class="col-sm-4 col-xs-4">重大疾病</td>
									<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 15 : dto.product_code eq 'TYX-RB-4' ? 20 : dto.product_code eq 'TYX-RB-5' ? 25 : dto.product_code eq 'TYX-RB-6' ? 30 : 0 } 万元</td>
								</tr>
							</c:if>
							</tbody>
						</table>
					</c:when>
					<c:otherwise>
						<table class="table ">
							<tbody>
							<tr>
								<td class="col-sm-6 col-xs-6">保障责任</td>
								<td class="col-sm-6 col-xs-6">保障金额</td>
							</tr>
							<c:forEach items="${ dto.responsibilityVoList }" var="irp">
								<tr>
									<td class="col-sm-6 col-xs-6" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>${irp.name}</td>
									<td class="col-sm-6 col-xs-6" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>${irp.fcy}${empty irp.compensation_days ? '元' : '元/天'}</td>
								</tr>
							</c:forEach>
							</tbody>
						</table>
					</c:otherwise>
				</c:choose>--%>
				<table class="table ">
					<tbody>
					<tr>
						<td class="col-sm-4 col-xs-4">保障责任</td>
						<td class="col-sm-2 col-xs-2">
							<c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
							<c:choose>
								<c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
									保险金额
								</c:when>
								<c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
									赔偿限额
								</c:when>
								<c:otherwise>
									保险金额
								</c:otherwise>
							</c:choose>
						</td>
						<td class="col-sm-2 col-xs-2">免赔额</td>
						<td class="col-sm-2 col-xs-2">赔付比例</td>
						<td class="col-sm-2 col-xs-2">免赔天数</td>
					</tr>
					<c:forEach items="${ vo.responsibilityVoList }" var="irp">
						<tr <c:choose>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
								hidden
							</c:when>
							<c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:otherwise>

							</c:otherwise>
						</c:choose>>
							<td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
							<td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
								<c:choose>
									<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:otherwise>
										<span>-</span>
									</c:otherwise>
								</c:choose>
							</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
						</tr>
					</c:forEach>
					</tbody>
				</table>
			</div>
		</div>
	</div>

	<div class="content">
		<h3 class="mb20">投保人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">投保单位</li>
					<li class="no-bor" title="${vo.roleSubjectList[0].name_cn}">${vo.roleSubjectList[0].name_cn}</li>
					<li class="no-bor">所属行业</li>
					<li class="no-bor">${vo.roleSubjectList[0].industry}</li>
					<li class="no-bor">营业性质</li>
					<li class="no-bor">
						<c:forEach items="${natureList }" var="list">
							<c:if test="${list.value eq vo.roleSubjectList[0].com_nature}">
								${list.name}
							</c:if>
						</c:forEach>
						<c:forEach items="${natureList }" var="list">
							<c:if test="${list.value eq vo.roleSubjectList[0].nature_two}">
								${list.name}
							</c:if>
						</c:forEach>
					</li>
					<li class="no-bor">证件类型</li>
					<li class="no-bor">
						<c:forEach items="${typeList }" var="list">
							<c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
								${list.name}
							</c:if>
						</c:forEach>
					</li>
					<li class="no-bor">证件号码</li>
					<li class="no-bor">${vo.roleSubjectList[0].organization_code}</li>
					<li class="no-bor">企业总人数</li>
					<li class="no-bor">${vo.roleSubjectList[0].total_emp}</li>
					<li class="no-bor">注册地址</li>
					<li class="wd80 no-bor" title="${reg_role}${vo.roleSubjectList[0].reg_address}">
						${reg_role}${vo.roleSubjectList[0].reg_address}
					</li>
					<li class="no-bor">办公地址</li>
					<li class="wd80 no-bor" title="${vo.roleSubjectList[0].do_business_address}">
					${vo.roleSubjectList[0].do_business_address}
					</li>
					<li class="no-bor">办公电话</li>
					<li class="no-bor">${vo.roleSubjectList[0].phone}</li>
					<li class="no-bor">联系人姓名</li>
					<li class="no-bor">${vo.roleSubjectList[0].link_name}</li>
					<li class="no-bor">联系人手机</li>
					<li class="no-bor">${vo.roleSubjectList[0].link_tel}</li>
					<li class="no-bor">联系人邮箱</li>
					<li class="no-bor">${vo.roleSubjectList[0].link_email}</li>
					<li class="no-bor">邮政编码</li>
					<li class="no-bor">${vo.roleSubjectList[0].zip_code}</li>
				</ul>
			</div>
			<div class="img-show col-xs-12">
				<ul>
					<c:if test="${ not empty vo.roleSubjectList[0].app_organizing_path}">
						<li>
							<img src="${ vo.roleSubjectList[0].app_organizing_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">附件</span>
								<a target="_blank" href="${ vo.roleSubjectList[0].app_organizing_path}">下载</a>
							</p>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">被投保人信息(<a href="${ctx}/ins/policy/downLoadPath/${orderVo.trade_serial_number}">导出</a>)</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<table>
					<thead>
						<tr>
							<td class="col-sm-1 col-xs-1">序号</td>
							<td class="col-sm-2 col-xs-2">姓名</td>
							<td class="col-sm-1 col-xs-1">证件类型</td>
							<td class="col-sm-2 col-xs-2">证件号码</td>
							<td class="col-sm-2 col-xs-2">出生日期</td>
							<td class="col-sm-1 col-xs-1">性别</td>
							<td class="col-sm-2 col-xs-2">职业</td>
							<td class="col-sm-1 col-xs-1">手机号码</td>
						</tr>
					</thead>
					<tbody>
					<c:if test="${not empty vo.roleSubjectList}">
						<c:forEach begin="2" end="${ vo.roleSubjectList.size() }" varStatus="index">
							<c:set var="doIndex" value="${index.index-1}"/>
							<tr>
								<td class="col-sm-1 col-xs-1">${doIndex}</td>
								<td class="col-sm-2 col-xs-2">${vo.roleSubjectList[doIndex].name_cn}</td>
								<td class="col-sm-1 col-xs-1">
									<c:forEach items="${typeList }" var="list">
										<c:if test="${list.value eq vo.roleSubjectList[doIndex].id_type}">
											${list.name}
										</c:if>
									</c:forEach>
								</td>
								<td class="col-sm-2 col-xs-2">${vo.roleSubjectList[doIndex].organization_code}</td>
								<td class="col-sm-2 col-xs-2">${vo.roleSubjectList[doIndex].birth_date}</td>
								<td class="col-sm-1 col-xs-1">${empty vo.roleSubjectList[doIndex].sex ? '':vo.roleSubjectList[doIndex].sex eq '1'?'男':'女'}</td>
								<td class="col-sm-2 col-xs-2">
										${ vo.roleSubjectList[doIndex].major_group eq '1' ? '内勤人员' : vo.roleSubjectList[doIndex].major_group eq '2' ? '保安人员' : '武装押运人员'}
								</td>
								<%--<td class="col-sm-2 col-xs-2">${vo.roleSubjectList[doIndex].major_group}</td>--%>
								<td class="col-sm-1 col-xs-1">${vo.roleSubjectList[doIndex].mobile}</td>
							</tr>
						</c:forEach>
					</c:if>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	<c:if test="${fn:contains(orderVo.product_code, 'TYX-QH')}">
		<div class="content">
			<h3 class="mb20">活动基本信息</h3>
			<div class="row bid-context">
				<div class="col-sm-12">
					<ul class="bid-ul">
						<li class="no-bor">活动名称</li>
						<li class="no-bor">${vo.specialExhibitionVo.name}</li>
						<li class="no-bor">活动时间</li>
						<li class="no-bor">${vo.specialExhibitionVo.star_time} ~ ${vo.specialExhibitionVo.end_time}</li>
						<li class="no-bor">活动举办地址</li>
						<li class="no-bor">${ex_pca}${vo.specialExhibitionVo.ex_address}</li>
					</ul>
				</div>
			</div>
		</div>
	</c:if>
	<c:if test="${ not empty orderVo.external_reference && not empty orderVo.insure_path}">
		<div class="content">
			<h3 class="mb20">保单信息</h3>
			<div class="row bid-context">
				<div class="col-sm-12">
					<ul class="bid-ul">
						<li> 电子保单</li>
						<li class="wd80">
							<a target="_blank" href="${orderVo.insure_path}">查看</a>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</c:if>
	<c:if test="${ not empty orderVo.external_reference && not empty vo.mailPolicyVo.e_invoice_url}">
		<div class="content">
			<h3 class="mb20">发票信息</h3>
			<div class="row bid-context">
				<div class="col-sm-12">
					<ul class="bid-ul">
						<li> 电子发票</li>
						<li class="wd80">
							<a target="_blank" href="${orderVo.insure_path}">查看</a>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</c:if>
	<%--<div class="content">
		<h3 class="mb20">受益人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li>受益人</li>
					<li class="wd80 no-bor">
						法定继承人
					</li>
				</ul>
			</div>
		</div>
	</div>--%>
	<%--<div class="content">
		<h3 class="mb20">投保计划信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<table>
					<thead>
					<tr>
						<td class="col-sm-6 col-xs-6">保障责任</td>
						<td class="col-sm-6 col-xs-6">保险金额</td>
					</tr>
					</thead>
					<tbody>
					<c:if test="${not empty irpVoList}">
						<c:forEach items="${ irpVoList }" var="irp">
							<tr>
								<td class="col-sm-6 col-xs-6">${irp.name}</td>
								<td class="col-sm-6 col-xs-6">${irp.fcy}</td>
							</tr>
						</c:forEach>
					</c:if>
					</tbody>
				</table>
			</div>
		</div>
	</div>--%>
	<c:if test="${fn:contains(dto.product_code, 'TYX-QH')}">
	<div class="content">
		<h3 class="mb20">投保基本信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">活动名称</li>
					<li class="wd80 no-bor">${vo.specialExhibitionVo.name}</li>
					<li class="no-bor">活动时间</li>
					<li class="no-bor">${vo.specialExhibitionVo.star_time} ~ ${vo.specialExhibitionVo.end_time}</li>
					<li class="no-bor">银行账号</li>
					<li class="no-bor">${ex_pca}${vo.specialExhibitionVo.ex_address}</li>
				</ul>
			</div>
		</div>
	</div>
	</c:if>

	<div class="content">
		<h3 class="mb20">退保账户信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">开户名</li>
					<li class="wd80 no-bor">${vo.roleSubjectList[0].account_name}</li>
					<li class="no-bor">账户开户行</li>
					<li class="no-bor">${vo.roleSubjectList[0].bank_name}</li>
					<li class="no-bor">银行账号</li>
					<li class="no-bor">${vo.roleSubjectList[0].bank_account}</li>
				</ul>
			</div>
		</div>
	</div>
	<!-- 票单信息 start -->
	<div class="ibox-title">
		<h5>
			单证信息
		</h5>
	</div>
	<div class="ibox-content">

		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<label class="col-sm-2 control-label">是否需要纸质保单：</label>
			<div class="col-sm-10">
				${vo.mailPolicyVo.need_insur_bill eq '0' ? '否' : '是'}
			</div>
		</div>

		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<label class="col-sm-2 control-label">收件人：</label>
			<div class="col-sm-4">
				${ vo.mailPolicyVo.receiver_name}
			</div>
			<label class="col-sm-2 control-label">收件人手机：</label>
			<div class="col-sm-4">
				${ vo.mailPolicyVo.receiver_mobile}
			</div>
		</div>
		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<label class="col-sm-2 control-label">收件地址：</label>
			<div class="col-sm-10">
				${ vo.mailPolicyVo.receiver_address_detail}
			</div>
		</div>

		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<label class="col-sm-2 control-label">是否需要纸质发票：</label>
			<div class="col-sm-4">
				${vo.mailPolicyVo.need_receipt eq '0' ? '否' : '是'}
			</div>
			<label class="col-sm-2 control-label">发票种类：</label>
			<div class="col-sm-4">
				${vo.mailPolicyVo.need_receipt eq '0' ? '' : vo.mailPolicyVo.invoice_type eq '0' ? '增值税普通发票' : '增值税专用发票'}
			</div>

		</div>
		<c:if test="${vo.mailPolicyVo.invoice_type eq '0'}">
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">收件单位：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.receipt_head}
				</div>
				<label class="col-sm-2 control-label">收件人：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.taker_name}
				</div>
			</div>
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">收件人手机：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.taker_mobile}
				</div>
				<label class="col-sm-2 control-label">收件地址：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.taker_address_detail}
				</div>

			</div>
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">纳税人识别号：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.taxpayer_number_invoice}
				</div>
				<label class="col-sm-2 control-label">&nbsp;</label>
				<div class="col-sm-4">
					&nbsp;
				</div>

			</div>
		</c:if>
		<c:if test="${vo.mailPolicyVo.invoice_type eq '1'}">
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">纳税人识别号：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.taxpayer_number_invoice}
				</div>
				<label class="col-sm-2 control-label">注册地址：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.register_address_invoice}
				</div>

			</div>
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">开户银行：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.bank_invoice}
				</div>
				<label class="col-sm-2 control-label">电话：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.receipt_phone}
				</div>

			</div>
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">银行账号：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.bank_account_invoice}
				</div>
			</div>

			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">税务登记证：</label>
				<div class="col-sm-2 col-xs-2">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.tax_cert}">
						<img alt="税务登记证" src="${ vo.mailPolicyVo.tax_cert}" style="width: 100%;height: 100%">
						<p>
							<a target="_blank" href="${  vo.mailPolicyVo.tax_cert}">下载</a>
						</p>
					</c:if>
				</div>
				<label class="col-sm-2 control-label">一般纳税人证明：</label>
				<div class="col-sm-2 col-xs-2">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.tax_prove}">
						<img alt="一般纳税人证明" src="${ vo.mailPolicyVo.tax_prove}" style="width: 100%;height: 100%">
						<p>
							<a target="_blank" href="${  vo.mailPolicyVo.tax_prove}">下载</a>
						</p>
					</c:if>
				</div>
				<label class="col-sm-2 control-label">银行开户许可证：</label>
				<div class="col-sm-2 col-xs-2">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.bank_licence}">
						<img alt="银行开户许可证" src="${ vo.mailPolicyVo.bank_licence}" style="width: 100%;height: 100%">
						<p>
							<a target="_blank" href="${  vo.mailPolicyVo.bank_licence}">下载</a>
						</p>
					</c:if>
				</div>
				<label class="col-sm-2 control-label">营业执照副本：</label>
				<div class="col-sm-2 col-xs-2">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.business_license}">
						<img alt="营业执照副本" src="${ vo.mailPolicyVo.business_license}" style="width: 100%;height: 100%">
						<p>
							<a target="_blank" href="${  vo.mailPolicyVo.business_license}">下载</a>
						</p>
					</c:if>
				</div>
				<label class="col-sm-2 control-label">增票授权委托书：</label>
				<div class="col-sm-2 col-xs-2">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.auth_cert}">
						<img alt="增票授权委托书" src="${ vo.mailPolicyVo.auth_cert}" style="width: 100%;height: 100%">
						<p>
							<a target="_blank" href="${  vo.mailPolicyVo.auth_cert}">下载</a>
						</p>
					</c:if>
				</div>
			</div>
		</c:if>
		<c:if test="${ not empty orderVo.remarks}">
			<div class="ibox-title">
				<h5>
					其它
				</h5>
			</div>
			<div class="ibox-content">
				<div class="hr-line-dashed"></div>
				<div class="form-group">
					<label class="col-sm-2 control-label">备注:</label>
					<div class="col-sm-10">
							${ orderVo.remarks}
					</div>
				</div>
			</div>
		</c:if>
	</div>
	</div>
</div>
<bcxinFooter>
<script type="text/javascript" src="${ctxsta}/admin/product/js/jquery-1.11.3.js"></script>
	<script>
        $(function(){
            function lineHeight(name){
                var height=parseFloat($("."+name+">li:nth-child(2)").css("height"));
                $("."+name+">li:first-child").css("line-height",height+"px").css("padding","0");
            }
            lineHeight("big");
            lineHeight("img-look");
            lineHeight("addr");
            lineHeight("day");
            btnCount_Click();
            downServer('${orderVo.oid}');
        })
        function  btnCount_Click(){//d1失效日期，d2生效日期
            var d1 = '${orderVo.planned_end_date}';
            var d2 = '${orderVo.inception_date}';
            var days = '';
            if(d1 != '' && d2 != ''){
                days = DateDiff(d1,d2)+'天';
            }
            $("#days").html(days);
        }

        //计算天数差的函数，通用
        function  DateDiff(sDate1,  sDate2){    //sDate1和sDate2是2006-12-18格式
            var  aDate,  oDate1,  oDate2,  iDays
            aDate  =  sDate1.split("-")
            oDate1  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])    //转换为12-18-2006格式
            aDate  =  sDate2.split("-")
            oDate2  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])
            iDays  =  parseInt(Math.abs(oDate1  -  oDate2)  /  1000  /  60  /  60  /24) + 1    //把相差的毫秒数转换为天数
            return  iDays
        }
        function downServer(orderId){
            $.ajax({
                type:'POST',
                dataType:'json',
                url:'${ctx}/ins/policy/exportPersonXsl/'+orderId,
                success:function(result){
                }
            })
        }
	</script>
</bcxinFooter>
</body>
</html>
