package com.bcxin.ins.models.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.MySysRoleService;
import com.bcxin.ins.core.util.CTLUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
* 类名称：SysUserController   
* 类描述：系统管理员控制器   
* 创建人:liujinju
* @version
 */
@Controller
@RequestMapping("${systemPath}/mysysrole")
public class MySysRoleController extends BaseController {

	/** 角色管理页面 */
	private static final String SYSTEM_ROLE_LIST = getViewPath("admin/system/system_role_list");
	/** 某个角色分配给了多少用户的页面 */
	private static final String SYSTEM_ROLE_USER_LIST = getViewPath("admin/system/system_role_user_list");

	@Autowired
	private MySysRoleService mySysRoleService;

	/**角色列表 页面*/
	@RequiresPermissions("mysysrole:win:list")
	@RequestMapping(value = "/win/list")
	public String winList(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return SYSTEM_ROLE_LIST;
	}

	/**角色分配详情 页面*/
	@RequiresPermissions("mysysrole:win:list")
	@RequestMapping(value = "/win/detail")
	public String winDetail(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("role_id", String.valueOf(params.get("role_id")));
		return SYSTEM_ROLE_USER_LIST;
	}

	/**列表分页*/
	@RequiresPermissions("mysysrole:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(mySysRoleService.query(params),resp); return null;
	}

	/**详情分页*/
	@RequiresPermissions("mysysrole:win:list")
	@RequestMapping(value = "/queryDetail" , method = RequestMethod.POST)
	public @ResponseBody Object queryDetail(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(mySysRoleService.queryDetail(params),resp); return null;
	}

	/**权限列表*/
	@RequiresPermissions("mysysrole:win:list")
	@RequestMapping(value = "/rights" , method = RequestMethod.POST)
	public @ResponseBody Object rights(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		return mySysRoleService.rights(params);
	}

	/**新增*/
	@RequiresPermissions("mysysrole:add")
	@RequestMapping(value = "/add" , method = RequestMethod.POST)
	public @ResponseBody R add(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		//TODO ctj 必要参数规则校验
		if(!CTLUtil.pNotNull(params,"role_name","right_ids")) return new R(false, CTLUtil.LACK_P_MSG);
		Map<Object,Object> p = CTLUtil.init(req,params);
		return mySysRoleService.add(params);
	}

	/**修改*/
	@RequiresPermissions("mysysrole:upd")
	@RequestMapping(value = "/upd", method = RequestMethod.POST)
	public @ResponseBody R upd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		//TODO ctj 必要参数规则校验
		if(!CTLUtil.pNotNull(params,"id","role_name","old_role_name","right_ids")) return new R(false, CTLUtil.LACK_P_MSG);
		Map<Object,Object> p = CTLUtil.init(req,params);
		return mySysRoleService.upd(params);
	}

	/**删除*/
	@RequiresPermissions("mysysrole:del")
	@RequestMapping(value = "/del", method = RequestMethod.POST)
	public @ResponseBody R del(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		//TODO ctj 必要参数规则校验
		if(!CTLUtil.pNotNull(params,"id")) return new R(false, CTLUtil.LACK_P_MSG);
		Map<Object,Object> p = CTLUtil.init(req,params);
		return mySysRoleService.del(params);
	}


}