package com.bcxin.ins.models.pro.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.entity.product_core.*;
import com.bcxin.ins.models.pro.dao.ProDangerLevelMapper;
import com.bcxin.ins.models.pro.service.ProDangerLevelService;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.util.List;
import java.util.Map;

/**
* 类名称：SysUserServiceImpl   
* 类描述：SysUser 表业务逻辑层接口实现类   
* 创建人：liujinju
* @version
 */
@Service
public class ProDangerLevelServiceImpl extends ServiceImpl<ProDangerLevelMapper, ProDangerLevel> implements ProDangerLevelService {

    private static Logger log = LoggerFactory.getLogger(ProDangerLevelServiceImpl.class);

    @Autowired
    private ProDangerLevelMapper proDangerLevelMapper;

    @Override
    public R add(Map<Object, Object> p) {
        log.info("获得的参数是>>>>>>>>>>>>>>>>>"+ JSON.toJSONString(p));
        try{
            if(p.get("pro_primary_id")==null) return new R(false, "产品ID没有设置");
            Long pro_primary_id = Long.valueOf(String.valueOf(p.get("pro_primary_id")));
            ProDangerLevel row =  (ProDangerLevel) DOM.mtd(p,new ProDangerLevel());
            //TODO 下个版本改造
            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("信用险，事务发现异常，回滚数据",e); TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }

    @Override
    public R upd(Map<Object, Object> p) {
        //TODO 下个版本改造
        return null;
    }

    @Override
    public R del(Map<Object, Object> p) {
        //TODO 下个版本改造
        return null;
    }

    @Override
    public void batchInsert(@Param("list") List<ProDangerLevel> list){
        proDangerLevelMapper.batchInsert(list);
    }

}