package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.StPastBadDetail;
import com.bcxin.ins.models.order.policy.dao.InsPastBadDetailDao;
import com.bcxin.ins.models.order.policy.service.InsPastBadDetailService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.PastBadDetailVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional
public class InsPastBadDetailServiceImpl extends ServiceImpl<InsPastBadDetailDao, StPastBadDetail> implements InsPastBadDetailService {

	@Autowired
	private InsPastBadDetailDao dao;
	/**
	 * <b>通过账龄及坏账分析id查询所有过去三年中三笔最大的呆坏账详情 </b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	public List<StPastBadDetail> selectInsPastBadDetailByInsBadDebt(Long oid){
		return dao.selectInsPastBadDetailByInsBadDebt(oid);
	}
	
	/**
	 * <b>根据Vo及账龄及坏账分析表ID更新InsPastBadDetail数据 </b> 
	 * 
	 * @param vo
	 * @param bad_debt_id 账龄及坏账分析表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToThePastBadDetailVoSetUpInsPastBadDetail(PastBadDetailVo vo, Long bad_debt_id){
		StPastBadDetail insPastBadDetail = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insPastBadDetail = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insPastBadDetail = new StPastBadDetail();
			insPastBadDetail.getBad_debt().setSt_bad_debt_id(bad_debt_id);
			dao.insert(insPastBadDetail);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insPastBadDetail);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insPastBadDetail);
	}
	
	/**
	 * <b>接收页面传回的过去三年中三笔最大的呆坏账详情信息列表进行更新 </b> 
	 * 
	 * @param voList 过去三年中三笔最大的呆坏账详情信息列表
	 * @param bad_debt_id 账龄及坏账分析表id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void setPastBadDetailByPastBadDetailVo(List<PastBadDetailVo> voList, Long bad_debt_id){
		if(voList != null && voList.size()> ConstProp.INT_NUMBER_ZERO){
			for(PastBadDetailVo vo : voList){
				accordingToThePastBadDetailVoSetUpInsPastBadDetail(vo,bad_debt_id);
			}
		}
	}
	
	/**
	 * <b>将过去三年中三笔最大的呆坏账详情列表插入到PastBadDetailVo集合 </b> 
	 * 
	 * @param ipbdList 过去三年中三笔最大的呆坏账详情列表
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public List<PastBadDetailVo> getPastBadDetailVoListByInsPastBadDetailList(List<StPastBadDetail> ipbdList){
		List<PastBadDetailVo> voList = new ArrayList<PastBadDetailVo>();
		if(ipbdList != null && ipbdList.size()>ConstProp.INT_NUMBER_ZERO){
			for(StPastBadDetail ipbd : ipbdList){
				voList.add(accordingToInsPastBadDetailIntoPastBadDetailVo(ipbd));
			}
		}
		return voList;
	}
	
	/**
	 * <b>根据过去三年中三笔最大的呆坏账详情表信息转换成 PastBadDetailVo</b> 
	 * 
	 * @param iad 过去三年中三笔最大的呆坏账详情表
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	public PastBadDetailVo accordingToInsPastBadDetailIntoPastBadDetailVo(StPastBadDetail iad){
		PastBadDetailVo vo = new PastBadDetailVo();
		if(iad == null){
			return vo;
		}
		vo.setOid(String.valueOf(iad.getSt_past_bad_detail_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(iad), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vo;
	}
}
