package com.bcxin.ins.models.order.policy.dao;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsShipDeclare;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ShipDeclareHtIndexVo;
import com.bcxin.ins.vo.ShipDeclareMultipleVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 信用险-出运接口
 * @author liumd
 * @date 2016年12月30日
 */
@MyBatisDao
public interface ShipDeclareDao extends BaseMapper<InsShipDeclare> {
	
	public List<InsShipDeclare> getShipDeclareById(@Param("id") Long id);
	
	public List<InsShipDeclare> getShipDeclareByInsOrderFormId(@Param("insOrderFormId") Long insOrderFormId);
	
	public List<ShipDeclareMultipleVo> getShipDeclareVoByInsOrderFormId(@Param("insOrderFormId") Long insOrderFormId);
	
	public List<ShipDeclareMultipleVo> getShipDeclareVoByInsOrderFormIdAndVo(@Param("insOrderFormId") Long insOrderFormId,
                                                                             @Param("insured") String insured,
                                                                             @Param("country") String country,
                                                                             @Param("buyerName") String buyerName,
                                                                             @Param("startDate") String startDate,
                                                                             @Param("endDate") String endDate,
                                                                             @Param("declareType") String declareType);
	
	public List<ShipDeclareHtIndexVo> getAllShipDeclare(InsInsuranceSlip insOrderForm);
	
	/**
	 * 获取出运首页数据；
	 * @param userId 用户ID
	 * @return List<OrderFormVo>
	 */
	public List<OrderFormVo> getCanShipDeclareList(@Param("userId") Long userId);
	
	
	/**
	 * 根据订单ID获取OrderFormVo；
	 * @return
	 */
	public List<OrderFormVo> getOrderFormVoByOrderFormId(@Param("orderFormId") Long orderFormId);
	
	/**
	 * 根据订单ID获取该订单下所有被保险人列表；
	 * @return
	 */
	public List<String> getInsureNameList(@Param("orderFormId") Long orderFormId);
	
	

	
}
