package com.bcxin.ins.models.apply.service;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.service.IService;
import org.springframework.web.multipart.MultipartFile;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;


public interface PreseverApplyService extends IService<InsPreservationRecord> {
	/*分页 保全申请*/
	PageResult query(Map<Object, Object> p);
	/*分页 保全详情*/
	PageResult queryDetail(Map<Object, Object> p);
	/*分页 保全详情 原保险人*/
	PageResult queryOldPerson(Map<Object, Object> p);
	/*分页 保全缴费*/
	PageResult queryPay(Map<Object, Object> p);
	/*分页 保全汇总账单*/
	PageResult queryBillPay(Map<Object, Object> p);
	/*分页 保全汇总子账单*/
	PageResult queryChildBillPay(Map<Object, Object> p);
	/*分页 保全结算单*/
	PageResult querySettlementPay(Map<Object, Object> p);
	/*分页 保全结算子账单*/
	PageResult queryChildSettlementPay(Map<Object, Object> p);
	void downBillPay(String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response);
	void downChildBillPay(Long parentPayId, String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response);
	void downChildSettlementBillPay(Long parentPayId, String start_time, String end_time, String keyword, HttpServletResponse response);
	JSONObject createPartBill(String isSummaryBill, String[] payIds);
	JSONObject createPartBillByNo(String isSummaryBill, String[] payNos);
	/** 分页 缴费详情*/
	PageResult queryPayDetail(Map<Object, Object> p);
	/** 查询  根据id查询RecordVo*/
	InsPreservationRecordVo accordingToApplyIDToGetpreservationRecordVo(Long order_id);
	/*查询  根据id查询DetailVo*/
	InsPreservationDetailVo accordingToDetailIDToGetpreservationDetailVo(Long detail_id);
	/*查询  根据id查询PayVo*/
	InsPreservationPayVo accordingToPayIDToGetpreservationPayVo(Long pay_id);
    /*查询  根据id查询是否有审核不通过人员*/
	boolean accordingToApplyIDToGetStatus(Long detail_id);
	/*查询  根据record id查询结果集的人员*/
	List<InsPreservationResultSet> findResultSetVoByRecordID(Long record_id);
	/*更新   根据DetailVo更新保全详情 审核不通过状态以及理由 逻辑方法，controller层交互*/
	R statusUpd(Map<Object, Object> p,HttpServletRequest request);
	/*更新   根据DetailVo更新保全详情 审核不通过状态以及理由 dao层交互*/
	int updatedetailFormStatus(InsPreservationDetailVo vo);
	/*导出时间区间中华雇主[待审核]状态的保全人员列表*/
	void downRecordResultSet(String keyword, String name, String start_time, String end_time, HttpServletResponse response);
	/*导出指定投保人和已选时间区间【待审核、审批通过】状态的保全申请单明细(仅支持筛选增员、减员类型的保全单)*/
	void downRecordDetail(String keyword, String name, String start_time, String end_time, HttpServletResponse response);
	/*导出在保人员数据及保全金额*/
	void downSuccessResultSet(String keyword, String name, String start_time, String end_time,String type,String isGQ, HttpServletResponse response);
	R saveTime(Long record_id);
	/*获取电子批单*/
	R getDZPD(Long record_id);

	/**
	 * <b> 退保生成批改记录 </b>
	 * @author ZXF
	 * @create 2023/09/04 0004 11:20
	 * @version
	 * @注意事项 </b>
	 */
	R saveSurrenderRecord(SurrenderVo surrenderVo, OrderFormVo vo, HttpServletRequest request);

	int updateReleaseTime(InsPreservationRecordVo vo);
	/*更新   更新保全详情 审核状态*/
	R updataReviseStatus(Map<Object, Object> p,HttpServletRequest request);
	/*更新   长安批单通过修改批单状态*/
	Result updataCAReviseStatus(String recordId, String recordStatus, String remark, String reviseSerialNumIns, String revisePath, HttpServletRequest request);
	/*根据订单编号获取审核通过以日期升序的保全申请单*/
	List<InsPreservationRecordVo> listInsPreservationRecordVoByTranNo(String tran_no);
	/*更新  根据record_id更新保全缴费 支付状态(TODO 替代上个方法(saveResultSetByRecord)主要修改了结果集生成机制*/
	R pushResultSetByRecord(Long record_id,String revise_type);//更新支付状态
	/*更新   根据record_id更新保全缴费 支付状态*/
	R updataPayStatus(Map<Object, Object> p);
	/*更新   缴费记录状态变更为已支付，结束缴费流程*/
	R overPay(Map<Object, Object> p);
	/*上传功能  controller层交互*/
	R doUploadFile(String path,String upload_id,String upload_Type);
	/*上传功能  dao层交互 生成路径*/
	 String uploadFile(MultipartFile roleFile, String savePath);
    /*保存路径*/
	boolean savePath(Long oid, String path,String upload_Type);
	/*查找3天内待审核保全单*/
	public R findCheckPendingPreservationRecord();

	/*分页 在保人员列表*/
	PageResult queryResultSet(Map<Object, Object> p);
	/*导出在保人员*/
	void downResultSet(Map<Object, Object> p, HttpServletResponse response);
	/*退保操作时删除保全相关数据包括在保人员*/
	void deletePresever(Long orderID);
//	String getEffectiveByPolicyId(Long policyId);
//	 OrderFormVo accordingToOrderIDToGetPolicyDto(Long order_id);
//	ProductVo getProduct(long productID);
	/*设置批单结算状态*/
	R setPdNo(Map<Object, Object> p,HttpServletRequest request);
}
