<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
    <title>分配产品列表</title>
    <link href="${ctxsta}/admin/product/css/common.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/establish.css" rel="stylesheet">
    <link rel="stylesheet" href="${ctxsta}/admin/product/css/style.min.css"/>
    <!--[if lt IE 9]>
    <script src="${ctxsta}/admin/product/js/html5shiv.min.js"></script>
    <script src="${ctxsta}/admin/product/js/respond.min.js"></script>
    <![endif]-->
</head>

<body class="gray-bg">
<div class="container content ">
    <div class="nav-head">
        <div class="step step2">
            <ul>
                <li>
                    <strong>选择一级分销商</strong>
                </li>
                <li class="current">
                    <strong>选择需分配的产品</strong>
                </li>
                <li>
                    <strong>设置利润</strong>
                </li>
                <li>
                    <strong>完成</strong>
                </li>
            </ul>
        </div>
    </div>
    <div class="create">
        <form id="Form1" class="form-horizontal" action="${ctx}/ins/product/list/openProductSetFeeOne" method="POST">
            <input class="hidden" name="companyId" value="${companyId}">
            <div class="row search">
                <div class="col-xs-1 keyword">
                    <span>关键字</span>
                </div>
                <div class="col-xs-3">
                    <input type="text" name="keyword" id="keyword" value="${keyword}" class="form-control" placeholder="产品名称/供应商名称/产品id"/>
                </div>
                <div class="col-xs-2">
                    <button type="button"  onclick="searchKeyword()" class="btn btn-search">搜索</button>
                </div>
            </div>
            <table class="table table-bordered"  id="contentTable2">
                <thead>
                <tr>
                    <td class="check"><input type="checkbox"  id="chk_all" /></td>
                    <td>ID</td>
                    <td>产品名称</td>
                    <td>产品类型</td>
                    <td>价格</td>
                    <td>供应商</td>
                </thead>
                <tbody>
                <c:forEach items="${plst}" var="product">
                    <tr>
                        <td>
                            <input type="checkbox" name="productName" value="${product.id}" id="${product.id}"/>
                        </td>
                        <td>${product.id}</td>
                        <td>${product.insuranceName}</td>
                        <td><a href="#" title="${fns:getDictLabel(product.productType,"product_type","")}">${fns:abbr(fns:getDictLabel (product.productType,"product_type",""),20)} </a></td>
                        <td>无</td>
                        <td>${product.supplier.companyName}</td>
                    </tr>
                </c:forEach>
                </tbody>
            </table>
            <div class="row choice">
                <div class="col-xs-6">
                    <p>已选择 <span id="checkNum">0</span> 件产品</p>
                </div>
            </div>
            <input  name="productIds" class="hidden" id="productIds" />
            <div class="row">
                <div class="row finish">
                    <div class="col-sm-9 col-sm-offset-2">
                        <a class="btn btn-long btn-lightgreen" onclick="tijiaoForm()">下一步</a>
                        <a onclick="hideWidow()" class="btn btn-long btn-lightgreen">取消分配</a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<bcxinFooter>
    <link rel="stylesheet" href="${ctxsta}/common/icheck/flat/green.css" />
    <script src="${ctxsta}/common/icheck/icheck.min.js"></script>
    <!-- 自定义js -->
    <script type="text/javascript">
        $(document).ready(function() {
            $('input').iCheck({
                checkboxClass: 'icheckbox_flat-green',
                radioClass: 'iradio_flat-green'
            });
            init();
            changeNum();
        });
        $(document).ready(function () {
            $('#chk_all').on('ifChecked ifUnchecked', function(event) {
                if (event.type == 'ifChecked') {
                    $("input[name='productName']").iCheck('check');
                } else {
                    $("input[name='productName']").iCheck('uncheck');
                }
            });
           $("input[name='productName']").on('ifChanged', function(event){
                changeNum();
            });
        });
        /**
         * 初始化选中值
         */
        function init() {
            var productIds ="${productIds.toString()}";
            $("input[name='productName']:checkbox").each(function(){
                if(productIds.indexOf($(this).val()) >= 0 ){
                    $(this).iCheck('check');
                }
            });
        };
        function  hideWidow() {
            layer_close();
        }
        function  searchKeyword(){
            var  keyword= $("#keyword").val();
             location.href="${ctx}/ins/product/findProductKeywordOne?keyword="+keyword+"&companyId=${companyId}";
        }
        function  tijiaoForm(){
            var checks = document.getElementsByName("productName");
            var n = 0;
            for(i=0;i<checks.length;i++){
                if(checks[i].checked)
                    n++;
            }
            changeNum();
            if(n==0){
                layer.msg('至少需要选中一个');
            }else{
               $('#Form1').submit();
            }
        }
        function  changeNum(){
            var total = 0;
            var productIds=new Array();
            $("input[name='productName']").each(function(){
                if(true == $(this).is(':checked')){
                    total++;
                    productIds.push($(this).val());
                }
            });
            $("#checkNum").html(total);
            $("#productIds").val(productIds.join(","));
        }
    </script>
</bcxinFooter>
</body>
</html>
