<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>理赔记录</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>理赔记录</h5>
                </div>

                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <form id="queryForm">
                                        <table>
                                            <tr>
                                                <td style="padding-left:0px;">
                                                    <div style="display:inline;padding-left:9px;">
                                                        关键字:
                                                        <input  class="easyui-textbox" name="keyword" data-options="prompt:'保单号/报案号'" placeholder="" style="width:275px;" />
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        报案时间: 从 <input class="easyui-datebox" data-options="editable:false" name="startDate" style="width:125px;">
                                                        至 <input class="easyui-datebox" data-options="editable:false" name="endDate" style="width:125px;">
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        状态:
                                                        <select  class="easyui-combobox" data-options="panelWidth:100,panelHeight:128,editable:false" name="status" style="width:80px;">
                                                            <option value="">全部</option>
                                                            <option value="0">待提交</option>
                                                            <option value="1">审核中</option>
                                                            <option value="2">已结案</option>
                                                        </select>
                                                    </div>


                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="queryBtn" type="button" class="btn  btn-primary btn-sm" >
                                                            <i class="glyphicon glyphicon-search"></i> 搜索</button>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="clearQueryForm" type="button" class="btn btn-primary btn-sm " >
                                                            <i class="glyphicon glyphicon-minus"></i> 清空</button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>

                                    <table id="defaultTable"
                                           data-toggle="table"
                                    <%--data-show-refresh="true"--%>
                                           data-search="false"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="accident_date"
                                           data-url="${ctx}/ins/myClaim/reportList_table"
                                           data-method="post"
                                           data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                           data-side-pagination="server"
                                           data-page-list="[10, 25, 50, 100, ALL]"
                                           data-query-params="myQueryParams"
                                           data-sort-order="desc"
                                           load-success.bs.table="onLoadSuccessFn"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="report_no">案件号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="policy_no" >保单号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="reporter_name" >报案人</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="name_cn">企业名称</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="check_loss_sum">理赔金额（元）</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="status" data-formatter="formatStatsFn">案件状态</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="report_date">报案时间</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="end_case_date">结案时间</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="audit_status" data-formatter="formatAuditStatsFn">报案结果</th>
                                            <th data-halign="center" data-align="center" data-formatter="formatOperationFn">操作</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function(){
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function(){
                $("#queryForm").form("clear");
                $('#defaultTable').bootstrapTable('refresh');
            });

        });
        //关闭窗口
        function closeLayerOpen() {
            layer.closeAll();
        }
        function refresh(){
            $('#defaultTable').bootstrapTable('refresh');
        }
        function formatStatsFn(value, row) {
            if (row.status == 0) return "<span style='color:darkgray'>待提交<span>";
            if (row.status == 1) return "<span style='color:green'>审核中<span>";
            if (row.status == 2) return "<span style='color:blue'>已结案<span>";
            return "";
        }
        function formatAuditStatsFn(value, row) {
            if (row.audit_status == 0) return "<span style='color:green' title='"+row.suggestion_text+"'>报案失败<span>";
            if (row.audit_status == 1) return "<span style='color:red'>报案成功<span>";
            return "-";
        }

        function formatOperationFn(value, row) {
            var str = "";


                var onClick2 = "member_detail('"+row.ins_common_report_id+"');";
                str += '<a class="like m-l-sm text-info" href="javascript:void(0)" onclick="'+onClick2+'" title="理赔详情" > <i class="glyphicon glyphicon-list-alt"></i></a>';
                //中华审核中的理赔单
                if(row.product_code.indexOf("GZZRX-ZH")!=-1 && row.status == 1){
                    var onClick3 = "member_settle_a_lawsuit('"+row.ins_common_report_id+"');";
                    str += '<a class="like m-l-sm text-info" href="javascript:void(0)" onclick="'+onClick3+'" title="结案" > <i class="glyphicon glyphicon-edit"></i></a>';
                }


            return str;
        }


        /*理赔详情*/
        function member_detail( id) {
            member_show('理赔详情','${ctx}/ins/myClaim/reportDetailByID/'+id,'',1000,1000,null);

        }

        /*结案*/
        function member_settle_a_lawsuit(id) {
            layer.confirm('确认要结案吗？', {
                btn: ['确定', '取消'] //按钮
            }, function () {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: '${ctx}/ins/myClaim/settleALawsuitByID/' + id,
                    success: function (result) {
                        if (result.success == true) {
                            layer.msg('操作成功!', {icon: 1, time: 1000});
                            $('#defaultTable').bootstrapTable('refresh');//刷新成员表格
                        } else {
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }

        function comm_back(json){
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }

        function myQueryParams(params) { //limit offset order sort
            console.log("参数是："+params)
            var obj = g_sobj($("#queryForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }


    </script>
</bcxinFooter>
</body>
</html>
