<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title></title>
	<%@include file="/WEB-INF/include/head.jsp"%>
	<style>
		.bid-context table{
			width: 100%;

		}
		.bid-context table thead tr{
			background: #eee;
		}
		.bid-context table tr{
			line-height: 40px;
		}
		.bid-context table tr td{
			text-align: center;
			border: 1px solid #ddd;
		}
		.mt-db-7f {
			margin-top: 10px;
			display: block;
			color: #7f8fa4;
			font-size: 13px;
		}
	</style>
</head>
<body>
<div class="container bid">
	<div class="content">
		<h3>基础信息</h3>
		<p class="clearfix"><span class="pull-right">理赔状态：${(report.status eq '1' && not empty report.insPaymentInfoVo.pay_date)?'赔款支付':fns:getDictLabel (report.status,"reportStatus","")}</span></p>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">保单号</li>
					<li class="no-bor">${report.policy_no}</li>
					<li class="no-bor">报案号</li>
					<li class="no-bor">${report.report_no}</li>
					<li class="no-bor">报案人姓名</li>
					<li class="no-bor">${report.reporter_name}</li>
					<li class="no-bor">报案时间</li>
					<li class="no-bor">
						${report.report_date}
					</li>
					<li class="no-bor">报案人手机</li>
					<li class="no-bor">
						${report.reporter_tel}
					</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">事故情况</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">事故时间</li>
					<li class="no-bor">${report.accident_date}</li>
					<li class="no-bor">人伤类型</li>
					<li class="no-bor" title="${report.injured_detail_content}">${report.injured_detail_content}</li>
					<li class="no-bor">事故原因</li>
					<li class="wd80 no-bor">${report.accident_cause_level}</li>
					<li class="no-bor">事故地点</li>
					<li class="wd80 no-bor">${report.accident_address}</li>
					<li class="no-bor" style="height: 100px">事故经过</li>
					<li class="wd80 no-bor" style="height: 100px;white-space:inherit;overflow:auto;line-height: 20px;text-align: left;padding: 5px">${report.accident_process}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">理赔信息</h3>
		<div class="row bid-context">
			<c:forEach items="${ report.caseInfoVoList }" var="caseInfo" varStatus="index">
				<div class="col-sm-12">
					<ul class="bid-ul">
						<li class="no-bor">理赔人名字</li>
						<li class="no-bor">${caseInfo.claim_name}</li>
						<li class="no-bor">理赔人电话</li>
						<li class="no-bor">${caseInfo.claim_phone}</li>
						<li class="no-bor">赔案号</li>
						<li class="no-bor">${caseInfo.case_no}</li>
						<li class="no-bor">赔付次数</li>
						<li class="no-bor">${caseInfo.case_times}</li>
						<li class="no-bor">是否理赔</li>
						<li class="no-bor">${caseInfo.audit_status eq '1'?'理赔':'不理赔'}</li>
						<li class="no-bor">案件状态</li>
						<li class="no-bor">${caseInfo.case_status eq '0'?'已结案':caseInfo.case_status eq '1'?'已报案':caseInfo.case_status eq '2'?'已理算':caseInfo.case_status eq '4'?'已到账':caseInfo.case_status eq '6'?'已归档':''}</li>
						<li class="no-bor">结案时间</li>
						<li class="no-bor">${caseInfo.end_case_date}</li>
						<li class="no-bor">结案赔款金额</li>
						<li class="no-bor">${caseInfo.end_case_amount_sum}</li>
						<li class="no-bor">赔付结论</li>
						<li class="no-bor">${caseInfo.indemnity_conclusion eq '1'?'正常赔付':caseInfo.indemnity_conclusion eq '2'?'零结':caseInfo.indemnity_conclusion eq '3'?'拒赔':caseInfo.indemnity_conclusion eq '4'?'立案注销':caseInfo.indemnity_conclusion eq '5'?'报案注销':''}</li>
						<li class="no-bor">赔付说明</li>
						<li class="no-bor" title="${caseInfo.withdraw_reason}">${caseInfo.withdraw_reason}</li>
						<li class="no-bor">拒赔时间</li>
						<li class="no-bor">${caseInfo.reject_notice_date}</li>
						<li class="no-bor">拒赔通知书链接</li>
						<li class="no-bor">
							<c:if test="${not empty caseInfo.reject_notice_url}">
								<a href="${caseInfo.reject_notice_url}" target="_blank">下载</a>
							</c:if>
						</li>
					</ul>
				</div>
			</c:forEach>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">领款信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">账户类型</li>
					<li class="no-bor">${report.insPaymentInfoVo.bank_account_attribute_name}</li>
					<li class="no-bor">开户银行</li>
					<li class="no-bor">${report.insPaymentInfoVo.client_bank_name}</li>
					<li class="no-bor">开户地点</li>
					<li class="no-bor">
						${report.insPaymentInfoVo.bank_address}
					</li>
					<li class="no-bor">银行账户</li>
					<li class="no-bor">
						${report.insPaymentInfoVo.client_bank_account}
					</li>
					<li class="no-bor">开户名</li>
					<li class="no-bor">${report.insPaymentInfoVo.client_name}</li>
					<li class="no-bor">证件类型</li>
					<li class="no-bor">${report.insPaymentInfoVo.client_certificate_type_name}</li>
					<li class="no-bor">证件号码</li>
					<li class="no-bor">${report.insPaymentInfoVo.client_certificate_no}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">附件信息</h3>
		<div class="row bid-context">
			<div class="img-show col-xs-12">
				<c:forEach items="${report.claimInformationVoList}" var="uploadObj">
					<div class="col-sm-2 col-xs-2">
						<img src="${uploadObj.short_group_code eq '001000'?fn:replace(uploadObj.file_path,'doc','png'):uploadObj.file_path}" width="100%" height="50px">
						<span class="mt-db-7f" UPLOAD-CODE="${uploadObj.short_group_code}" title=""></span>
					</div>
				</c:forEach>
			</div>
		</div>
	</div>
	</div>
</div>
<bcxinFooter>
<script type="text/javascript" src="${ctxsta}/admin/product/js/jquery-1.11.3.js"></script>
	<script>
        $(function(){
            function lineHeight(name){
                var height=parseFloat($("."+name+">li:nth-child(2)").css("height"));
                $("."+name+">li:first-child").css("line-height",height+"px").css("padding","0");
            }
            lineHeight("big");
            lineHeight("img-look");
            lineHeight("addr");
            lineHeight("day");
            $('.mt-db-7f').each(function(){
                setUploads(this);
			});
        })

        //计算天数差的函数，通用
        function  DateDiff(sDate1,  sDate2){    //sDate1和sDate2是2006-12-18格式
            var  aDate,  oDate1,  oDate2,  iDays
            aDate  =  sDate1.split("-")
            oDate1  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])    //转换为12-18-2006格式
            aDate  =  sDate2.split("-")
            oDate2  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])
            iDays  =  parseInt(Math.abs(oDate1  -  oDate2)  /  1000  /  60  /  60  /24) + 1    //把相差的毫秒数转换为天数
            return  iDays
        }

        function codeToName(_code){
            var _name = '';
            if('001000' == _code){
                _name = '索赔申请书（加盖公章）';
            }else if('007003' == _code){
                _name = '赔付协议及权益转让书（加盖公章）';
            }else if('003019' == _code){
                _name = '事故经过说明';
            }else if('003007' == _code){
                _name = '劳动合同（复印件）';
            }else if('004005' == _code){
                _name = '首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料';
            }else if('004006' == _code){
                _name = '医生提供的病假条';
            }else if('004006' == _code){
                _name = '单位休假记录，需公司由人事部门盖章';
            }else if('003012' == _code){
                _name = '事故认定书';
            }else if('006004' == _code){
                _name = '公司营业执照、法人身份证复印件。经办人身份证复印件';
            }else if('003001' == _code){
                _name = '被保险人员工有无工伤保险证明（加盖公章）';
            }else if('003007' == _code){
                _name = '工伤认定书';
            }else if('005000' == _code){
                _name = '判决书原件及提交法院材料的复印件';
            }else if('006005' == _code){
                _name = '事故员工身份证复印件';
            }
            return _name;
        }
        function setUploads(_obj){
            var _code = $(_obj).attr('UPLOAD-CODE');
            var _title = codeToName(_code);
            var _t = _title.length>7?(_title.substring(0,7)+'...'):_title;
            $(_obj).attr('title',_title);
            $(_obj).html(_title);
        }
	</script>
</bcxinFooter>
</body>
</html>
