package com.bcxin.ins.models.web;

import com.bcxin.ins.core.entity.SysRegion;
import com.bcxin.ins.core.service.SysRegionService;
import com.bcxin.ins.core.util.SysRegionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Area 控制层
 */

@RestController
@RequestMapping("${systemPath}/sysregion")
public class SysRegionController {

    @Autowired
    private SysRegionService sysRegionService;

    @RequestMapping("/province/{areaId}")
    public List<SysRegion> provinceDetail(@PathVariable Integer areaId) {
        if (areaId == null) {
            areaId = 100000;
        }
        Map<String, Object> columnMap = new HashMap<String, Object>();
        return SysRegionUtil.getRegionList(areaId.toString());
    }
    @RequestMapping("/province")
    public List<SysRegion> province() {
        return provinceDetail(null);
    }
}