package com.bcxin.ins.models.web;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.entity.SysMenu;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.entity.SysUserRole;
import com.bcxin.ins.core.service.SysMenuService;
import com.bcxin.ins.core.service.SysUserRoleService;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.models.apply.service.PreseverApplyService;
import com.bcxin.ins.spring.security.Principal;
import com.bcxin.ins.spring.security.shiro.session.SessionDAO;
import com.bcxin.ins.util.CookieUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
* 类名称：MainController   
* 类描述：后台主页面表示层   
* 创建人：liujinju
* @version    
*
 */
@Controller
@RequestMapping("${systemPath}")
public class SysMainController extends BaseController {

    /** 后台管理主界面 */
	private static final String MAIN = getViewPath("admin/main/main");
	/** 后台管理主界面初始化首页 */
	private static final String MAIN_INDEX = getViewPath("admin/main/index");
	/** 后台管理登录页面 */
	private static final String ADMIN_LOGIN = getViewPath("admin/login/admin_login");
	
	@Autowired
	private SessionDAO sessionDAOSt;
	@Autowired
	private SysMenuService sysMenuService;
	@Autowired
	private SysUserRoleService sysUserRoleService;
	@Autowired
	private SysUserService sysUserService;

	@Autowired
	private PreseverApplyService preseverApplyService;

	/**
	 * 进入操作中心
	 * @param request
	 * @return
	 */
	@RequiresPermissions("user")
	@RequestMapping(value = "/index")
	public String main(HttpServletRequest request, HttpServletResponse response,Model model) {
		Principal principal = SysUserUtils.getPrincipal();
		// 登录成功后，验证码计算器清零
		sysUserService.isValidateCodeLogin(principal.getLoginName(), false, true);
		
		// 如果已登录，再次访问主页，则退出原账号。
		if (GlobalConstants.TRUE.equals(GlobalConstants.getConfig("notAllowRefreshIndex"))){
			String logined = CookieUtils.getCookie(request, "LOGINED");
			if (StrUtil.isBlank(logined) || "false".equals(logined)){
				CookieUtils.setCookie(response, "LOGINED", "true");
			}else if (StrUtil.equals(logined, "true")){
				SysUserUtils.getSubject().logout();
				return "redirect:" + MAIN;
			}
		}
		if (logger.isDebugEnabled()){
			logger.debug("show index, active session size: {}", sessionDAOSt.getActiveSessions(false).size());
		}
		List<SysMenu> sysMenus = Lists.newArrayList();
		//系统管理员具有所有菜单
		if(principal.getLoginName().equals(GlobalConstants.getAdminName())){
			sysMenus = sysMenuService.selectSysMenu();
		}else{
			List<Long> roleIdList = sysUserRoleService.selectRoleIdByAccountId(principal.getId());//获取用户角色id列表
			if(roleIdList != null && roleIdList.size() > 0){
				sysMenus = sysMenuService.selectSysMenuByRole(roleIdList);//获取用户拥有的菜单
			}
		}
		SysUser user = SysUserUtils.getUser();
		model.addAttribute("sysMenus", sysMenus);
		model.addAttribute("sysUser", user);
		return MAIN;
	}
	
	/**
	 * 后台管理主界面初始化首页
	 * @param request
	 * @return
	 */
	@RequiresPermissions("user")
	@RequestMapping(value = "/main/index", method = RequestMethod.GET)
	public String mainIndex(HttpServletRequest request) {
		return MAIN_INDEX;
	}

	@RequestMapping(value = "/findCheckPendingPreservationRecord", method = RequestMethod.POST)
	@ResponseBody
	public R findCheckPendingPreservationRecord() {
		return preseverApplyService.findCheckPendingPreservationRecord();
	}
}