package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.*;
import com.bcxin.ins.core.service.*;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.vo.ConstProp;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
* 类名称：SysUserController   
* 类描述：系统管理员控制器   
* 创建人:liujinju
* @version
 */
@Controller
@RequestMapping("${systemPath}/mysysuser")
public class MySysUserController extends BaseController {

	/** 系统管理员列表 */
	private static final String SYSTEM_USER_LIST = getViewPath("admin/system/system_user_list");
	/** 创建或者修改用户界面 */
	private static final String SYSTEM_USER_ADDUSER = getViewPath("admin/system/system_user_add");
	/** 创建或者修改用户界面 */
	private static final String SYSTEM_USER_DETAIL = getViewPath("admin/system/system_user_detail");

	@Autowired
	private MySysUserService mySysUserService;

	/**用户列表*/
	@RequiresPermissions("mysysuser:win:list")
	@RequestMapping(value = "/win/list")
	public String winList(Model model,  HttpServletRequest request, @RequestParam Map<String,Object> params) {
		return SYSTEM_USER_LIST;
	}

	/**用户详情*/
	@RequiresPermissions("mysysuser:win:list")
	@RequestMapping(value = "/win/detail")
	public String winDetail(Model model, HttpServletRequest request, @RequestParam Map<String,Object> params) {
		model.addAttribute("user",mySysUserService.selectByUserID(Long.valueOf(String.valueOf(params.get("id")))));
		model.addAttribute("roles",mySysUserService.roles());
		return SYSTEM_USER_DETAIL;
	}
	/**用户详情*/
	@RequiresPermissions("mysysuser:win:list")
	@RequestMapping(value = "/getUserByID")
	public @ResponseBody Object getUserByID(Model model, HttpServletRequest request, @RequestParam Map<String,Object> params) {
		return mySysUserService.selectByUserID(Long.valueOf(String.valueOf(params.get("id"))));
	}

	/**修改窗口*/
	@RequiresPermissions("mysysuser:win:list")
	@RequestMapping(value = "/win/upd")
	public String winUpd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		//根据用户ID获得用户信息，放到model中给jsp用，包含role_id字段
		model.addAttribute("user",mySysUserService.selectByUserID(Long.valueOf(String.valueOf(params.get("id")))));
		model.addAttribute("roles",mySysUserService.roles());
		model.addAttribute("mark","upd");
		return SYSTEM_USER_ADDUSER;
	}

	/**新增窗口*/
	@RequiresPermissions("mysysuser:win:list")
	@RequestMapping(value = "/win/add")
	public String winAdd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		model.addAttribute("roles",mySysUserService.roles());
		model.addAttribute("mark","add");
		return SYSTEM_USER_ADDUSER;
	}

	/**角色列表*/
	@RequiresPermissions("mysysuser:win:list")
	@RequestMapping(value = "/roles" , method = RequestMethod.POST)
	public @ResponseBody Object roles(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		return mySysUserService.roles();
	}

	/**分页查询用户*/
	@RequiresPermissions("mysysuser:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(mySysUserService.query(p),resp); return null;
	}

	/**新增用户*/
	@RequiresPermissions("mysysuser:add")
	@RequestMapping(value = "/add" , method = RequestMethod.POST)
	public @ResponseBody R add(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		//TODO ctj 必要参数规则校验
		if(!CTLUtil.pNotNull(params,"user_name","login_name","status","role_id","telephone")) return new R(false, CTLUtil.LACK_P_MSG);
		Map<Object,Object> p = CTLUtil.init(req,params);
		return mySysUserService.add(p);
	}

	/**修改用户*/
	@RequiresPermissions("mysysuser:upd")
	@RequestMapping(value = "/upd", method = RequestMethod.POST)
	public @ResponseBody R upd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		//TODO ctj 必要参数规则校验
		if(!CTLUtil.pNotNull(params,"id")) return new R(false, CTLUtil.LACK_P_MSG);
		Map<Object,Object> p = CTLUtil.init(req,params);
		return mySysUserService.upd(p);
	}

	/**启用/禁止用户*/
	@RequiresPermissions("mysysuser:audit")
	@RequestMapping(value = "/audit", method = RequestMethod.POST)
	public @ResponseBody R audit(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		//TODO ctj 必要参数规则校验 status 只能0和1
		if(!CTLUtil.pNotNull(params,"id","status")) return new R(false,CTLUtil.LACK_P_MSG);
		if(!(ConstProp.DIGIT_ZERO.equals(params.get("status"))||"1".equals(params.get("status")))) return new R(false,"值错误");
		return mySysUserService.updateUserStatus(params);
	}

	/**重置密码*/
	@RequiresPermissions("mysysuser:repwd")
	@RequestMapping(value = "/repwd")
	public @ResponseBody R rePwd(@RequestParam Map<Object,Object> params ) {
		//TODO 必要参数规则校验
		if(!CTLUtil.pNotNull(params,"id")) return new R(false,CTLUtil.LACK_P_MSG);
		return mySysUserService.updateUserPws(params);
	}


}