package com.bcxin.ins.models.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.MyLogBusinessrequest;
import com.bcxin.ins.core.entity.SysLogSms;
import com.bcxin.ins.core.service.MyLogBusinessrequestService;
import com.bcxin.ins.core.util.CTLUtil;
import com.google.common.collect.Maps;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 接口访问日志
 */
@Controller
@RequestMapping("${systemPath}/mylogbusinessrequest")
@Lazy(false)
public class MyLogBusinessrequestController extends BaseController {

	private static final String LIST = getViewPath("admin/logbusinessrequest/log_businessrequest_list");
	private static final String LOG_INFO = getViewPath("admin/logbusinessrequest/log_businessrequest_info");

	@Autowired
	private MyLogBusinessrequestService logS;

	@RequiresPermissions("mylogbusinessrequest:win:list")
	@RequestMapping(value = "/win/list")
	public  String winList(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		return LIST;
	}

	@RequiresPermissions("mylogbusinessrequest:win:list")
	@RequestMapping(value = "/query")
	public @ResponseBody Object query(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(logS.query(p),resp);
		return null;
	}

	/**
	 * @Description: 查看日志详情
	 * @param model
	 * @param oid
	 * @return
	 */
	@RequestMapping(value = "/list/info/{oid}")
	public String edit(Model model,@RequestParam Map<Object,Object> params , @PathVariable Long oid ,HttpServletResponse resp){
		MyLogBusinessrequest logBusinessrequest = logS.selectById(oid);
		model.addAttribute("row",logBusinessrequest);
		return LOG_INFO;
	}

}