package com.bcxin.ins.models.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.InfoNews;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.InfoNewsService;
import com.bcxin.ins.core.service.SysDictService;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.vo.ConstProp;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 类名称：InfoNewsController
 * 类描述：新闻资讯
 * 创建人:xiangyaoqi
 * @version
 */
@Controller
@RequestMapping("${systemPath}/myinfo")
public class InfoNewsController extends BaseController {
	/** 专题资讯页面 */
	private static final String LIST = getViewPath("admin/system/info_news_list");
	private static final String ADD_INFO = getViewPath("admin/system/info_news_add");

	@Autowired
	private InfoNewsService infoNewsService;

	@Autowired
	private SysDictService sysDictService;

	/**专题资讯列表页面*/
	@RequiresPermissions("myinfo:win:list")
	@RequestMapping(value = "/win/list")
	public String winList(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return LIST;
	}

	/**新增专题资讯列表页面*/
	@RequestMapping(value = "/list/add", method = RequestMethod.GET)
	public String add(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest req,HttpServletResponse resp) {
		model.addAttribute("mark","add");
		return ADD_INFO;
	}

	/**专题资讯详情页面*/
	@RequestMapping(value = "/list/edit/{oid}")
	public String edit(Model model,@RequestParam Map<Object,Object> params , @PathVariable Long oid){
		InfoNews infoNews =infoNewsService.selectById(oid);
		String getRecommend_channel=infoNews.getRecommend_channel();
		String sort=infoNews.getSort();
		if ("999999999".equals(sort)){
			infoNews.setSort("");
		}
		String json = JSON.toJSONStringWithDateFormat(infoNews, "yyyy-MM-dd HH:mm:ss");
		model.addAttribute("oid",infoNews.getInfo_news_id());


		model.addAttribute("photo_url",infoNews.getPhoto_url());
		model.addAttribute("row",json);
		model.addAttribute("mark","upd");
		return ADD_INFO;
	}


	/**列表分页*/
	@RequiresPermissions("myinfo:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(infoNewsService.query(params),resp);
		return null;
	}

	/**新增专题资讯*/
	@RequiresPermissions("myinfo:info:add")
	@RequestMapping(value = "/info/add" , method = RequestMethod.POST)
	public @ResponseBody Object wuAdd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		response.setHeader("Access-Control-Allow-Origin", "*");
		R r = infoNewsService.infoNewsAdd(CTLUtil.init(req, params));
		CTLUtil.out2(r,response);
		return null;
	}

	/**新闻资讯类型列表*/
	@RequestMapping(value = "/rights" , method = RequestMethod.POST)
	public @ResponseBody Object rights(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		return infoNewsService.getInfoNewsTypeList(params);
	}

	/**修改新闻咨询*/
	@RequiresPermissions("myinfo:info:upd")
	@RequestMapping(value = "/info/upd" , method = RequestMethod.POST)
	public @ResponseBody Object wuUpd(@RequestParam Map<Object,Object> params ,HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
//		String Url =req.getParameter("photo_url");
		return infoNewsService.infoNewsUpd(p);
	}
	/**修改新闻图片*/
	@RequiresPermissions("myinfo:info:upd")
	@RequestMapping("/uploadFileImage")
	@ResponseBody
	public R uploadFileImage(@RequestParam(value = "upload_file", required = false) MultipartFile upload_file) throws Exception {
		try {
			if (upload_file!=null&&upload_file.getSize()>0) {
				return infoNewsService.doUploadFile(upload_file);
			}else {
				return new R(false, "请选择要上传的文件");
			}
		} catch (NullPointerException e) {
			return new R(false, "请选择上传文件图片");
		}

	}
	/**启用/停用新闻资讯*/
	@RequiresPermissions("myinfo:audit")
	@RequestMapping(value = "/audit", method = RequestMethod.POST)
	public @ResponseBody R audit(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		/// /TODO ctj 必要参数规则校验 status 只能0和1
		if(!CTLUtil.pNotNull(params,"id","status")) return new R(false,CTLUtil.LACK_P_MSG);
		if(!(ConstProp.DIGIT_ZERO.equals(params.get("status"))||"1".equals(params.get("status")))) return new R(false,"值错误");
		return infoNewsService.updateInfoNewsStatus(params);
	}
}