package com.bcxin.ins.models.statistics.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.dao.SysLogDao;
import com.bcxin.ins.models.pro.dao.MyProMapper;
import com.bcxin.ins.models.statistics.dao.StatisticsMapper;
import com.bcxin.ins.models.statistics.service.StatisticsService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import com.bcxin.ins.core.entity.R;

/**
 * <b> 公告业务 </b>
 * @author ZXF
 * @create 2018/07/31 0031 17:20
 * @version
 * @注意事项 </b>
 */
@Service
@Transactional
public class StatisticsServiceImpl implements StatisticsService {
    private static Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);

    @Autowired
    private StatisticsMapper staM;
    @Autowired
    private MyProMapper proM;


    /**
     * 用户数据
     *   type 类型 1标识本平台，2表示第三方，3表示总和
     * @param p
     */
    @Override
    public R user(Map<Object, Object> p) {
        int y = 2021;
        if(p.get("year") != null){
            y = Integer.parseInt((String)p.get("year"));
        }
        int count = 13;
        int _m = 12;
        if(y == 1900+(new Date()).getYear()){//如果查询当前年，则最后月份为当前月
            _m = (new Date()).getMonth()+1;
            count = _m+1;
        }
        String[] yearArr = new String[_m];
        Integer[] blbs = new Integer[_m];
        Integer[] thrs = new Integer[_m];
        Integer[] alls = new Integer[_m];
        String m;
        for(int i=1;i<count;i++){
            if(i<10){
                m = "0"+i;
            }else{
                m = String.valueOf(i);
            }
            yearArr[i-1] = y+"-"+m;
            blbs[i-1] = staM.sta_user("1",yearArr[i-1]);//查询本站
            thrs[i-1] = staM.sta_user("2",yearArr[i-1]);//查询第三方
            alls[i-1] = staM.sta_user("3",yearArr[i-1]);//查询总和
        }
        p.put("yms",yearArr);//2018-01,2018-02
        p.put("blbs",blbs);
        p.put("thrs",thrs);
        p.put("alls",alls);
        return new R(true,p);
    }

    /**
     * 年度平台用户注册数据统计
     * @param p
     */
    @Override
    public R user_reg(Map<Object, Object> p) {
        int y = 2021;
        if(p.get("year") != null){
            y = Integer.parseInt((String)p.get("year"));
        }
        int count = 13;
        int _m = 12;
        if(y == 1900+(new Date()).getYear()){//如果查询当前年，则最后月份为当前月
            _m = (new Date()).getMonth()+1;
            count = _m+1;
        }
        String[] yearArr = new String[_m];
        Integer[] xds = new Integer[_m];
        Integer[] cjs = new Integer[_m];
        String m;
        int max = 0;
        int bval;
        int tval;
        for(int i=1;i<count;i++){
            if(i<10){
                m = "0"+i;
            }else{
                m = String.valueOf(i);
            }
            yearArr[i-1] = y+"-"+m;
            bval = staM.user_reg("BLB",yearArr[i-1]);
            if(max<bval){
                max = bval;
            }
            xds[i-1] = bval;//百联保注册
            tval = staM.user_reg("",yearArr[i-1]);
            cjs[i-1] = tval;//第三方注册
        }
        p.put("yms",yearArr);//2018-01,2018-02
        p.put("xds",xds);
        p.put("cjs",cjs);
        return new R(true,p);
    }

    /**
     * 产品总访问数据
     * @param p
     */
    @Override
    public R pro_req(Map<Object, Object> p) {
        int y = 2021;
        if(p.get("year") != null){
            y = Integer.parseInt((String)p.get("year"));
        }
        List<Map<Object, Object>> proList = proM.queryProTrue();
        String kw = "product/productInfo";
        JSONObject jsonP = new JSONObject();
        p.put("all",staM.keywork_pro(kw,String.valueOf(y)));
        JSONObject jsonC = new JSONObject();
        Map<Object, Object> m = Maps.newHashMap();
        int max = 0;
        int val = 0;
        for(Map map : proList){
            val = staM.keywork_pro(kw+"/"+map.get("pro_primary_id"),String.valueOf(y));
            if(val!=0){
                m.put(map.get("insurance_name"),val);
            }
            if(max<val){
                max = val;
            }
        }
        p.put("charts",m);
        p.put("max",((max/100)+1)*100);
        return new R(true,p);
    }

    /**
     * 统计每年各产品的销售数量、金额，参考“产品访问数据
     * @param p
     */
    @Override
    public R amt_pro(Map<Object, Object> p) {
        int y = 2021;
        if(p.get("year") != null){
            y = Integer.parseInt((String)p.get("year"));
        }
        List<String> list = staM.pro_name_cb(String.valueOf(y));
        String[] pns = new String[list.size()];//产品名
        Integer[] pus = new Integer[list.size()];//承保产品数
        Double[] pms = new Double[list.size()];//承保产品金额
        for(int i=0, l=list.size(); i<l;i++){
            pns[i] = list.get(i);
            pus[i] = staM.pro_num_cb(list.get(i), String.valueOf(y));
            pms[i] = staM.pro_amt_cb(list.get(i), String.valueOf(y));
        }

        p.put("pns",pns);
        p.put("pus",pus);
        p.put("pms",pms);
        return new R(true,p);
    }

    /**
     * 订单数据
     * @param p
     */
    @Override
    public R com_order(Map<Object, Object> p) {
        int y = 2021;
        if(p.get("year") != null){
            y = Integer.parseInt((String)p.get("year"));
        }
        int count = 13;
        int _m = 12;
        if(y == 1900+(new Date()).getYear()){//如果查询当前年，则最后月份为当前月
            _m = (new Date()).getMonth()+1;
            count = _m+1;
        }
        String[] yearArr = new String[_m];
        Integer[] xds = new Integer[_m];
        Integer[] cjs = new Integer[_m];
        Double[] bls = new Double[_m];
        String m;
        int max = 0;
        int val = 0;
        for(int i=1;i<count;i++){
            if(i<10){
                m = "0"+i;
            }else{
                m = String.valueOf(i);
            }
            yearArr[i-1] = y+"-"+m;
            val = staM.com_order("",yearArr[i-1]);
            if(max<val){
                max = val;
            }
            xds[i-1] = val;//查询总下单数
            cjs[i-1] = staM.com_order("1",yearArr[i-1]);//查询总成交数
            if(cjs[i-1] > 0){
                double bl = Double.valueOf(cjs[i-1])/Double.valueOf(xds[i-1]);
                bls[i-1] = (BigDecimal.valueOf(bl)).multiply(BigDecimal.valueOf(Double.parseDouble("100"))).setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();//计算成交率
            }
        }
        p.put("yms",yearArr);//2018-01,2018-02
        p.put("xds",xds);
        p.put("cjs",cjs);
        p.put("bls",bls);
        p.put("max",((max/100)+1)*100);
        return new R(true,p);
    }

    /**
     * 查询某月成交订单对应产品数据
     * @param p
     */
    @Override
    public R pro_order(Map<Object, Object> p) {
        String ym = (String)p.get("ym");
        if(ym.length()==6){
            ym = ym.substring(0,5)+"0"+ym.substring(5,6);
        }
        List<String> pNameList = staM.pro_order(ym);
        String cName = "";
        String cNames = "";
        String counts = "";
        int count = 0;
        int num = 0;
        for(String name : pNameList){

            if(!name.equals(cName)){
                if(count>0){
                    counts = counts + "," + count;
                }
                count = 0;
                cName = name;
                cNames = cNames + "," + name;
            }
            count++;
            num++;
            if(num == pNameList.size()){
                counts = counts + "," + count;
            }
        }
        cNames = cNames.substring(1,cNames.length());
        counts = counts.substring(1,counts.length());
        String[] nameArr = cNames.split(",");
        String[] countArr = counts.split(",");
        List list = Lists.newArrayList();
        Map mapc = null;
        for(int i = 0; i < countArr.length;i++){
            mapc = Maps.newHashMap();
            mapc.put("name",nameArr[i]);
            mapc.put("value",countArr[i]);
            list.add(mapc);
        }

        p.put("list",list);
        p.put("names",cNames);
        return new R(true,p);
    }

    /**
     * 查询某月产品成交订单对应保费总和数据
     * @param p
     */
    @Override
    public R pro_order_amout(Map<Object, Object> p) {
        String ym = (String)p.get("ym");
        if(ym.length()==6){
            ym = ym.substring(0,5)+"0"+ym.substring(5,6);
        }
        List<String> pNameList = staM.pro_order(ym);
        String cName = "";
        String cNames = "";
        String counts = "";
        int count = 0;
        int num = 0;
        if(pNameList.size()==0){
            return new R(false,"无记录");
        }
        for(String name : pNameList){

            if(!name.equals(cName)){
                if(count>0){
                    counts = counts + "," + count;
                }
                count = 0;
                cName = name;
                cNames = cNames + "," + name;
            }
            count++;
            num++;
            if(num == pNameList.size()){
                counts = counts + "," + count;
            }
        }
        cNames = cNames.substring(1,cNames.length());
        String[] nameArr = cNames.split(",");
        List list = Lists.newArrayList();
        Map mapc = null;
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal amounts = BigDecimal.ZERO;
        for(int i = 0; i < nameArr.length;i++){
            amt = staM.pro_order_amout(ym,nameArr[i]);
            amounts = amounts.add(amt);
            mapc = Maps.newHashMap();
            mapc.put("name",nameArr[i]);
            mapc.put("value",String.valueOf(amt));
            list.add(mapc);
        }
        p.put("list",list);
        p.put("names",cNames);
        p.put("amounts",amounts);
        return new R(true,p);
    }

    /**
     * 统计每月销售金额、当月累计销售总额
     * @param p
     */
    @Override
    public R all_amt(Map<Object, Object> p) {
        int y = 2021;
        if(p.get("year") != null){
            y = Integer.parseInt((String)p.get("year"));
        }
        int count = 13;
        int _m = 12;
        if(y == 1900+(new Date()).getYear()){//如果查询当前年，则最后月份为当前月
            _m = (new Date()).getMonth()+1;
            count = _m+1;
        }
        String ym = "";
        Integer[] xds = new Integer[_m];
        Integer[] cjs = new Integer[_m];
        Double[] bls = new Double[_m];
        String m;
        BigDecimal all = BigDecimal.ZERO;
        BigDecimal max = BigDecimal.ZERO;
        BigDecimal val;
        List cls = null;
        List pls = Lists.newArrayList();
        for(int i=1;i<count;i++){
            if(i<10){
                m = "0"+i;
            }else{
                m = String.valueOf(i);
            }
            ym = y+"-"+m;
            val = staM.all_amt(ym);
            if(val == null){
                val = BigDecimal.ZERO;
            }
            if(max.compareTo(val) < 0){
                max = val;
            }
            all = all.add(val);
            cls = Lists.newArrayList();
            cls.add(ym);
            cls.add(val);
            pls.add(cls);

        }
        p.put("pls",pls);
        int s = String.valueOf(max.intValue()).length();
        String n = String.valueOf(Integer.parseInt(String.valueOf(max).substring(0,1))+1);
        for(int i = 1;i<s;i++){
            n += "0";
        }
        p.put("max",Integer.valueOf(n));
        p.put("amounts",all);
        return new R(true,p);
    }

    public static void main(String[] args) {
        BigDecimal a = new BigDecimal("2340575.98");
        int s = String.valueOf(Integer.parseInt(String.valueOf(a))).length();
        System.out.println(s);
        /*List<String> list = Lists.newArrayList();
        list.add("a2");
        list.add("a2");
        list.add("a2");
        list.add("a2");
        list.add("a3");
        list.add("a3");
        list.add("a3");
        list.add("a1");
        list.add("a1");
        String cName = "";
        String cNames = "";
        String counts = "";
        int count = 0;
        int num = 0;
        for(String name : list){

            if(!name.equals(cName)){
                if(count>0){
                    counts = counts + "," + count;
                }
                count = 0;
                cName = name;
                cNames = cNames + "," + name;
            }
            count++;
            num++;
            if(num == list.size()){
                counts = counts + "," + count;
            }
        }
        System.out.println("cNames:"+cNames);
        System.out.println("counts:"+counts);*/
    }
}