package com.bcxin.ins.models.product.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.models.data.entity.InsProductType;
import com.bcxin.ins.models.data.service.InsProductTypeService;
import com.bcxin.ins.vo.DwzPage;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;


@Controller
@RequestMapping("${systemPath}/ins/product/guarantee")
public class InsProductGuaranteeController extends BaseController {

	/** PG1.3 分类设置 */
	private static final String PRODUCT_GUARANTEE_LIST = getViewPath("admin/product/product_guarantee_list");


	@Autowired
	private InsProductTypeService insProductTypeService;



	@RequiresPermissions("product:guarantee:list:view")
	@RequestMapping("/list")
	public String list(ModelMap model, DwzPage page) {

		List<InsProductType> plst= insProductTypeService.findAllList();
//		List<InsProductType> list =insProductTypeService.findList(); 待组装
//		// 一级
//		// 二级
//		// 三级
//		// 四级
	   model.addAttribute("plst", plst);
		return PRODUCT_GUARANTEE_LIST;
	}



}
