package com.bcxin.ins.models.product.entity;

import com.bcxin.ins.core.base.entity.DataEntity;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableName;
/**
 * <p>
 * 产品修改记录表
 * </p>
 *
 * @author liyongqiang
 * @since 2017-02-13
 */
@TableName("ins_product_log")
public class InsProductLog extends DataEntity<InsProductLog> {

    private static final long serialVersionUID = 1L;


    public InsProductLog(Long productId) {

        this.productId = productId;
    }

    public InsProductLog() {
    }

    /**
     * 产品id(（ins_products）    )
     */
    @TableField(value = "product_id")
    private Long productId;
    /**
     * 分销商idsystem_company(3)
     */
    @TableField(value = "product_name")
    private String productName;
    /**
     * 佣金比例
     */
    @TableField(value = "product_type")
    private String productType;
    /**
     * 提交原因
     */
    @TableField(value = "commit_reason")
    private String commitReason;
    /**
     * 供应商
     */
    @TableField(value = "company_name")
    private String companyName;


    /**
     *修改类型  （1.修改产品佣金，2.修改产品具体信息）
     */
    @TableField(value = "update_type")
    private  String updateType;

    /**
     * 3种状态 （新增，修改 ，删除）
     */
    @TableField(value = "update_status")
    private  String updateStatus;



    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getCommitReason() {
        return commitReason;
    }

    public void setCommitReason(String commitReason) {
        this.commitReason = commitReason;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }


    public String getUpdateType() {
        return updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public String getUpdateStatus() {
        return updateStatus;
    }

    public void setUpdateStatus(String updateStatus) {
        this.updateStatus = updateStatus;
    }
}
