/*==============================================================*/
/* DBMS name:      MySQL 5.0                                    */
/* Created on:     2017/1/4 15:51:22                            */
/*==============================================================*/


drop table if exists ins_ar_debtors;

drop table if exists ins_bad_analysis;

drop table if exists ins_bad_debt;

drop table if exists ins_credit_management;

drop table if exists ins_debt_ages;

drop table if exists ins_forecasted_detail;

drop table if exists ins_manager_detail;

drop table if exists ins_overdue_detail;

drop table if exists ins_past_bad_detail;

drop table if exists ins_recent_years_sell;

drop table if exists ins_service_description;

drop table if exists ins_top_buyers;

drop table if exists ins_turnover;

/*==============================================================*/
/* Table: ins_ar_debtors                                        */
/*==============================================================*/
create table ins_ar_debtors
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   domestic_total       decimal(18,2) comment '内贸 未偿债务总额
            ',
   domestic_buyers      int comment '内贸 债务人数量
            ',
   amount_qutstanding   varchar(64) comment '未偿债务
            ',
   export_buyers        int comment '出口 债务人数量
            ',
   export_total         decimal(18,2) comment '出口 未偿债务总额
            ',
   common_export_id     bigint(64) comment '企业短期
            ins_common_export',
   primary key (id)
);

alter table ins_ar_debtors comment '应收账款余额分布表';

/*==============================================================*/
/* Table: ins_bad_analysis                                      */
/*==============================================================*/
create table ins_bad_analysis
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   year                 int
                         comment '财务年度
            ',
   badDebt_total        decimal(18,2)
                         comment '坏账损失总计
            ',
   badDebt_loss         decimal(18,2)
                         comment '最大的单个坏账损失金额
            ',
   badDebt_number       int
                         comment '坏账损失的个数
            ',
   take_back_amount     decimal(18,2)
                         comment '成功追回款项
            ',
   bad_debt_id          bigint(64) comment '账龄及坏账分析表
            ins_bad_debt
            ',
   primary key (id)
);

alter table ins_bad_analysis comment '坏账分析表';

/*==============================================================*/
/* Table: ins_bad_debt                                          */
/*==============================================================*/
create table ins_bad_debt
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   asOf                 varchar(64) comment '截止日期
            ',
   domestics            varchar(64) comment '内贸
            ',
   exports              varchar(64) comment '出口
            ',
   is_overdue_buyers    bigint(64) comment '是否已有买方逾期31天以上
            ',
   domestic_amount_sum decimal(18,2)
                        comment '内贸金额统计
            ',
   domestic_percentage_sum decimal(18,4)
                            comment '内贸占比统计
            ',
   export_amount_sum    decimal(18,2)
                         comment '出口金额统计
            ',
   export_percentage_sum decimal(18,4)
                          comment '出口占比统计
            ',
   primary key (id)
);

alter table ins_bad_debt comment '账龄及坏账分析表';

/*==============================================================*/
/* Table: ins_credit_management                                 */
/*==============================================================*/
create table ins_credit_management
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   delivery             datetime comment '货物发送日后
            ',
   other_date           datetime comment '其它 – 请注明何时
            ',
   is_creditlimit       int
                         comment '是否每个客户都被授予内部信用额度
            ',
   material_path        varchar(64) comment '上诉补充材料请在此处上传提交（限20M以内）
            ',
   provide_details      varchar(64) comment '如果以上回答为“是”，请提供内部信用额度审批所依据信息的主要获取渠道
            ',
   is_expire_before     int
                         comment '是否到期日前致电客户
            ',
   expire_before_now    varchar(64) comment '自到期日至采取行动日的天数
            ',
   is_expire_after      int
                         comment '是否到期日后致电客户
            ',
   now_expire_after     varchar(64) comment '自到期日至采取行动日的天数
            ',
   is_chasing_letters   int
                         comment '是否催收信函
            ',
   chasing_letters      varchar(64) comment '自到期日至采取行动日的天数
            ',
   is_deliveries_suspended int
                            comment '是否暂停发货
            ',
   deliveries_suspended_day varchar(64) comment '自到期日至采取行动日的天数
            ',
   is_visits            int
                         comment '是否实地拜访
            ',
   visits_day           varchar(64) comment '自到期日至采取行动日的天数
            ',
   is_debt_collectors   int
                         comment '是否委托追帐公司
            ',
   debt_collectors_day  varchar(64) comment '自到期日至采取行动日的天数
            ',
   is_legal_action      int
                         comment '是否诉诸法律手段
            ',
   legal_action_day     varchar(64) comment '自到期日至采取行动日的天数
            ',
   is_others            int
                         comment '是否其它 – 请详述
            ',
   others_day           varchar(64) comment '自到期日至采取行动日的天数
            ',
   primary key (id)
);

alter table ins_credit_management comment '公司信用管理表';

/*==============================================================*/
/* Table: ins_debt_ages                                         */
/*==============================================================*/
create table ins_debt_ages
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   domestic_amount      decimal(18,2) comment '内贸金额
            ',
   domestic_percentage  decimal(18,4) comment '内贸占比
            ',
   credit_period        varchar(64) comment '账龄
            ',
   export_amount        decimal(18,2) comment '出口金额
            ',
   export_percentage    decimal(18,4) comment '出口占比
            ',
   bad_debt_id          bigint(64) comment '账龄及坏账分析表
            ins_bad_debt',
   primary key (id)
);

alter table ins_debt_ages comment '账龄及坏账分析周期表';

/*==============================================================*/
/* Table: ins_forecasted_detail                                 */
/*==============================================================*/
create table ins_forecasted_detail
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   country              varchar(64) comment '国别
            ',
   annual_sales         decimal(18,2) comment '年销售额
            ',
   hca                  decimal(18,2) comment '赊账期内最高的曝险赊销金额
            ',
   buyers_num           int comment '买家个数
            ',
   payment_terms        varchar(64) comment '付款方式
            ',
   primary key (id)
);

alter table ins_forecasted_detail comment '未来一年内所须投保的信用销售总额表';

/*==============================================================*/
/* Table: ins_manager_detail                                    */
/*==============================================================*/
create table ins_manager_detail
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   job_title            varchar(64) comment '职务
            ',
   responsibility       varchar(64) comment '职责范围
            ',
   level                varchar(64) comment '授权等级
            ',
   credit_management_id bigint(64) comment '公司信用管理表
            ins_credit_management
            ',
   primary key (id)
);

alter table ins_manager_detail comment '负责信用风险控制和管理人员的详细资料表';

/*==============================================================*/
/* Table: ins_overdue_detail                                    */
/*==============================================================*/
create table ins_overdue_detail
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   country              varchar(64) comment '买方名称/国家
            ',
   total_debt           decimal(18,2)
                         comment '总账款余额
            ',
   debt                 decimal(18,2)
                         comment '逾期账款
            ',
   due_date             datetime comment '最早到期日
            ',
   taken                varchar(64) comment '已执行的催收方案
            ',
   bad_debt_id          bigint(64) comment '账龄及坏账分析表
            ins_bad_debt',
   primary key (id)
);

alter table ins_overdue_detail comment '逾期详细信息表';

/*==============================================================*/
/* Table: ins_past_bad_detail                                   */
/*==============================================================*/
create table ins_past_bad_detail
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   debtor               varchar(64) comment '债务人
            ',
   before_year          int comment '年份
            ',
   country              varchar(64) comment '国家
            ',
   payment_terms        varchar(64) comment '付款条件
            ',
   reason               varchar(64) comment '坏账原因
            ',
   debtamount           decimal(18,2)
                         comment '坏账金额
            ',
   bad_status  varchar(64) comment '处理现状
            ',
   bad_debt_id          bigint(64) comment '账龄及坏账分析表
            ins_bad_debt
            ',
   primary key (id)
);

alter table ins_past_bad_detail comment '过去三年中三笔最大的呆坏账详情表';

/*==============================================================*/
/* Table: ins_recent_years_sell                                 */
/*==============================================================*/
create table ins_recent_years_sell
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   financial_year       int comment '财务年度
            ',
   domestic             decimal(18,2) comment '国内贸易
            ',
   export               decimal(18,2) comment '出口贸易
            ',
   turnover_id          bigint(64) comment '销售额表
            ins_turnover',
   primary key (id)
);

alter table ins_recent_years_sell comment '最近三年销售记录表';

/*==============================================================*/
/* Table: ins_service_description                               */
/*==============================================================*/
create table ins_service_description
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint(64),
   code                 varchar(64),
   codex                varchar(64),
   product_service      varchar(64) comment '投保之产品或服务
            ',
   particularity        varchar(64) comment '业务的特殊性
            ',
   is_retention_contract int comment '合同中是否有物权保留条款
            ',
   payment_terms        varchar(64) comment '销售常用的付款方式
            ',
   period_extended      varchar(64) comment '否为买家提供较长赊账期
            ',
   primary key (id)
);

alter table ins_service_description comment '业务描述表';

/*==============================================================*/
/* Table: ins_top_buyers                                        */
/*==============================================================*/
create table ins_top_buyers
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   credit_amount        decimal(18,2)
                         comment '年赊销金额
            ',
   amount_requested     decimal(18,2)
                         comment '信用限额需求
            ',
   limit_type           varchar(64) comment '申请限额类型
            ',
   payment_terms        varchar(64) comment '结算方式
            ',
   credit_period        int comment '信用期限 （默认150天）
            ',
   reply_remark         varchar(64) comment '备注
            ',
   reply_amount         decimal(18,2)
                         comment '批复限额
            ',
   apply_type           varchar(64) comment '批复状态
            ',
   userd_amount         decimal(18,2)
                         comment '已用的 额度
            ',
   unused_amount        decimal(18,2)
                         comment '未用的额度
            ',
   buyers_id            bigint(64) comment '全球买家库对应买家
            ins_buyers
            ',
   user_id              bigint(64) comment '创建用户（前台）
            ',
   common_export_id     bigint(64) comment '企业短期
            ins_common_export
            ',
   primary key (id)
);

alter table ins_top_buyers comment '投保的前十大买家表';

/*==============================================================*/
/* Table: ins_turnover                                          */
/*==============================================================*/
create table ins_turnover
(
   id                   bigint(64) not null,
   remarks              varchar(255),
   create_by            varchar(64),
   create_time          datetime,
   update_by            varchar(64),
   update_time          datetime,
   status               smallint(1),
   company_id           varchar(64),
   idx                  bigint comment '核销内码',
   code                 varchar(64) comment '代码（外码）',
   codex                varchar(64) comment '核销外码',
   breakdowns_cash      decimal(18,4) comment '现金交易占比
            ',
   breakdowns_LC        decimal(18,4) comment '信用证交易占比
            ',
   breakdowns_associated decimal(18,4) comment '关联交易占比
            ',
   breakdowns_OA        decimal(18,4) comment '赊账交易占比 
            ',
   breakdowns_DPDA      decimal(18,4) comment '托收交易占比
            ',
   breakdowns_sum       decimal(18,4) comment '交易占比合计
            ',
   forecasted_detail_id bigint(64) comment '预计未来一年内所须投保的信用销售总额（按国别分类）
            ins_forecasted_detail',
   primary key (id)
);

alter table ins_turnover comment '销售额表';

