package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.models.order.policy.dao.InsTransactionDao;
import com.bcxin.ins.models.order.policy.service.InsTransactionService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DictConst;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.TransactionVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


/**
 * <b>交易业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsTransactionServiceImpl extends ServiceImpl<InsTransactionDao, InsTransaction> implements InsTransactionService {

	@Autowired
	private InsTransactionDao dao;

	/**
	 * <b>订单id查询所有交易详细信息 </b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsTransaction> selectInsTransactionByInsOrderForm(Long oid){
		return dao.selectInsTransactionByInsOrderForm(oid);
	}
	
	public InsTransaction initInsTransaction(){
		InsTransaction insTransaction = new InsTransaction();
		dao.insert(insTransaction);
		return insTransaction;
	}
	
	/**
	 * <b>根据List<InsTransaction>封装到 List<TransactionVo>中</b> 
	 * 
	 * @param itList
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午3:18:47
	 * @注意事项 </b>
	 * <b>
	 */
	public List<TransactionVo> packagingTransactionVoListByInsTransactionList(List<InsTransaction> itList){
		List<TransactionVo> voList = new ArrayList<TransactionVo>();
		for(InsTransaction it : itList){
			voList.add(accordingToInsTransactionIntoTransactionVo(it));
		}
		return voList;
	}
	
	/**
	 * <b>根据Vo及订单交易记录表ID更新InsTransaction数据 </b> 
	 * 
	 * @param vo
	 * @param insTransaction_id 承保信息表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheTransactionVoSetUpInsTransaction(TransactionVo vo, Long insTransaction_id){
		InsTransaction insTransaction = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insTransaction = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insTransaction = initInsTransaction();
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insTransaction);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insTransaction);
	}
	
	/**
	 * <b>根据承保信息表 封装到TransactionVo </b> 
	 * @param insTransaction 承保信息表 
	 * @return
	 * @author ZXF 
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public TransactionVo accordingToInsTransactionIntoTransactionVo(InsTransaction insTransaction) {
		TransactionVo vo = new TransactionVo();
		if(insTransaction == null){
			return vo;
		}
		vo.setOid(String.valueOf(insTransaction.getIns_transaction_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insTransaction), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vo;
	}
	
	/**
	 * <b>通过订单id获取已创建的交易信息集取第一条数据的支付地址设置到 OrderFormVo 中</b> 
	 * 
	 * @param vo
	 * @param order_id
	 * @author ZXF 
	 * @date 2017年1月14日 上午10:29:24
	 * @注意事项 </b>
	 * <b>
	 */
	public void setOrderFormVoOfShowUrlByOrderID(OrderFormVo vo, Long order_id){
		List<InsTransaction> insTransactionList = selectInsTransactionByInsOrderForm(order_id);
		if(insTransactionList.size()> ConstProp.INT_NUMBER_ZERO){
			InsTransaction insTransaction = insTransactionList.get(ConstProp.INT_NUMBER_ZERO);
			if(StrUtil.isNotBlank(insTransaction.getDeal_url())){
				vo.setShow_url(insTransaction.getDeal_url());
			}
		}
	}
	
	/**
	 * <b>页面获取上传支付信息等插入到分销,每次上传都创建一条新的记录</b> 
	 * 
	 * @param path_url 支付凭证上传路径
	 * @param insurance_slip 订单
	 * @param path_sign 支付阶段标识
	 * @author ZXF 
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	public void uploadPayMentFileToTranction(String path_url, InsInsuranceSlip insurance_slip, String path_sign){
		InsTransaction it = new InsTransaction();
		it.setStart_time(DateUtil.getTimestamp());
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		it.setTrade_serial_number(String.valueOf(idWorker.nextId()));
		it.setPayment_method(ConstProp.DIGIT_SIX);
		it.getInsurance_slip().setIns_insurance_slip_id(insurance_slip.getIns_insurance_slip_id());
		it.setUser_id(insurance_slip.getRegister_user_id());
		it.setPath_sign(path_sign);
		it.setPay_order_url(path_url);
		dao.insert(it);
	}

	/**
	 * <b>根据订单ID获取支付期标识</b> 
	 * 注：1-0指1为支付期标识号（当前需要上传凭证的位数），0指新的标识如果-1则表示可做修改
	 * @param order_id 
	 * @author ZXF 
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String accordingToOrderIDGainPathSign(String order_id) {
		List<InsTransaction> insTransactionList = selectInsTransactionByInsOrderForm(Long.parseLong(order_id));
		String pathSign = "1-0";
		if(insTransactionList != null){
			for(InsTransaction it : insTransactionList){
				if(DictConst.PAY_STATUS_WZF.equals(it.getTransaction_status())){
					pathSign = it.getPath_sign()+"-1";
				}
			}
			if("1-0".equals(pathSign)){
				pathSign = String.valueOf(insTransactionList.size()+1)+"-0";
			}
		}
		return pathSign;
	}
}
