package com.bcxin.ins.models.claim.service.impl;


import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.policy_report.InsCaseInfo;
import com.bcxin.ins.models.claim.dao.InsCaseInfoDao;
import com.bcxin.ins.models.claim.service.InsCaseInfoService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsCaseInfoVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * <b>雇主责任险雇员特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsCaseInfoServiceImpl extends ServiceImpl<InsCaseInfoDao, InsCaseInfo> implements InsCaseInfoService {

	@Autowired
	private InsCaseInfoDao dao;

	/**
	 * <b>获取InsCommonReportVo根据报案id查询附件信息插入到InsCommonReportVo </b>
	 *
	 * @param vo 报案辅助表
	 * @param report_id 报案id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getInsCommonReportVoByReportID(InsCommonReportVo vo, Long report_id){
		List<InsCaseInfoVo> list = dao.selectInsCaseInfoVoByReportId(report_id);
		int count = 0;
		if(list != null){
			if(list.size()<3){
				count = list.size();
			}else{
				count = 100;
			}
		}
		if(count == 100){
			for(int i = count;i<3;i++){
				list.add(new InsCaseInfoVo());
			}
		}
		vo.setCaseInfoVoList(list);
	}

}
